/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Set;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assume;
import org.junit.Test;

public class StringUtilTest {
    @Test
    public void testHex2ByteArray() {
        String line = "4130010A";
        byte[] result = StringUtil.hex2ByteArray((String)line);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)new byte[]{65, 48, 1, 10}));
    }

    @Test
    public void testHex2CharArray() {
        String line = "4130010A";
        char[] result = StringUtil.hex2CharArray((String)line);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)new char[]{'A', '0', '\u0001', '\n'}));
    }

    @Test
    public void testHex2CharArrayWithNull() {
        String line = null;
        char[] result = StringUtil.hex2CharArray(line);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHex2CharArrayIllegalArgumentLength() {
        String line = "4130010A0";
        StringUtil.hex2CharArray((String)line);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHex2CharArrayIllegalArgumentContent() {
        String line = "4130010A0Z";
        StringUtil.hex2CharArray((String)line);
    }

    @Test
    public void testGetUriHostname() throws URISyntaxException, UnknownHostException {
        String hostname = StringUtil.getUriHostname((InetAddress)InetAddress.getLoopbackAddress());
        MatcherAssert.assertThat((Object)hostname, (Matcher)CoreMatchers.is((Object)"127.0.0.1"));
        URI test = new URI("coap", null, hostname, 5683, null, null, null);
        MatcherAssert.assertThat((Object)test.toASCIIString(), (Matcher)CoreMatchers.is((Object)"coap://127.0.0.1:5683"));
        hostname = StringUtil.getUriHostname((InetAddress)Inet6Address.getByName("[FF02::FD]"));
        MatcherAssert.assertThat((Object)hostname, (Matcher)CoreMatchers.is((Object)"ff02:0:0:0:0:0:0:fd"));
        test = new URI("coap", null, hostname, 5683, null, null, null);
        MatcherAssert.assertThat((Object)test.toASCIIString(), (Matcher)CoreMatchers.is((Object)"coap://[ff02:0:0:0:0:0:0:fd]:5683"));
    }

    @Test
    public void testGetUriHostnameWithScope() throws URISyntaxException, UnknownHostException {
        Set scopes = NetworkInterfacesUtil.getIpv6Scopes();
        Assume.assumeFalse((String)"scope networkinterfaces required!", (boolean)scopes.isEmpty());
        String scope = (String)scopes.iterator().next();
        String hostname = StringUtil.getUriHostname((InetAddress)Inet6Address.getByName("[FF02::FD%" + scope + "]"));
        MatcherAssert.assertThat((Object)hostname, (Matcher)CoreMatchers.is((Object)("ff02:0:0:0:0:0:0:fd%25" + scope)));
        URI test = new URI("coap", null, hostname, 5683, null, null, null);
        MatcherAssert.assertThat((Object)test.toASCIIString(), (Matcher)CoreMatchers.is((Object)("coap://[ff02:0:0:0:0:0:0:fd%25" + scope + "]:5683")));
    }

    @Test
    public void testToHostString() throws URISyntaxException, UnknownHostException {
        InetSocketAddress address = new InetSocketAddress("localhost", 5683);
        MatcherAssert.assertThat((Object)StringUtil.toHostString((InetSocketAddress)address), (Matcher)CoreMatchers.is((Object)"localhost"));
        address = new InetSocketAddress("127.0.0.1", 5683);
        MatcherAssert.assertThat((Object)StringUtil.toHostString((InetSocketAddress)address), (Matcher)CoreMatchers.is((Object)"127.0.0.1"));
        address = InetSocketAddress.createUnresolved("my.test.server", 5683);
        MatcherAssert.assertThat((Object)StringUtil.toHostString((InetSocketAddress)address), (Matcher)CoreMatchers.is((Object)"my.test.server"));
        InetAddress dest = InetAddress.getByAddress(new byte[]{8, 8, 8, 8});
        address = new InetSocketAddress(dest, 5683);
        MatcherAssert.assertThat((Object)StringUtil.toHostString((InetSocketAddress)address), (Matcher)CoreMatchers.is((Object)"8.8.8.8"));
    }
}

