/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.Statistic;
import org.eclipse.californium.elements.util.TestConditionTools;
import org.eclipse.californium.elements.util.TimeStatistic;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TimeStatisticTest {
    private static final long TIME_RANGE = 5000L;
    private static final long TIME_SLOT = 5L;
    TimeStatistic statistic = new TimeStatistic(5000L, 5L, TimeUnit.MILLISECONDS);

    @Test
    public void testAvg() {
        for (int time = 20; time < 2000; time += 20) {
            this.statistic.add((long)time, TimeUnit.MILLISECONDS);
        }
        Statistic.Summary summary = this.statistic.getSummary(new int[0]);
        MatcherAssert.assertThat((String)"count", (Object)summary.getCount(), (Matcher)CoreMatchers.is((Object)99));
        MatcherAssert.assertThat((String)"average", (Object)summary.getAverage(), (Matcher)CoreMatchers.is(TestConditionTools.inRange(1000.0, 1006.0)));
        MatcherAssert.assertThat((String)"maximum", (Object)summary.getMaximum(), (Matcher)CoreMatchers.is((Object)1980L));
        this.statistic.add(4000L, TimeUnit.MILLISECONDS);
        summary = this.statistic.getSummary(new int[0]);
        MatcherAssert.assertThat((String)"maximum", (Object)summary.getMaximum(), (Matcher)CoreMatchers.is((Object)4000L));
    }

    @Test
    public void testPercentiles() {
        for (int time = 20; time < 2000; time += 20) {
            this.statistic.add((long)time, TimeUnit.MILLISECONDS);
        }
        Statistic.Summary summary = this.statistic.getSummary(new int[]{500, 900});
        MatcherAssert.assertThat((String)"count", (Object)summary.getPercentileCount(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((String)"percentil 50", (Object)summary.getPercentileValue(0), (Matcher)CoreMatchers.is(TestConditionTools.inRange(1000L, 1006L)));
        MatcherAssert.assertThat((String)"percentil 90", (Object)summary.getPercentileValue(1), (Matcher)CoreMatchers.is(TestConditionTools.inRange(1800L, 1806L)));
        this.statistic.add(4000L, TimeUnit.MILLISECONDS);
        summary = this.statistic.getSummary(new int[]{500, 900});
        MatcherAssert.assertThat((String)"percentil 50", (Object)summary.getPercentileValue(0), (Matcher)CoreMatchers.is(TestConditionTools.inRange(1000L, 1006L)));
        MatcherAssert.assertThat((String)"percentil 90", (Object)summary.getPercentileValue(1), (Matcher)CoreMatchers.is(TestConditionTools.inRange(1800L, 1806L)));
    }

    @Test
    public void testRandom() {
        int count;
        Random random = new Random();
        for (count = 0; count < 1000; ++count) {
            this.statistic.add((long)random.nextInt(200), TimeUnit.MILLISECONDS);
        }
        for (count = 0; count < 10000; ++count) {
            this.statistic.add((long)(200 + random.nextInt(800)), TimeUnit.MILLISECONDS);
        }
        for (count = 0; count < 10; ++count) {
            this.statistic.add((long)(1000 + random.nextInt(1000)), TimeUnit.MILLISECONDS);
        }
        Statistic.Summary summary = this.statistic.getSummary(new int[]{950, 990, 999});
        MatcherAssert.assertThat((String)"count", (Object)summary.getPercentileCount(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((String)"percentil 95", (Object)summary.getPercentileValue(0), (Matcher)CoreMatchers.is(TestConditionTools.inRange(900L, 1001L)));
        MatcherAssert.assertThat((String)"percentil 99", (Object)summary.getPercentileValue(1), (Matcher)CoreMatchers.is(TestConditionTools.inRange(950L, 1001L)));
        MatcherAssert.assertThat((String)"percentil 99.9", (Object)summary.getPercentileValue(2), (Matcher)CoreMatchers.is(TestConditionTools.inRange(970L, 1001L)));
    }
}

