/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class MetaJoinFieldMapper
extends MetadataFieldMapper {
    static final String NAME = "_parent_join";
    static final String CONTENT_TYPE = "parent_join";

    MetaJoinFieldMapper(String joinField) {
        super((MappedFieldType)new MetaJoinFieldType(joinField));
    }

    public MetaJoinFieldType fieldType() {
        return (MetaJoinFieldType)super.fieldType();
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        throw new IllegalStateException("Should never be called");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class MetaJoinFieldType
    extends StringFieldType {
        private final String joinField;

        public MetaJoinFieldType(String joinField) {
            super(MetaJoinFieldMapper.NAME, false, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
            this.joinField = joinField;
        }

        public String typeName() {
            return MetaJoinFieldMapper.CONTENT_TYPE;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            throw new UnsupportedOperationException("Cannot load field data for metadata field [_parent_join]");
        }

        public ValueFetcher valueFetcher(QueryShardContext context, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for metadata field [_parent_join].");
        }

        public Object valueForDisplay(Object value) {
            throw new UnsupportedOperationException();
        }

        public String getJoinField() {
            return this.joinField;
        }

        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Exists query not supported for fields of type" + this.typeName());
        }
    }
}

