/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.utils;

import java.util.Arrays;

public class SecretString
implements CharSequence,
AutoCloseable {
    private final char[] chars;

    public SecretString(CharSequence charSequence) {
        int length = charSequence.length();
        this.chars = new char[length];
        int i = 0;
        while (i < length) {
            this.chars[i] = charSequence.charAt(i);
            ++i;
        }
    }

    public SecretString(char[] chars) {
        this(chars, 0, chars.length);
    }

    public SecretString(char[] chars, int start, int end) {
        this.chars = new char[end - start];
        System.arraycopy(chars, start, this.chars, 0, this.chars.length);
    }

    @Override
    public char charAt(int index) {
        return this.chars[index];
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public int length() {
        return this.chars.length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new SecretString(this.chars, start, end);
    }

    public void clear() {
        Arrays.fill(this.chars, '\u0000');
    }

    public void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }
}

