/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.checks;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.hibernate.validator.ap.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.checks.ConstraintCheckError;
import org.hibernate.validator.ap.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveCheck
extends AbstractConstraintCheck {
    @Override
    public Set<ConstraintCheckError> checkField(VariableElement element, AnnotationMirror annotation) {
        return this.checkInternal(element, annotation, element.asType(), "ATVALID_NOT_ALLOWED_AT_PRIMITIVE_FIELD");
    }

    @Override
    public Set<ConstraintCheckError> checkMethod(ExecutableElement element, AnnotationMirror annotation) {
        return this.checkInternal(element, annotation, element.getReturnType(), "ATVALID_NOT_ALLOWED_AT_METHOD_RETURNING_PRIMITIVE_TYPE");
    }

    private Set<ConstraintCheckError> checkInternal(Element element, AnnotationMirror annotation, TypeMirror type, String messageKey) {
        if (type.getKind().isPrimitive()) {
            return CollectionHelper.asSet(new ConstraintCheckError(element, annotation, messageKey, new Object[0]));
        }
        return Collections.emptySet();
    }
}

