/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.hornetq.api.core.BroadcastGroupConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.JGroupsBroadcastGroupConfiguration;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.UDPBroadcastGroupConfiguration;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.ConnectorServiceConfiguration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.config.impl.FileConfiguration;
import org.hornetq.core.config.impl.Validators;
import org.hornetq.core.journal.impl.AIOSequentialFileFactory;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.settings.impl.SlowConsumerPolicy;
import org.hornetq.utils.DefaultSensitiveStringCodec;
import org.hornetq.utils.PasswordMaskingUtil;
import org.hornetq.utils.SensitiveDataCodec;
import org.hornetq.utils.XMLConfigurationUtil;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FileConfigurationParser
extends XMLConfigurationUtil {
    private static final String CONFIGURATION_SCHEMA_URL = "schema/hornetq-configuration.xsd";
    public static final String SECURITY_ELEMENT_NAME = "security-setting";
    private static final String PERMISSION_ELEMENT_NAME = "permission";
    private static final String TYPE_ATTR_NAME = "type";
    private static final String ROLES_ATTR_NAME = "roles";
    static final String CREATEDURABLEQUEUE_NAME = "createDurableQueue";
    private static final String DELETEDURABLEQUEUE_NAME = "deleteDurableQueue";
    private static final String CREATE_NON_DURABLE_QUEUE_NAME = "createNonDurableQueue";
    private static final String DELETE_NON_DURABLE_QUEUE_NAME = "deleteNonDurableQueue";
    private static final String CREATETEMPQUEUE_NAME = "createTempQueue";
    private static final String DELETETEMPQUEUE_NAME = "deleteTempQueue";
    private static final String SEND_NAME = "send";
    private static final String CONSUME_NAME = "consume";
    private static final String MANAGE_NAME = "manage";
    private static final String DEAD_LETTER_ADDRESS_NODE_NAME = "dead-letter-address";
    private static final String EXPIRY_ADDRESS_NODE_NAME = "expiry-address";
    private static final String EXPIRY_DELAY_NODE_NAME = "expiry-delay";
    private static final String REDELIVERY_DELAY_NODE_NAME = "redelivery-delay";
    private static final String REDELIVERY_DELAY_MULTIPLIER_NODE_NAME = "redelivery-delay-multiplier";
    private static final String MAX_REDELIVERY_DELAY_NODE_NAME = "max-redelivery-delay";
    private static final String MAX_DELIVERY_ATTEMPTS = "max-delivery-attempts";
    private static final String MAX_SIZE_BYTES_NODE_NAME = "max-size-bytes";
    private static final String ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME = "address-full-policy";
    private static final String PAGE_SIZE_BYTES_NODE_NAME = "page-size-bytes";
    private static final String PAGE_MAX_CACHE_SIZE_NODE_NAME = "page-max-cache-size";
    private static final String MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME = "message-counter-history-day-limit";
    private static final String LVQ_NODE_NAME = "last-value-queue";
    private static final String REDISTRIBUTION_DELAY_NODE_NAME = "redistribution-delay";
    private static final String SEND_TO_DLA_ON_NO_ROUTE = "send-to-dla-on-no-route";
    private static final String SLOW_CONSUMER_THRESHOLD_NODE_NAME = "slow-consumer-threshold";
    private static final String SLOW_CONSUMER_CHECK_PERIOD_NODE_NAME = "slow-consumer-check-period";
    private static final String SLOW_CONSUMER_POLICY_NODE_NAME = "slow-consumer-policy";
    private boolean validateAIO = false;

    public boolean isValidateAIO() {
        return this.validateAIO;
    }

    public void setValidateAIO(boolean validateAIO) {
        this.validateAIO = validateAIO;
    }

    public Configuration parseMainConfig(InputStream input) throws Exception {
        InputStreamReader reader = new InputStreamReader(input);
        String xml = XMLUtil.readerToString((Reader)reader);
        xml = XMLUtil.replaceSystemProps((String)xml);
        Element e = XMLUtil.stringToElement((String)xml);
        ConfigurationImpl config = new ConfigurationImpl();
        this.parseMainConfig(e, config);
        return config;
    }

    public void parseMainConfig(Element e, Configuration config) throws Exception {
        int i;
        NodeList incomingInterceptorNodes;
        XMLUtil.validate((Node)e, (String)CONFIGURATION_SCHEMA_URL);
        config.setName(FileConfigurationParser.getString(e, "name", config.getName(), Validators.NO_CHECK));
        NodeList elems = e.getElementsByTagName("clustered");
        if (elems != null && elems.getLength() > 0) {
            HornetQServerLogger.LOGGER.deprecatedConfigurationOption("clustered");
        }
        config.setCheckForLiveServer(FileConfigurationParser.getBoolean(e, "check-for-live-server", config.isClustered()));
        config.setAllowAutoFailBack(FileConfigurationParser.getBoolean(e, "allow-failback", config.isClustered()));
        config.setBackupGroupName(FileConfigurationParser.getString(e, "backup-group-name", config.getBackupGroupName(), Validators.NO_CHECK));
        config.setFailbackDelay(FileConfigurationParser.getLong(e, "failback-delay", config.getFailbackDelay(), Validators.GT_ZERO));
        config.setFailoverOnServerShutdown(FileConfigurationParser.getBoolean(e, "failover-on-shutdown", config.isFailoverOnServerShutdown()));
        config.setReplicationClustername(FileConfigurationParser.getString(e, "replication-clustername", null, Validators.NO_CHECK));
        config.setResolveProtocols(FileConfigurationParser.getBoolean(e, "resolve-protocols", config.isResolveProtocols()));
        config.setMaxSavedReplicatedJournalSize(FileConfigurationParser.getInteger(e, "max-saved-replicated-journals-size", config.getMaxSavedReplicatedJournalsSize(), Validators.MINUS_ONE_OR_GE_ZERO));
        config.setBackup(FileConfigurationParser.getBoolean(e, "backup", config.isBackup()));
        config.setSharedStore(FileConfigurationParser.getBoolean(e, "shared-store", config.isSharedStore()));
        config.setFileDeploymentEnabled(FileConfigurationParser.getBoolean(e, "file-deployment-enabled", config instanceof FileConfiguration));
        config.setPersistenceEnabled(FileConfigurationParser.getBoolean(e, "persistence-enabled", config.isPersistenceEnabled()));
        config.setPersistDeliveryCountBeforeDelivery(FileConfigurationParser.getBoolean(e, "persist-delivery-count-before-delivery", config.isPersistDeliveryCountBeforeDelivery()));
        config.setScheduledThreadPoolMaxSize(FileConfigurationParser.getInteger(e, "scheduled-thread-pool-max-size", config.getScheduledThreadPoolMaxSize(), Validators.GT_ZERO));
        config.setThreadPoolMaxSize(FileConfigurationParser.getInteger(e, "thread-pool-max-size", config.getThreadPoolMaxSize(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setSecurityEnabled(FileConfigurationParser.getBoolean(e, "security-enabled", config.isSecurityEnabled()));
        config.setJMXManagementEnabled(FileConfigurationParser.getBoolean(e, "jmx-management-enabled", config.isJMXManagementEnabled()));
        config.setJMXDomain(FileConfigurationParser.getString(e, "jmx-domain", config.getJMXDomain(), Validators.NOT_NULL_OR_EMPTY));
        config.setSecurityInvalidationInterval(FileConfigurationParser.getLong(e, "security-invalidation-interval", config.getSecurityInvalidationInterval(), Validators.GT_ZERO));
        config.setConnectionTTLOverride(FileConfigurationParser.getLong(e, "connection-ttl-override", config.getConnectionTTLOverride(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setEnabledAsyncConnectionExecution(FileConfigurationParser.getBoolean(e, "async-connection-execution-enabled", config.isAsyncConnectionExecutionEnabled()));
        config.setTransactionTimeout(FileConfigurationParser.getLong(e, "transaction-timeout", config.getTransactionTimeout(), Validators.GT_ZERO));
        config.setTransactionTimeoutScanPeriod(FileConfigurationParser.getLong(e, "transaction-timeout-scan-period", config.getTransactionTimeoutScanPeriod(), Validators.GT_ZERO));
        config.setMessageExpiryScanPeriod(FileConfigurationParser.getLong(e, "message-expiry-scan-period", config.getMessageExpiryScanPeriod(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setMessageExpiryThreadPriority(FileConfigurationParser.getInteger(e, "message-expiry-thread-priority", config.getMessageExpiryThreadPriority(), Validators.THREAD_PRIORITY_RANGE));
        config.setIDCacheSize(FileConfigurationParser.getInteger(e, "id-cache-size", config.getIDCacheSize(), Validators.GT_ZERO));
        config.setPersistIDCache(FileConfigurationParser.getBoolean(e, "persist-id-cache", config.isPersistIDCache()));
        config.setManagementAddress(new SimpleString(FileConfigurationParser.getString(e, "management-address", config.getManagementAddress().toString(), Validators.NOT_NULL_OR_EMPTY)));
        config.setManagementNotificationAddress(new SimpleString(FileConfigurationParser.getString(e, "management-notification-address", config.getManagementNotificationAddress().toString(), Validators.NOT_NULL_OR_EMPTY)));
        config.setMaskPassword(FileConfigurationParser.getBoolean(e, "mask-password", false));
        config.setPasswordCodec(FileConfigurationParser.getString(e, "password-codec", DefaultSensitiveStringCodec.class.getName(), Validators.NOT_NULL_OR_EMPTY));
        String passwordText = FileConfigurationParser.getString(e, "cluster-password", null, Validators.NO_CHECK);
        boolean maskText = config.isMaskPassword();
        if (passwordText != null) {
            if (maskText) {
                SensitiveDataCodec codec = PasswordMaskingUtil.getCodec((String)config.getPasswordCodec());
                config.setClusterPassword((String)codec.decode((Object)passwordText));
            } else {
                config.setClusterPassword(passwordText);
            }
        }
        config.setClusterUser(FileConfigurationParser.getString(e, "cluster-user", config.getClusterUser(), Validators.NO_CHECK));
        NodeList interceptorNodes = e.getElementsByTagName("remoting-interceptors");
        ArrayList<String> incomingInterceptorList = new ArrayList<String>();
        if (interceptorNodes.getLength() > 0) {
            NodeList interceptors = interceptorNodes.item(0).getChildNodes();
            for (int i2 = 0; i2 < interceptors.getLength(); ++i2) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i2).getNodeName())) continue;
                String clazz = FileConfigurationParser.getTrimmedTextContent(interceptors.item(i2));
                incomingInterceptorList.add(clazz);
            }
        }
        if ((incomingInterceptorNodes = e.getElementsByTagName("remoting-incoming-interceptors")).getLength() > 0) {
            NodeList interceptors = incomingInterceptorNodes.item(0).getChildNodes();
            for (int i3 = 0; i3 < interceptors.getLength(); ++i3) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i3).getNodeName())) continue;
                String clazz = FileConfigurationParser.getTrimmedTextContent(interceptors.item(i3));
                incomingInterceptorList.add(clazz);
            }
        }
        config.setIncomingInterceptorClassNames(incomingInterceptorList);
        NodeList outgoingInterceptorNodes = e.getElementsByTagName("remoting-outgoing-interceptors");
        ArrayList<String> outgoingInterceptorList = new ArrayList<String>();
        if (outgoingInterceptorNodes.getLength() > 0) {
            NodeList interceptors = outgoingInterceptorNodes.item(0).getChildNodes();
            for (i = 0; i < interceptors.getLength(); ++i) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i).getNodeName())) continue;
                String clazz = interceptors.item(i).getTextContent();
                outgoingInterceptorList.add(clazz);
            }
        }
        config.setOutgoingInterceptorClassNames(outgoingInterceptorList);
        NodeList connectorNodes = e.getElementsByTagName("connector");
        for (i = 0; i < connectorNodes.getLength(); ++i) {
            Element connectorNode = (Element)connectorNodes.item(i);
            TransportConfiguration connectorConfig = this.parseTransportConfiguration(connectorNode, config);
            if (connectorConfig.getName() == null) {
                HornetQServerLogger.LOGGER.connectorWithNoName();
                continue;
            }
            if (config.getConnectorConfigurations().containsKey(connectorConfig.getName())) {
                HornetQServerLogger.LOGGER.connectorAlreadyDeployed(connectorConfig.getName());
                continue;
            }
            config.getConnectorConfigurations().put(connectorConfig.getName(), connectorConfig);
        }
        NodeList acceptorNodes = e.getElementsByTagName("acceptor");
        for (int i4 = 0; i4 < acceptorNodes.getLength(); ++i4) {
            Element acceptorNode = (Element)acceptorNodes.item(i4);
            TransportConfiguration acceptorConfig = this.parseTransportConfiguration(acceptorNode, config);
            config.getAcceptorConfigurations().add(acceptorConfig);
        }
        NodeList bgNodes = e.getElementsByTagName("broadcast-group");
        for (int i5 = 0; i5 < bgNodes.getLength(); ++i5) {
            Element bgNode = (Element)bgNodes.item(i5);
            this.parseBroadcastGroupConfiguration(bgNode, config);
        }
        NodeList dgNodes = e.getElementsByTagName("discovery-group");
        for (int i6 = 0; i6 < dgNodes.getLength(); ++i6) {
            Element dgNode = (Element)dgNodes.item(i6);
            this.parseDiscoveryGroupConfiguration(dgNode, config);
        }
        NodeList brNodes = e.getElementsByTagName("bridge");
        for (int i7 = 0; i7 < brNodes.getLength(); ++i7) {
            Element mfNode = (Element)brNodes.item(i7);
            this.parseBridgeConfiguration(mfNode, config);
        }
        NodeList gaNodes = e.getElementsByTagName("grouping-handler");
        for (int i8 = 0; i8 < gaNodes.getLength(); ++i8) {
            Element gaNode = (Element)gaNodes.item(i8);
            this.parseGroupingHandlerConfiguration(gaNode, config);
        }
        NodeList ccNodes = e.getElementsByTagName("cluster-connection");
        for (int i9 = 0; i9 < ccNodes.getLength(); ++i9) {
            Element ccNode = (Element)ccNodes.item(i9);
            this.parseClusterConnectionConfiguration(ccNode, config);
        }
        NodeList dvNodes = e.getElementsByTagName("divert");
        for (int i10 = 0; i10 < dvNodes.getLength(); ++i10) {
            Element dvNode = (Element)dvNodes.item(i10);
            this.parseDivertConfiguration(dvNode, config);
        }
        config.setLargeMessagesDirectory(FileConfigurationParser.getString(e, "large-messages-directory", config.getLargeMessagesDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setBindingsDirectory(FileConfigurationParser.getString(e, "bindings-directory", config.getBindingsDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setCreateBindingsDir(FileConfigurationParser.getBoolean(e, "create-bindings-dir", config.isCreateBindingsDir()));
        config.setJournalDirectory(FileConfigurationParser.getString(e, "journal-directory", config.getJournalDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setPageMaxConcurrentIO(FileConfigurationParser.getInteger(e, "page-max-concurrent-io", config.getPageMaxConcurrentIO(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setPagingDirectory(FileConfigurationParser.getString(e, "paging-directory", config.getPagingDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setCreateJournalDir(FileConfigurationParser.getBoolean(e, "create-journal-dir", config.isCreateJournalDir()));
        String s = FileConfigurationParser.getString(e, "journal-type", config.getJournalType().toString(), Validators.JOURNAL_TYPE);
        if (s.equals(JournalType.NIO.toString())) {
            config.setJournalType(JournalType.NIO);
        } else if (s.equals(JournalType.ASYNCIO.toString())) {
            boolean supportsAIO = AIOSequentialFileFactory.isSupported();
            if (supportsAIO) {
                config.setJournalType(JournalType.ASYNCIO);
            } else {
                if (this.validateAIO) {
                    HornetQServerLogger.LOGGER.AIONotFound();
                }
                config.setJournalType(JournalType.NIO);
            }
        }
        config.setJournalSyncTransactional(FileConfigurationParser.getBoolean(e, "journal-sync-transactional", config.isJournalSyncTransactional()));
        config.setJournalSyncNonTransactional(FileConfigurationParser.getBoolean(e, "journal-sync-non-transactional", config.isJournalSyncNonTransactional()));
        config.setJournalFileSize(FileConfigurationParser.getInteger(e, "journal-file-size", config.getJournalFileSize(), Validators.GT_ZERO));
        int journalBufferTimeout = FileConfigurationParser.getInteger(e, "journal-buffer-timeout", config.getJournalType() == JournalType.ASYNCIO ? 500000 : 3333333, Validators.GT_ZERO);
        int journalBufferSize = FileConfigurationParser.getInteger(e, "journal-buffer-size", config.getJournalType() == JournalType.ASYNCIO ? 501760 : 501760, Validators.GT_ZERO);
        int journalMaxIO = FileConfigurationParser.getInteger(e, "journal-max-io", config.getJournalType() == JournalType.ASYNCIO ? HornetQDefaultConfiguration.getDefaultJournalMaxIoAio() : HornetQDefaultConfiguration.getDefaultJournalMaxIoNio(), Validators.GT_ZERO);
        if (config.getJournalType() == JournalType.ASYNCIO) {
            config.setJournalBufferTimeout_AIO(journalBufferTimeout);
            config.setJournalBufferSize_AIO(journalBufferSize);
            config.setJournalMaxIO_AIO(journalMaxIO);
        } else {
            config.setJournalBufferTimeout_NIO(journalBufferTimeout);
            config.setJournalBufferSize_NIO(journalBufferSize);
            config.setJournalMaxIO_NIO(journalMaxIO);
        }
        config.setJournalMinFiles(FileConfigurationParser.getInteger(e, "journal-min-files", config.getJournalMinFiles(), Validators.GT_ZERO));
        config.setJournalCompactMinFiles(FileConfigurationParser.getInteger(e, "journal-compact-min-files", config.getJournalCompactMinFiles(), Validators.GE_ZERO));
        config.setJournalCompactPercentage(FileConfigurationParser.getInteger(e, "journal-compact-percentage", config.getJournalCompactPercentage(), Validators.PERCENTAGE));
        config.setLogJournalWriteRate(FileConfigurationParser.getBoolean(e, "log-journal-write-rate", HornetQDefaultConfiguration.isDefaultJournalLogWriteRate()));
        config.setJournalPerfBlastPages(FileConfigurationParser.getInteger(e, "perf-blast-pages", HornetQDefaultConfiguration.getDefaultJournalPerfBlastPages(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setRunSyncSpeedTest(FileConfigurationParser.getBoolean(e, "run-sync-speed-test", config.isRunSyncSpeedTest()));
        config.setWildcardRoutingEnabled(FileConfigurationParser.getBoolean(e, "wild-card-routing-enabled", config.isWildcardRoutingEnabled()));
        config.setMessageCounterEnabled(FileConfigurationParser.getBoolean(e, "message-counter-enabled", config.isMessageCounterEnabled()));
        config.setMessageCounterSamplePeriod(FileConfigurationParser.getLong(e, "message-counter-sample-period", config.getMessageCounterSamplePeriod(), Validators.GT_ZERO));
        config.setMessageCounterMaxDayHistory(FileConfigurationParser.getInteger(e, "message-counter-max-day-history", config.getMessageCounterMaxDayHistory(), Validators.GT_ZERO));
        config.setServerDumpInterval(FileConfigurationParser.getLong(e, "server-dump-interval", config.getServerDumpInterval(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setMemoryWarningThreshold(FileConfigurationParser.getInteger(e, "memory-warning-threshold", config.getMemoryWarningThreshold(), Validators.PERCENTAGE));
        config.setMemoryMeasureInterval(FileConfigurationParser.getLong(e, "memory-measure-interval", config.getMemoryMeasureInterval(), Validators.MINUS_ONE_OR_GT_ZERO));
        this.parseAddressSettings(e, config);
        this.parseQueues(e, config);
        this.parseSecurity(e, config);
        NodeList connectorServiceConfigs = e.getElementsByTagName("connector-service");
        ArrayList<ConnectorServiceConfiguration> configs = new ArrayList<ConnectorServiceConfiguration>();
        for (int i11 = 0; i11 < connectorServiceConfigs.getLength(); ++i11) {
            Element node = (Element)connectorServiceConfigs.item(i11);
            configs.add(this.parseConnectorService(node));
        }
        config.setConnectorServiceConfigurations(configs);
        NodeList bsNodes = e.getElementsByTagName("backup-server");
        for (int i12 = 0; i12 < bsNodes.getLength(); ++i12) {
            Element bsNode = (Element)bsNodes.item(i12);
            this.parseBackupServers(bsNode, config);
        }
    }

    private void parseBackupServers(Element e, Configuration config) throws Exception {
        String name = e.getAttribute("name");
        String a = e.getAttribute("port-offset");
        int portOffset = a != null && a.length() > 0 ? Integer.valueOf(a) : 100;
        String inheritAttr = e.getAttribute("inherit-configuration");
        boolean inheritConfiguration = inheritAttr != null && inheritAttr.length() > 0 ? Boolean.valueOf(inheritAttr) : true;
        Configuration backupConfiguration = inheritConfiguration ? config.copy() : new ConfigurationImpl();
        backupConfiguration.setName(name);
        Set<TransportConfiguration> acceptors = backupConfiguration.getAcceptorConfigurations();
        for (TransportConfiguration transportConfiguration : acceptors) {
            this.updatebackupParams(name, portOffset, transportConfiguration.getParams());
        }
        Map<String, TransportConfiguration> connectorConfigurations = backupConfiguration.getConnectorConfigurations();
        for (Map.Entry<String, TransportConfiguration> entry : connectorConfigurations.entrySet()) {
            this.updatebackupParams(name, portOffset, entry.getValue().getParams());
        }
        backupConfiguration.setJournalDirectory(backupConfiguration.getJournalDirectory() + "/" + name);
        backupConfiguration.setBindingsDirectory(backupConfiguration.getBindingsDirectory() + "/" + name);
        backupConfiguration.setPagingDirectory(backupConfiguration.getPagingDirectory() + "/" + name);
        backupConfiguration.setLargeMessagesDirectory(backupConfiguration.getLargeMessagesDirectory() + "/" + name);
        backupConfiguration.setBackup(true);
        NodeList nodeList = e.getElementsByTagName("configuration");
        if (nodeList.getLength() > 0) {
            this.parseMainConfig((Element)nodeList.item(0), backupConfiguration);
        }
        config.getBackupServerConfigurations().add(backupConfiguration);
    }

    private void updatebackupParams(String name, int portOffset, Map<String, Object> params) {
        if (params != null) {
            Object serverId;
            Object port = params.get("port");
            if (port != null) {
                Integer integer = Integer.valueOf(port.toString());
                integer = integer + portOffset;
                params.put("port", integer.toString());
            }
            if ((serverId = params.get("server-id")) != null) {
                params.put("server-id", serverId.toString() + "(" + name + ")");
            }
        }
    }

    private void parseSecurity(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("security-settings");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName(SECURITY_ELEMENT_NAME);
            for (int i = 0; i < list.getLength(); ++i) {
                Pair<String, Set<Role>> securityItem = this.parseSecurityRoles(list.item(i));
                config.getSecurityRoles().put((String)securityItem.getA(), (Set<Role>)securityItem.getB());
            }
        }
    }

    private void parseQueues(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("queues");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName("queue");
            for (int i = 0; i < list.getLength(); ++i) {
                CoreQueueConfiguration queueConfig = this.parseQueueConfiguration(list.item(i));
                config.getQueueConfigurations().add(queueConfig);
            }
        }
    }

    private void parseAddressSettings(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("address-settings");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName("address-setting");
            for (int i = 0; i < list.getLength(); ++i) {
                Pair<String, AddressSettings> addressSettings = this.parseAddressSettings(list.item(i));
                config.getAddressesSettings().put((String)addressSettings.getA(), (AddressSettings)addressSettings.getB());
            }
        }
    }

    protected Pair<String, Set<Role>> parseSecurityRoles(Node node) {
        String match = node.getAttributes().getNamedItem("match").getNodeValue();
        HashSet<Role> securityRoles = new HashSet<Role>();
        Pair securityMatch = new Pair((Object)match, securityRoles);
        ArrayList<String> send = new ArrayList<String>();
        ArrayList<String> consume = new ArrayList<String>();
        ArrayList<String> createDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteDurableQueue = new ArrayList<String>();
        ArrayList<String> createNonDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteNonDurableQueue = new ArrayList<String>();
        ArrayList<String> manageRoles = new ArrayList<String>();
        ArrayList<String> allRoles = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String[] roles;
            Node child = children.item(i);
            String name = child.getNodeName();
            if (!PERMISSION_ELEMENT_NAME.equalsIgnoreCase(name)) continue;
            String type = FileConfigurationParser.getAttributeValue(child, TYPE_ATTR_NAME);
            String roleString = FileConfigurationParser.getAttributeValue(child, ROLES_ATTR_NAME);
            for (String role : roles = roleString.split(",")) {
                if (SEND_NAME.equals(type)) {
                    send.add(role.trim());
                } else if (CONSUME_NAME.equals(type)) {
                    consume.add(role.trim());
                } else if (CREATEDURABLEQUEUE_NAME.equals(type)) {
                    createDurableQueue.add(role.trim());
                } else if (DELETEDURABLEQUEUE_NAME.equals(type)) {
                    deleteDurableQueue.add(role.trim());
                } else if (CREATE_NON_DURABLE_QUEUE_NAME.equals(type)) {
                    createNonDurableQueue.add(role.trim());
                } else if (DELETE_NON_DURABLE_QUEUE_NAME.equals(type)) {
                    deleteNonDurableQueue.add(role.trim());
                } else if (CREATETEMPQUEUE_NAME.equals(type)) {
                    createNonDurableQueue.add(role.trim());
                } else if (DELETETEMPQUEUE_NAME.equals(type)) {
                    deleteNonDurableQueue.add(role.trim());
                } else if (MANAGE_NAME.equals(type)) {
                    manageRoles.add(role.trim());
                } else {
                    HornetQServerLogger.LOGGER.rolePermissionConfigurationError(type);
                }
                if (allRoles.contains(role.trim())) continue;
                allRoles.add(role.trim());
            }
        }
        for (String role : allRoles) {
            securityRoles.add(new Role(role, send.contains(role), consume.contains(role), createDurableQueue.contains(role), deleteDurableQueue.contains(role), createNonDurableQueue.contains(role), deleteNonDurableQueue.contains(role), manageRoles.contains(role)));
        }
        return securityMatch;
    }

    protected Pair<String, AddressSettings> parseAddressSettings(Node node) {
        String match = FileConfigurationParser.getAttributeValue(node, "match");
        NodeList children = node.getChildNodes();
        AddressSettings addressSettings = new AddressSettings();
        Pair setting = new Pair((Object)match, (Object)addressSettings);
        for (int i = 0; i < children.getLength(); ++i) {
            Object policy;
            Node child = children.item(i);
            String name = child.getNodeName();
            if (DEAD_LETTER_ADDRESS_NODE_NAME.equalsIgnoreCase(name)) {
                SimpleString queueName = new SimpleString(FileConfigurationParser.getTrimmedTextContent(child));
                addressSettings.setDeadLetterAddress(queueName);
                continue;
            }
            if (EXPIRY_ADDRESS_NODE_NAME.equalsIgnoreCase(name)) {
                SimpleString queueName = new SimpleString(FileConfigurationParser.getTrimmedTextContent(child));
                addressSettings.setExpiryAddress(queueName);
                continue;
            }
            if (EXPIRY_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setExpiryDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (REDELIVERY_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setRedeliveryDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (REDELIVERY_DELAY_MULTIPLIER_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setRedeliveryMultiplier(XMLUtil.parseDouble((Node)child));
                continue;
            }
            if (MAX_REDELIVERY_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMaxRedeliveryDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (MAX_SIZE_BYTES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMaxSizeBytes(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (PAGE_SIZE_BYTES_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setPageSizeBytes(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (PAGE_MAX_CACHE_SIZE_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setPageCacheMaxSize(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setMessageCounterHistoryDayLimit(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME.equalsIgnoreCase(name)) {
                String value = FileConfigurationParser.getTrimmedTextContent(child);
                Validators.ADDRESS_FULL_MESSAGE_POLICY_TYPE.validate(ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME, value);
                policy = Enum.valueOf(AddressFullMessagePolicy.class, value);
                addressSettings.setAddressFullMessagePolicy((AddressFullMessagePolicy)policy);
                continue;
            }
            if (LVQ_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setLastValueQueue(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (MAX_DELIVERY_ATTEMPTS.equalsIgnoreCase(name)) {
                addressSettings.setMaxDeliveryAttempts(XMLUtil.parseInt((Node)child));
                continue;
            }
            if (REDISTRIBUTION_DELAY_NODE_NAME.equalsIgnoreCase(name)) {
                addressSettings.setRedistributionDelay(XMLUtil.parseLong((Node)child));
                continue;
            }
            if (SEND_TO_DLA_ON_NO_ROUTE.equalsIgnoreCase(name)) {
                addressSettings.setSendToDLAOnNoRoute(XMLUtil.parseBoolean((Node)child));
                continue;
            }
            if (SLOW_CONSUMER_THRESHOLD_NODE_NAME.equalsIgnoreCase(name)) {
                long slowConsumerThreshold = XMLUtil.parseLong((Node)child);
                Validators.MINUS_ONE_OR_GT_ZERO.validate(SLOW_CONSUMER_THRESHOLD_NODE_NAME, slowConsumerThreshold);
                addressSettings.setSlowConsumerThreshold(slowConsumerThreshold);
                continue;
            }
            if (SLOW_CONSUMER_CHECK_PERIOD_NODE_NAME.equalsIgnoreCase(name)) {
                long slowConsumerCheckPeriod = XMLUtil.parseLong((Node)child);
                Validators.GT_ZERO.validate(SLOW_CONSUMER_CHECK_PERIOD_NODE_NAME, slowConsumerCheckPeriod);
                addressSettings.setSlowConsumerCheckPeriod(slowConsumerCheckPeriod);
                continue;
            }
            if (!SLOW_CONSUMER_POLICY_NODE_NAME.equalsIgnoreCase(name)) continue;
            String value = FileConfigurationParser.getTrimmedTextContent(child);
            Validators.SLOW_CONSUMER_POLICY_TYPE.validate(SLOW_CONSUMER_POLICY_NODE_NAME, value);
            policy = Enum.valueOf(SlowConsumerPolicy.class, value);
            addressSettings.setSlowConsumerPolicy((SlowConsumerPolicy)((Object)policy));
        }
        return setting;
    }

    protected CoreQueueConfiguration parseQueueConfiguration(Node node) {
        String name = FileConfigurationParser.getAttributeValue(node, "name");
        String address = null;
        String filterString = null;
        boolean durable = true;
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("address")) {
                address = FileConfigurationParser.getTrimmedTextContent(child);
                continue;
            }
            if (child.getNodeName().equals("filter")) {
                filterString = FileConfigurationParser.getAttributeValue(child, "string");
                continue;
            }
            if (!child.getNodeName().equals("durable")) continue;
            durable = XMLUtil.parseBoolean((Node)child);
        }
        return new CoreQueueConfiguration(address, name, filterString, durable);
    }

    private TransportConfiguration parseTransportConfiguration(Element e, Configuration mainConfig) {
        Node nameNode = e.getAttributes().getNamedItem("name");
        String name = nameNode != null ? nameNode.getNodeValue() : null;
        String clazz = FileConfigurationParser.getString(e, "factory-class", null, Validators.NOT_NULL_OR_EMPTY);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (mainConfig.isMaskPassword()) {
            params.put(HornetQDefaultConfiguration.getPropMaskPassword(), mainConfig.isMaskPassword());
            if (mainConfig.getPasswordCodec() != null) {
                params.put(HornetQDefaultConfiguration.getPropPasswordCodec(), mainConfig.getPasswordCodec());
            }
        }
        NodeList paramsNodes = e.getElementsByTagName("param");
        for (int i = 0; i < paramsNodes.getLength(); ++i) {
            Node paramNode = paramsNodes.item(i);
            NamedNodeMap attributes = paramNode.getAttributes();
            Node nkey = attributes.getNamedItem("key");
            String key = nkey.getTextContent();
            Node nValue = attributes.getNamedItem("value");
            params.put(key, nValue.getTextContent());
        }
        return new TransportConfiguration(clazz, params, name);
    }

    private void parseBroadcastGroupConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute("name");
        ArrayList<String> connectorNames = new ArrayList<String>();
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!child.getNodeName().equals("connector-ref")) continue;
            String connectorName = FileConfigurationParser.getString(e, "connector-ref", null, Validators.NOT_NULL_OR_EMPTY);
            connectorNames.add(connectorName);
        }
        long broadcastPeriod = FileConfigurationParser.getLong(e, "broadcast-period", HornetQDefaultConfiguration.getDefaultBroadcastPeriod(), Validators.GT_ZERO);
        String localAddress = FileConfigurationParser.getString(e, "local-bind-address", null, Validators.NO_CHECK);
        int localBindPort = FileConfigurationParser.getInteger(e, "local-bind-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String groupAddress = FileConfigurationParser.getString(e, "group-address", null, Validators.NO_CHECK);
        int groupPort = FileConfigurationParser.getInteger(e, "group-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String jgroupsFile = FileConfigurationParser.getString(e, "jgroups-file", null, Validators.NO_CHECK);
        String jgroupsChannel = FileConfigurationParser.getString(e, "jgroups-channel", null, Validators.NO_CHECK);
        Object endpointFactoryConfiguration = jgroupsFile != null ? new JGroupsBroadcastGroupConfiguration(jgroupsFile, jgroupsChannel) : new UDPBroadcastGroupConfiguration(groupAddress, groupPort, localAddress, localBindPort);
        BroadcastGroupConfiguration config = new BroadcastGroupConfiguration(name, broadcastPeriod, connectorNames, (BroadcastEndpointFactoryConfiguration)endpointFactoryConfiguration);
        mainConfig.getBroadcastGroupConfigurations().add(config);
    }

    private void parseDiscoveryGroupConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute("name");
        long discoveryInitialWaitTimeout = FileConfigurationParser.getLong(e, "initial-wait-timeout", 10000L, Validators.GT_ZERO);
        long refreshTimeout = FileConfigurationParser.getLong(e, "refresh-timeout", HornetQDefaultConfiguration.getDefaultBroadcastRefreshTimeout(), Validators.GT_ZERO);
        String localBindAddress = FileConfigurationParser.getString(e, "local-bind-address", null, Validators.NO_CHECK);
        int localBindPort = FileConfigurationParser.getInteger(e, "local-bind-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String groupAddress = FileConfigurationParser.getString(e, "group-address", null, Validators.NO_CHECK);
        int groupPort = FileConfigurationParser.getInteger(e, "group-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String jgroupsFile = FileConfigurationParser.getString(e, "jgroups-file", null, Validators.NO_CHECK);
        String jgroupsChannel = FileConfigurationParser.getString(e, "jgroups-channel", null, Validators.NO_CHECK);
        Object endpointFactoryConfiguration = jgroupsFile != null ? new JGroupsBroadcastGroupConfiguration(jgroupsFile, jgroupsChannel) : new UDPBroadcastGroupConfiguration(groupAddress, groupPort, localBindAddress, localBindPort);
        DiscoveryGroupConfiguration config = new DiscoveryGroupConfiguration(name, refreshTimeout, discoveryInitialWaitTimeout, (BroadcastEndpointFactoryConfiguration)endpointFactoryConfiguration);
        if (mainConfig.getDiscoveryGroupConfigurations().containsKey(name)) {
            HornetQServerLogger.LOGGER.discoveryGroupAlreadyDeployed(name);
            return;
        }
        mainConfig.getDiscoveryGroupConfigurations().put(name, config);
    }

    private void parseClusterConnectionConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute("name");
        String address = FileConfigurationParser.getString(e, "address", null, Validators.NOT_NULL_OR_EMPTY);
        String connectorName = FileConfigurationParser.getString(e, "connector-ref", null, Validators.NOT_NULL_OR_EMPTY);
        boolean duplicateDetection = FileConfigurationParser.getBoolean(e, "use-duplicate-detection", HornetQDefaultConfiguration.isDefaultClusterDuplicateDetection());
        boolean forwardWhenNoConsumers = FileConfigurationParser.getBoolean(e, "forward-when-no-consumers", HornetQDefaultConfiguration.isDefaultClusterForwardWhenNoConsumers());
        int maxHops = FileConfigurationParser.getInteger(e, "max-hops", HornetQDefaultConfiguration.getDefaultClusterMaxHops(), Validators.GE_ZERO);
        long clientFailureCheckPeriod = FileConfigurationParser.getLong(e, "check-period", HornetQDefaultConfiguration.getDefaultClusterFailureCheckPeriod(), Validators.GT_ZERO);
        long connectionTTL = FileConfigurationParser.getLong(e, "connection-ttl", HornetQDefaultConfiguration.getDefaultClusterConnectionTtl(), Validators.GT_ZERO);
        long retryInterval = FileConfigurationParser.getLong(e, "retry-interval", HornetQDefaultConfiguration.getDefaultClusterRetryInterval(), Validators.GT_ZERO);
        long callTimeout = FileConfigurationParser.getLong(e, "call-timeout", 30000L, Validators.GT_ZERO);
        long callFailoverTimeout = FileConfigurationParser.getLong(e, "call-failover-timeout", -1L, Validators.MINUS_ONE_OR_GT_ZERO);
        double retryIntervalMultiplier = FileConfigurationParser.getDouble(e, "retry-interval-multiplier", HornetQDefaultConfiguration.getDefaultClusterRetryIntervalMultiplier(), Validators.GT_ZERO);
        int minLargeMessageSize = FileConfigurationParser.getInteger(e, "min-large-message-size", 102400, Validators.GT_ZERO);
        long maxRetryInterval = FileConfigurationParser.getLong(e, "max-retry-interval", HornetQDefaultConfiguration.getDefaultClusterMaxRetryInterval(), Validators.GT_ZERO);
        int initialConnectAttempts = FileConfigurationParser.getInteger(e, "initial-connect-attempts", HornetQDefaultConfiguration.getDefaultClusterInitialConnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int reconnectAttempts = FileConfigurationParser.getInteger(e, "reconnect-attempts", HornetQDefaultConfiguration.getDefaultClusterReconnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int confirmationWindowSize = FileConfigurationParser.getInteger(e, "confirmation-window-size", 0x100000, Validators.GT_ZERO);
        long clusterNotificationInterval = FileConfigurationParser.getLong(e, "notification-interval", HornetQDefaultConfiguration.getDefaultClusterNotificationInterval(), Validators.GT_ZERO);
        int clusterNotificationAttempts = FileConfigurationParser.getInteger(e, "notification-attempts", HornetQDefaultConfiguration.getDefaultClusterNotificationAttempts(), Validators.GT_ZERO);
        String discoveryGroupName = null;
        ArrayList<String> staticConnectorNames = new ArrayList<String>();
        boolean allowDirectConnectionsOnly = false;
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("discovery-group-ref")) {
                discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                continue;
            }
            if (!child.getNodeName().equals("static-connectors")) continue;
            Node attr = child.getAttributes().getNamedItem("allow-direct-connections-only");
            if (attr != null) {
                allowDirectConnectionsOnly = "true".equalsIgnoreCase(attr.getNodeValue()) || allowDirectConnectionsOnly;
            }
            this.getStaticConnectors(staticConnectorNames, child);
        }
        ClusterConnectionConfiguration config = discoveryGroupName == null ? new ClusterConnectionConfiguration(name, address, connectorName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, retryIntervalMultiplier, maxRetryInterval, initialConnectAttempts, reconnectAttempts, callTimeout, callFailoverTimeout, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, staticConnectorNames, allowDirectConnectionsOnly, clusterNotificationInterval, clusterNotificationAttempts) : new ClusterConnectionConfiguration(name, address, connectorName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, retryIntervalMultiplier, maxRetryInterval, initialConnectAttempts, reconnectAttempts, callTimeout, callFailoverTimeout, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, discoveryGroupName, clusterNotificationInterval, clusterNotificationAttempts);
        mainConfig.getClusterConfigurations().add(config);
    }

    private void parseGroupingHandlerConfiguration(Element node, Configuration mainConfiguration) {
        String name = node.getAttribute("name");
        String type = FileConfigurationParser.getString(node, TYPE_ATTR_NAME, null, Validators.NOT_NULL_OR_EMPTY);
        String address = FileConfigurationParser.getString(node, "address", null, Validators.NOT_NULL_OR_EMPTY);
        Integer timeout = FileConfigurationParser.getInteger(node, "timeout", 5000, Validators.GT_ZERO);
        Long groupTimeout = FileConfigurationParser.getLong(node, "group-timeout", -1L, Validators.MINUS_ONE_OR_GT_ZERO);
        Long reaperPeriod = FileConfigurationParser.getLong(node, "reaper-period", 30000L, Validators.GT_ZERO);
        mainConfiguration.setGroupingHandlerConfiguration(new GroupingHandlerConfiguration(new SimpleString(name), type.equals(GroupingHandlerConfiguration.TYPE.LOCAL.getType()) ? GroupingHandlerConfiguration.TYPE.LOCAL : GroupingHandlerConfiguration.TYPE.REMOTE, new SimpleString(address), timeout, groupTimeout, reaperPeriod));
    }

    private void parseBridgeConfiguration(Element brNode, Configuration mainConfig) throws Exception {
        String name = brNode.getAttribute("name");
        String queueName = FileConfigurationParser.getString(brNode, "queue-name", null, Validators.NOT_NULL_OR_EMPTY);
        String forwardingAddress = FileConfigurationParser.getString(brNode, "forwarding-address", null, Validators.NO_CHECK);
        String transformerClassName = FileConfigurationParser.getString(brNode, "transformer-class-name", null, Validators.NO_CHECK);
        int confirmationWindowSize = FileConfigurationParser.getInteger(brNode, "confirmation-window-size", 0x100000, Validators.GT_ZERO);
        long retryInterval = FileConfigurationParser.getLong(brNode, "retry-interval", 2000L, Validators.GT_ZERO);
        long clientFailureCheckPeriod = FileConfigurationParser.getLong(brNode, "check-period", HornetQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, Validators.GT_ZERO);
        long connectionTTL = FileConfigurationParser.getLong(brNode, "connection-ttl", HornetQClient.DEFAULT_CONNECTION_TTL, Validators.GT_ZERO);
        int minLargeMessageSize = FileConfigurationParser.getInteger(brNode, "min-large-message-size", 102400, Validators.GT_ZERO);
        long maxRetryInterval = FileConfigurationParser.getLong(brNode, "max-retry-interval", HornetQClient.DEFAULT_MAX_RETRY_INTERVAL, Validators.GT_ZERO);
        double retryIntervalMultiplier = FileConfigurationParser.getDouble(brNode, "retry-interval-multiplier", HornetQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, Validators.GT_ZERO);
        int initialConnectAttempts = FileConfigurationParser.getInteger(brNode, "initial-connect-attempts", HornetQDefaultConfiguration.getDefaultBridgeInitialConnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int reconnectAttempts = FileConfigurationParser.getInteger(brNode, "reconnect-attempts", HornetQDefaultConfiguration.getDefaultBridgeReconnectAttempts(), Validators.MINUS_ONE_OR_GE_ZERO);
        int reconnectAttemptsSameNode = FileConfigurationParser.getInteger(brNode, "reconnect-attempts-same-node", HornetQDefaultConfiguration.getDefaultBridgeConnectSameNode(), Validators.MINUS_ONE_OR_GE_ZERO);
        boolean useDuplicateDetection = FileConfigurationParser.getBoolean(brNode, "use-duplicate-detection", HornetQDefaultConfiguration.isDefaultBridgeDuplicateDetection());
        String user = FileConfigurationParser.getString(brNode, "user", HornetQDefaultConfiguration.getDefaultClusterUser(), Validators.NO_CHECK);
        NodeList clusterPassNodes = brNode.getElementsByTagName("password");
        String password = null;
        boolean maskPassword = mainConfig.isMaskPassword();
        SensitiveDataCodec codec = null;
        if (clusterPassNodes.getLength() > 0) {
            Node passNode = clusterPassNodes.item(0);
            password = passNode.getTextContent();
        }
        if (password != null) {
            if (maskPassword) {
                codec = PasswordMaskingUtil.getCodec((String)mainConfig.getPasswordCodec());
                password = (String)codec.decode((Object)password);
            }
        } else {
            password = HornetQDefaultConfiguration.getDefaultClusterPassword();
        }
        boolean ha = FileConfigurationParser.getBoolean(brNode, "ha", false);
        String filterString = null;
        ArrayList<String> staticConnectorNames = new ArrayList<String>();
        String discoveryGroupName = null;
        NodeList children = brNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("filter")) {
                filterString = child.getAttributes().getNamedItem("string").getNodeValue();
                continue;
            }
            if (child.getNodeName().equals("discovery-group-ref")) {
                discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                continue;
            }
            if (!child.getNodeName().equals("static-connectors")) continue;
            this.getStaticConnectors(staticConnectorNames, child);
        }
        BridgeConfiguration config = !staticConnectorNames.isEmpty() ? new BridgeConfiguration(name, queueName, forwardingAddress, filterString, transformerClassName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, maxRetryInterval, retryIntervalMultiplier, initialConnectAttempts, reconnectAttempts, reconnectAttemptsSameNode, useDuplicateDetection, confirmationWindowSize, staticConnectorNames, ha, user, password) : new BridgeConfiguration(name, queueName, forwardingAddress, filterString, transformerClassName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, maxRetryInterval, retryIntervalMultiplier, initialConnectAttempts, reconnectAttempts, reconnectAttemptsSameNode, useDuplicateDetection, confirmationWindowSize, discoveryGroupName, ha, user, password);
        mainConfig.getBridgeConfigurations().add(config);
    }

    private void getStaticConnectors(List<String> staticConnectorNames, Node child) {
        NodeList children2 = ((Element)child).getElementsByTagName("connector-ref");
        for (int k = 0; k < children2.getLength(); ++k) {
            Element child2 = (Element)children2.item(k);
            String connectorName = child2.getChildNodes().item(0).getNodeValue();
            staticConnectorNames.add(connectorName);
        }
    }

    private void parseDivertConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute("name");
        String routingName = FileConfigurationParser.getString(e, "routing-name", null, Validators.NO_CHECK);
        String address = FileConfigurationParser.getString(e, "address", null, Validators.NOT_NULL_OR_EMPTY);
        String forwardingAddress = FileConfigurationParser.getString(e, "forwarding-address", null, Validators.NOT_NULL_OR_EMPTY);
        boolean exclusive = FileConfigurationParser.getBoolean(e, "exclusive", HornetQDefaultConfiguration.isDefaultDivertExclusive());
        String transformerClassName = FileConfigurationParser.getString(e, "transformer-class-name", null, Validators.NO_CHECK);
        String filterString = null;
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!child.getNodeName().equals("filter")) continue;
            filterString = FileConfigurationParser.getAttributeValue(child, "string");
        }
        DivertConfiguration config = new DivertConfiguration(name, routingName, address, forwardingAddress, exclusive, filterString, transformerClassName);
        mainConfig.getDivertConfigurations().add(config);
    }

    private ConnectorServiceConfiguration parseConnectorService(Element e) {
        Node nameNode = e.getAttributes().getNamedItem("name");
        String name = nameNode != null ? nameNode.getNodeValue() : null;
        String clazz = FileConfigurationParser.getString(e, "factory-class", null, Validators.NOT_NULL_OR_EMPTY);
        HashMap<String, Object> params = new HashMap<String, Object>();
        NodeList paramsNodes = e.getElementsByTagName("param");
        for (int i = 0; i < paramsNodes.getLength(); ++i) {
            Node paramNode = paramsNodes.item(i);
            NamedNodeMap attributes = paramNode.getAttributes();
            Node nkey = attributes.getNamedItem("key");
            String key = nkey.getTextContent();
            Node nValue = attributes.getNamedItem("value");
            params.put(key, nValue.getTextContent());
        }
        return new ConnectorServiceConfiguration(clazz, params, name);
    }
}

