/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.channel.Channel;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.VersionedOperationResponse;
import org.infinispan.client.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.client.hotrod.impl.operations.DelegatingCacheOperationsFactory;
import org.infinispan.client.hotrod.impl.operations.GetStreamStartResponse;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.operations.PutStreamResponse;
import org.infinispan.client.hotrod.impl.operations.RoutingObjectOperation;
import org.infinispan.client.hotrod.marshall.MediaTypeMarshaller;

public class ServerRoutingCacheOperationsFactory
extends DelegatingCacheOperationsFactory {
    public ServerRoutingCacheOperationsFactory(CacheOperationsFactory delegate) {
        super(delegate);
    }

    private <V> HotRodOperation<V> wrapAsNecessary(HotRodOperation<V> op, Object key) {
        InternalRemoteCache<?, ?> irc = this.getRemoteCache();
        DataFormat format = irc.getDataFormat();
        MediaTypeMarshaller serverFormat = format.server();
        if (serverFormat == null || serverFormat.equals(format.client())) {
            return op;
        }
        return new RoutingObjectOperation<V>(op, serverFormat.keyToBytes(key));
    }

    @Override
    public <V> HotRodOperation<V> newGetOperation(Object key) {
        return this.wrapAsNecessary(super.newGetOperation(key), key);
    }

    @Override
    public <K, V> HotRodOperation<GetWithMetadataOperation.GetWithMetadataResult<V>> newGetWithMetadataOperation(K key, Channel preferredChannel) {
        return this.wrapAsNecessary(super.newGetWithMetadataOperation(key, preferredChannel), key);
    }

    @Override
    public <V> HotRodOperation<MetadataValue<V>> newRemoveOperation(Object key) {
        return this.wrapAsNecessary(super.newRemoveOperation(key), key);
    }

    @Override
    public <K, V> HotRodOperation<MetadataValue<V>> newPutKeyValueOperation(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.wrapAsNecessary(super.newPutKeyValueOperation(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit), key);
    }

    @Override
    public <K, V> HotRodOperation<MetadataValue<V>> newPutIfAbsentOperation(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.wrapAsNecessary(super.newPutIfAbsentOperation(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit), key);
    }

    @Override
    public <K, V> HotRodOperation<MetadataValue<V>> newPutIfAbsentOperation(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, Flag ... flags) {
        return this.wrapAsNecessary(super.newPutIfAbsentOperation(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, flags), key);
    }

    @Override
    public <K, V> HotRodOperation<V> newReplaceOperation(K key, V valueBytes, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.wrapAsNecessary(super.newReplaceOperation(key, valueBytes, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit), key);
    }

    @Override
    public <K, V> HotRodOperation<VersionedOperationResponse<V>> newReplaceIfUnmodifiedOperation(K key, V value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, long version) {
        return this.wrapAsNecessary(super.newReplaceIfUnmodifiedOperation(key, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, version), key);
    }

    @Override
    public <K, V> HotRodOperation<VersionedOperationResponse<V>> newRemoveIfUnmodifiedOperation(K key, long version) {
        return this.wrapAsNecessary(super.newRemoveIfUnmodifiedOperation(key, version), key);
    }

    @Override
    public <K> HotRodOperation<Boolean> newContainsKeyOperation(K key) {
        return this.wrapAsNecessary(super.newContainsKeyOperation(key), key);
    }

    @Override
    public <T> HotRodOperation<T> executeOperation(String taskName, Map<String, byte[]> marshalledParams, Object key) {
        return this.wrapAsNecessary(super.executeOperation(taskName, marshalledParams, key), key);
    }

    @Override
    public HotRodOperation<GetStreamStartResponse> newGetStreamStartOperation(Object key, int batchSize) {
        return this.wrapAsNecessary(super.newGetStreamStartOperation(key, batchSize), key);
    }

    @Override
    public HotRodOperation<PutStreamResponse> newPutStreamStartOperation(Object key, long version, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.wrapAsNecessary(super.newPutStreamStartOperation(key, version, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit), key);
    }

    @Override
    protected DelegatingCacheOperationsFactory newFactoryFor(CacheOperationsFactory factory) {
        return new ServerRoutingCacheOperationsFactory(factory);
    }
}

