/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.ContextBuilder;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.transaction.impl.LocalTransaction;

public abstract class AbstractCacheBackedSet<K, V, E>
implements CacheSet<E> {
    protected final CacheImpl<K, V> cache;
    protected final Object lockOwner;
    protected final long explicitFlags;
    private final int batchSize;
    private final ClusterPublisherManager<K, V> clusterPublisherManager;
    private final ClusterPublisherManager<K, V> localPublisherManager;
    private final Executor nonBlockingExecutor;

    public AbstractCacheBackedSet(CacheImpl<K, V> cache, Object lockOwner, long explicitFlags) {
        this.cache = cache;
        this.lockOwner = lockOwner;
        this.explicitFlags = explicitFlags;
        this.batchSize = cache.config.clustering().stateTransfer().chunkSize();
        this.clusterPublisherManager = cache.componentRegistry.getComponent(ClusterPublisherManager.class);
        this.localPublisherManager = cache.componentRegistry.getComponent(ClusterPublisherManager.class, "NoClusterPublisherManager");
        this.nonBlockingExecutor = cache.componentRegistry.getComponent(Executor.class, "org.infinispan.executors.non-blocking");
    }

    public int size() {
        return this.cache.size(this.explicitFlags);
    }

    public boolean isEmpty() {
        return this.getStream(false).noneMatch(StreamMarshalling.alwaysTruePredicate());
    }

    public abstract boolean contains(Object var1);

    public CloseableIterator<E> iterator() {
        final CacheStream<E> stream = this.getStream(false);
        final Iterator<E> iterator = stream.iterator();
        return new CloseableIterator<E>(){
            private E last;

            public void close() {
                stream.close();
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public E next() {
                this.last = iterator.next();
                return AbstractCacheBackedSet.this.wrapElement(this.last);
            }

            public void remove() {
                Object key = AbstractCacheBackedSet.this.extractKey(this.last);
                AbstractCacheBackedSet.this.cache.remove(key, AbstractCacheBackedSet.this.explicitFlags, AbstractCacheBackedSet.this.decoratedWriteContextBuilder());
            }
        };
    }

    public void forEach(Consumer<? super E> action) {
        try (CacheStream<E> stream = this.getStream(false);){
            Iterator<? super E> iterator = stream.iterator();
            iterator.forEachRemaining(action);
        }
    }

    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    public <T> T[] toArray(T[] a) {
        return this.stream().toArray(n -> (Object[])Array.newInstance(a.getClass().getComponentType(), n));
    }

    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        Object key = this.entryToKeyFunction() != null ? this.extractKey(o) : o;
        V removedValue = this.cache.remove(key, this.explicitFlags, this.decoratedWriteContextBuilder());
        return removedValue != null;
    }

    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    public boolean removeIf(Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        try (CacheStream<E> stream = this.getStream(false);){
            Iterator<E> iterator = stream.iterator();
            while (iterator.hasNext()) {
                E next = iterator.next();
                if (!filter.test(next)) continue;
                Object key = this.extractKey(next);
                this.cache.remove(key, this.explicitFlags, this.decoratedWriteContextBuilder());
                removed = true;
            }
        }
        return removed;
    }

    public boolean retainAll(Collection<?> c) {
        return this.removeIf(e -> !c.contains(e));
    }

    public void clear() {
        this.cache.clear(this.explicitFlags);
    }

    public CloseableSpliterator<E> spliterator() {
        CacheStream<E> stream = this.getStream(false);
        return Closeables.spliterator(stream);
    }

    @Override
    public CacheStream<E> stream() {
        return this.getStream(false);
    }

    @Override
    public CacheStream<E> parallelStream() {
        return this.getStream(true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.cache) + ")";
    }

    private CacheStream<E> getStream(boolean parallel) {
        ClusterPublisherManager<K, V> publisherManager = EnumUtil.containsAll((long)this.explicitFlags, (long)FlagBitSets.CACHE_MODE_LOCAL) ? this.localPublisherManager : this.clusterPublisherManager;
        InvocationContext ctx = this.cache.invocationContextFactory.createInvocationContext(false, -1);
        if (ctx.isInTxScope()) {
            TxInvocationContext txCtx = (TxInvocationContext)ctx;
            this.cache.txTable.enlist(txCtx.getTransaction(), (LocalTransaction)txCtx.getCacheTransaction());
        }
        if (this.lockOwner != null) {
            ctx.setLockOwner(this.lockOwner);
        }
        DistributedCacheStream cacheStream = new DistributedCacheStream(this.cache.getCacheManager().getAddress(), parallel, ctx, this.explicitFlags, this.batchSize, this.nonBlockingExecutor, this.cache.componentRegistry, this.entryToKeyFunction(), publisherManager);
        return cacheStream.timeout(this.cache.config.clustering().remoteTimeout(), TimeUnit.MILLISECONDS);
    }

    protected ContextBuilder decoratedWriteContextBuilder() {
        return this.lockOwner == null ? this.cache.defaultContextBuilderForWrite() : this::createContextWithLockOwner;
    }

    private InvocationContext createContextWithLockOwner(int numKeys) {
        InvocationContext ctx = this.cache.defaultContextBuilderForWrite().create(numKeys);
        ctx.setLockOwner(this.lockOwner);
        return ctx;
    }

    protected abstract Function<Map.Entry<K, V>, ?> entryToKeyFunction();

    protected abstract Object extractKey(Object var1);

    protected abstract E wrapElement(E var1);
}

