/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.Features;
import org.infinispan.configuration.global.GlobalJmxConfiguration;
import org.infinispan.configuration.global.GlobalMetricsConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.configuration.global.GlobalTracingConfiguration;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.configuration.global.ShutdownConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadsConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;

class CacheContainerConfiguration {
    private static final String ZERO_CAPACITY_NODE_FEATURE = "zero-capacity-node";
    static final AttributeDefinition<String> DEFAULT_CACHE = AttributeDefinition.builder((String)"defaultCache", null, String.class).immutable().validator(value -> {
        if (value != null && !ByteString.isValid(value)) {
            throw Log.CONFIG.invalidNameSize((String)value);
        }
    }).build();
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", (Object)"DefaultCacheManager").immutable().build();
    static final AttributeDefinition<Boolean> STATISTICS = AttributeDefinition.builder((String)"statistics", (Object)false).immutable().build();
    static final AttributeDefinition<Boolean> ZERO_CAPACITY_NODE = AttributeDefinition.builder((String)"zeroCapacityNode", (Object)Boolean.FALSE).immutable().build();
    static final AttributeDefinition<String> ASYNC_EXECUTOR = AttributeDefinition.builder((String)"asyncExecutor", (Object)"async-pool", String.class).immutable().build();
    static final AttributeDefinition<String> LISTENER_EXECUTOR = AttributeDefinition.builder((String)"listenerExecutor", (Object)"listener-pool", String.class).immutable().build();
    static final AttributeDefinition<String> EXPIRATION_EXECUTOR = AttributeDefinition.builder((String)"expirationExecutor", (Object)"expiration-pool", String.class).immutable().build();
    static final AttributeDefinition<String> PERSISTENCE_EXECUTOR = AttributeDefinition.builder((String)"persistenceExecutor", (Object)"persistence-pool", String.class).immutable().build();
    static final AttributeDefinition<String> STATE_TRANSFER_EXECUTOR = AttributeDefinition.builder((String)"stateTransferExecutor", (Object)"state-transfer-pool", String.class).immutable().build();
    static final AttributeDefinition<String> NON_BLOCKING_EXECUTOR = AttributeDefinition.builder((String)"nonBlockingExecutor", (Object)"non-blocking-pool", String.class).immutable().build();
    static final AttributeDefinition<String> BLOCKING_EXECUTOR = AttributeDefinition.builder((String)"blockingExecutor", (Object)"blocking-pool", String.class).immutable().build();
    private final Attribute<String> defaultCache;
    private final Attribute<String> name;
    private final Attribute<Boolean> statistics;
    private final Attribute<Boolean> zeroCapacityNode;
    private final boolean zeroCapacityAvailable;
    private final ThreadsConfiguration threads;
    private final GlobalMetricsConfiguration metrics;
    private final GlobalTracingConfiguration tracing;
    private final GlobalJmxConfiguration jmx;
    private final TransportConfiguration transport;
    private final GlobalSecurityConfiguration security;
    private final SerializationConfiguration serialization;
    private final GlobalStateConfiguration globalState;
    private final ShutdownConfiguration shutdown;
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(CacheContainerConfiguration.class, new AttributeDefinition[]{NAME, STATISTICS, ZERO_CAPACITY_NODE, DEFAULT_CACHE, ASYNC_EXECUTOR, LISTENER_EXECUTOR, EXPIRATION_EXECUTOR, PERSISTENCE_EXECUTOR, STATE_TRANSFER_EXECUTOR, NON_BLOCKING_EXECUTOR, BLOCKING_EXECUTOR});
    }

    CacheContainerConfiguration(AttributeSet attributes, ThreadsConfiguration threadsConfiguration, GlobalMetricsConfiguration metrics, GlobalTracingConfiguration tracing, GlobalJmxConfiguration jmx, TransportConfiguration transport, GlobalSecurityConfiguration security, SerializationConfiguration serialization, GlobalStateConfiguration globalState, ShutdownConfiguration shutdown, Features features) {
        this.attributes = attributes.checkProtection();
        this.defaultCache = attributes.attribute(DEFAULT_CACHE);
        this.name = attributes.attribute(NAME);
        this.statistics = attributes.attribute(STATISTICS);
        this.zeroCapacityNode = attributes.attribute(ZERO_CAPACITY_NODE);
        this.threads = threadsConfiguration;
        this.metrics = metrics;
        this.tracing = tracing;
        this.jmx = jmx;
        this.globalState = globalState;
        this.shutdown = shutdown;
        this.security = security;
        this.serialization = serialization;
        this.transport = transport;
        this.zeroCapacityAvailable = features.isAvailable(ZERO_CAPACITY_NODE_FEATURE);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String defaultCacheName() {
        return (String)this.defaultCache.get();
    }

    public String cacheManagerName() {
        return (String)this.name.get();
    }

    public boolean statistics() {
        return (Boolean)this.statistics.get();
    }

    public boolean getZeroCapacityNode() {
        return this.zeroCapacityAvailable && (Boolean)this.zeroCapacityNode.get() != false;
    }

    public GlobalMetricsConfiguration metrics() {
        return this.metrics;
    }

    public GlobalTracingConfiguration tracing() {
        return this.tracing;
    }

    public GlobalJmxConfiguration jmx() {
        return this.jmx;
    }

    public TransportConfiguration transport() {
        return this.transport;
    }

    public GlobalSecurityConfiguration security() {
        return this.security;
    }

    public SerializationConfiguration serialization() {
        return this.serialization;
    }

    public ShutdownConfiguration shutdown() {
        return this.shutdown;
    }

    @Deprecated(forRemoval=true, since="10.1")
    public String asyncExecutor() {
        return (String)this.attributes.attribute(ASYNC_EXECUTOR).get();
    }

    public String listenerExecutor() {
        return (String)this.attributes.attribute(LISTENER_EXECUTOR).get();
    }

    public String expirationExecutor() {
        return (String)this.attributes.attribute(EXPIRATION_EXECUTOR).get();
    }

    public String persistenceExecutor() {
        return (String)this.attributes.attribute(PERSISTENCE_EXECUTOR).get();
    }

    @Deprecated(forRemoval=true, since="10.1")
    public String stateTransferExecutor() {
        return (String)this.attributes.attribute(STATE_TRANSFER_EXECUTOR).get();
    }

    public String nonBlockingExecutor() {
        return (String)this.attributes.attribute(NON_BLOCKING_EXECUTOR).get();
    }

    public String blockingExecutor() {
        return (String)this.attributes.attribute(BLOCKING_EXECUTOR).get();
    }

    public GlobalStateConfiguration globalState() {
        return this.globalState;
    }

    public boolean isClustered() {
        return this.transport().transport() != null;
    }

    public ThreadsConfiguration threads() {
        return this.threads;
    }

    public ThreadPoolConfiguration expirationThreadPool() {
        return this.threads.expirationThreadPool();
    }

    public ThreadPoolConfiguration listenerThreadPool() {
        return this.threads.listenerThreadPool();
    }

    public ThreadPoolConfiguration persistenceThreadPool() {
        return this.threads.persistenceThreadPool();
    }

    @Deprecated(forRemoval=true, since="10.1")
    public ThreadPoolConfiguration asyncThreadPool() {
        return this.threads.asyncThreadPool();
    }

    public ThreadPoolConfiguration nonBlockingThreadPool() {
        return this.threads.nonBlockingThreadPool();
    }

    public ThreadPoolConfiguration blockingThreadPool() {
        return this.threads.blockingThreadPool();
    }

    public String toString() {
        return "CacheContainerConfiguration{zeroCapacityAvailable=" + this.zeroCapacityAvailable + ", threads=" + String.valueOf(this.threads) + ", metrics=" + String.valueOf(this.metrics) + ", jmx=" + String.valueOf(this.jmx) + ", transport=" + String.valueOf(this.transport) + ", security=" + String.valueOf(this.security) + ", serialization=" + String.valueOf(this.serialization) + ", globalState=" + String.valueOf(this.globalState) + ", shutdown=" + String.valueOf(this.shutdown) + ", attributes=" + String.valueOf(this.attributes) + "}";
    }
}

