/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.util.Features;
import org.infinispan.configuration.global.CacheContainerConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationChildBuilder;
import org.infinispan.configuration.global.GlobalJmxConfigurationBuilder;
import org.infinispan.configuration.global.GlobalMetricsConfigurationBuilder;
import org.infinispan.configuration.global.GlobalSecurityConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStateConfigurationBuilder;
import org.infinispan.configuration.global.GlobalTracingConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownConfigurationBuilder;
import org.infinispan.configuration.global.SiteConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.ThreadsConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;

public class GlobalConfigurationBuilder
implements GlobalConfigurationChildBuilder {
    private ClassLoader cl;
    private final CacheContainerConfigurationBuilder cacheContainerConfiguration;
    private final Map<Class<?>, Builder<?>> modules;
    private final SiteConfigurationBuilder site;
    private Features features;

    public GlobalConfigurationBuilder() {
        ClassLoader defaultCL = Thread.currentThread().getContextClassLoader();
        if (defaultCL == null) {
            defaultCL = GlobalConfigurationBuilder.class.getClassLoader();
        }
        this.cl = defaultCL;
        this.cacheContainerConfiguration = new CacheContainerConfigurationBuilder(this);
        this.site = new SiteConfigurationBuilder(this);
        this.modules = new LinkedHashMap();
    }

    public CacheContainerConfigurationBuilder cacheContainer() {
        return this.cacheContainerConfiguration;
    }

    public GlobalConfigurationBuilder clusteredDefault() {
        this.cacheContainerConfiguration.clusteredDefault();
        return this;
    }

    public GlobalConfigurationBuilder nonClusteredDefault() {
        this.cacheContainerConfiguration.nonClusteredDefault();
        return this;
    }

    protected ClassLoader getClassLoader() {
        return this.cl;
    }

    public GlobalConfigurationBuilder classLoader(ClassLoader cl) {
        this.cl = cl;
        return this;
    }

    @Override
    public TransportConfigurationBuilder transport() {
        return this.cacheContainerConfiguration.transport();
    }

    public GlobalConfigurationBuilder cacheManagerName(String name) {
        this.cacheContainerConfiguration.name(name);
        return this;
    }

    @Override
    public GlobalMetricsConfigurationBuilder metrics() {
        return this.cacheContainerConfiguration.metrics();
    }

    @Override
    public GlobalTracingConfigurationBuilder tracing() {
        return this.cacheContainerConfiguration.tracing();
    }

    @Override
    public GlobalJmxConfigurationBuilder jmx() {
        return this.cacheContainerConfiguration.jmx();
    }

    @Override
    public SerializationConfigurationBuilder serialization() {
        return this.cacheContainerConfiguration.serialization();
    }

    @Override
    public ThreadPoolConfigurationBuilder expirationThreadPool() {
        return this.cacheContainerConfiguration.expirationThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder listenerThreadPool() {
        return this.cacheContainerConfiguration.listenerThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder persistenceThreadPool() {
        return this.cacheContainerConfiguration.persistenceThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder asyncThreadPool() {
        return this.cacheContainerConfiguration.asyncThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder blockingThreadPool() {
        return this.cacheContainerConfiguration.blockingThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder nonBlockingThreadPool() {
        return this.cacheContainerConfiguration.nonBlockingThreadPool();
    }

    public GlobalConfigurationBuilder asyncThreadPoolName(String name) {
        this.cacheContainer().asyncExecutor(name);
        return this;
    }

    public GlobalConfigurationBuilder listenerThreadPoolName(String name) {
        this.cacheContainer().listenerExecutor(name);
        return this;
    }

    public GlobalConfigurationBuilder expirationThreadPoolName(String name) {
        this.cacheContainer().expirationExecutor(name);
        return this;
    }

    public GlobalConfigurationBuilder persistenceThreadPoolName(String name) {
        this.cacheContainer().persistenceExecutor(name);
        return this;
    }

    public GlobalConfigurationBuilder nonBlockingThreadPoolName(String name) {
        this.cacheContainer().nonBlockingExecutor(name);
        return this;
    }

    public GlobalConfigurationBuilder blockingThreadPoolName(String name) {
        this.cacheContainer().blockingExecutor(name);
        return this;
    }

    @Override
    public GlobalSecurityConfigurationBuilder security() {
        return this.cacheContainerConfiguration.security();
    }

    @Override
    public ShutdownConfigurationBuilder shutdown() {
        return this.cacheContainerConfiguration.shutdown();
    }

    @Override
    public List<Builder<?>> modules() {
        return List.copyOf(this.modules.values());
    }

    public <T> T module(Class<T> moduleClass) {
        return (T)this.modules.get(moduleClass);
    }

    public GlobalConfigurationBuilder zeroCapacityNode(boolean zeroCapacityNode) {
        this.cacheContainerConfiguration.zeroCapacityNode(zeroCapacityNode);
        return this;
    }

    public GlobalConfigurationBuilder clearModules() {
        this.modules.clear();
        return this;
    }

    @Override
    public SiteConfigurationBuilder site() {
        return this.site;
    }

    public <T extends Builder<?>> T addModule(Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(GlobalConfigurationBuilder.class);
            Builder builder = (Builder)constructor.newInstance(this);
            Builder existing = this.modules.putIfAbsent(klass, builder);
            return (T)(existing != null ? existing : builder);
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate module configuration builder '" + klass.getName() + "'", (Throwable)e);
        }
    }

    @Override
    public GlobalStateConfigurationBuilder globalState() {
        return this.cacheContainerConfiguration.globalState();
    }

    @Override
    public GlobalConfigurationBuilder defaultCacheName(String defaultCacheName) {
        this.cacheContainerConfiguration.defaultCache(defaultCacheName);
        return this;
    }

    public Optional<String> defaultCacheName() {
        return Optional.ofNullable(this.cacheContainerConfiguration.defaultCacheName());
    }

    public void validate() {
        this.features = new Features(this.cl);
        ArrayList validationExceptions = new ArrayList();
        Arrays.asList(this.cacheContainerConfiguration, this.site).forEach(c -> {
            try {
                ((Builder)c).validate();
            }
            catch (RuntimeException e) {
                validationExceptions.add(e);
            }
        });
        this.modules.values().forEach(c -> {
            try {
                c.validate();
            }
            catch (RuntimeException e) {
                validationExceptions.add(e);
            }
        });
        CacheConfigurationException.fromMultipleRuntimeExceptions(validationExceptions).ifPresent(e -> {
            throw e;
        });
    }

    @Override
    public GlobalConfiguration build() {
        this.validate();
        LinkedList<Object> modulesConfig = new LinkedList<Object>();
        for (Builder<?> module : this.modules.values()) {
            modulesConfig.add(module.create());
        }
        return new GlobalConfiguration(this.cacheContainerConfiguration.create(), modulesConfig, this.site.create(), this.cl, this.features);
    }

    public Features getFeatures() {
        return this.features;
    }

    public GlobalConfigurationBuilder read(GlobalConfiguration template) {
        this.cl = template.classLoader();
        for (Object c : template.modules().values()) {
            BuiltBy builtBy = c.getClass().getAnnotation(BuiltBy.class);
            Object builder = this.addModule(builtBy.value());
            builder.read(c, Combine.DEFAULT);
        }
        this.cacheContainerConfiguration.read(template.cacheContainer(), Combine.DEFAULT);
        this.site.read(template.sites(), Combine.DEFAULT);
        return this;
    }

    public static GlobalConfigurationBuilder defaultClusteredBuilder() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.transport().defaultTransport();
        return builder;
    }

    public String toString() {
        return "GlobalConfigurationBuilder{cl=" + String.valueOf(this.cl) + ", cacheContainerConfiguration=" + String.valueOf(this.cacheContainerConfiguration) + ", modules=" + String.valueOf(this.modules) + ", site=" + String.valueOf(this.site) + ", features=" + String.valueOf(this.features) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalConfigurationBuilder that = (GlobalConfigurationBuilder)o;
        return Objects.equals(this.cl, that.cl) && Objects.equals(this.cacheContainerConfiguration, that.cacheContainerConfiguration) && Objects.equals(this.modules, that.modules) && Objects.equals(this.site, that.site) && Objects.equals(this.features, that.features);
    }

    public int hashCode() {
        return Objects.hash(this.cl, this.cacheContainerConfiguration, this.modules, this.site, this.features);
    }

    public ThreadsConfigurationBuilder threads() {
        return this.cacheContainerConfiguration.threads();
    }
}

