/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.util.Collections;
import java.util.EnumSet;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.util.concurrent.CompletionStages;

public class DefaultCacheManagerAdmin
implements EmbeddedCacheManagerAdmin {
    private final EmbeddedCacheManager cacheManager;
    private final GlobalConfigurationManager clusterConfigurationManager;
    private final Authorizer authorizer;
    private final EnumSet<CacheContainerAdmin.AdminFlag> flags;
    private final Subject subject;

    DefaultCacheManagerAdmin(EmbeddedCacheManager cm, Authorizer authorizer, EnumSet<CacheContainerAdmin.AdminFlag> flags, Subject subject, GlobalConfigurationManager clusterConfigurationManager) {
        this.cacheManager = cm;
        this.authorizer = authorizer;
        this.clusterConfigurationManager = clusterConfigurationManager;
        this.flags = flags;
        this.subject = subject;
    }

    @Override
    public <K, V> Cache<K, V> createCache(String cacheName, Configuration configuration) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.createCache(cacheName, configuration, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> getOrCreateCache(String cacheName, Configuration configuration) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.getOrCreateCache(cacheName, configuration, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> createCache(String cacheName, String template) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.createCache(cacheName, template, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> getOrCreateCache(String cacheName, String template) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.getOrCreateCache(cacheName, template, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    @Override
    public void createTemplate(String name, Configuration configuration) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.createTemplate(name, configuration, this.flags));
    }

    @Override
    public Configuration getOrCreateTemplate(String name, Configuration configuration) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.getOrCreateTemplate(name, configuration, this.flags));
        return this.cacheManager.getCacheConfiguration(name);
    }

    @Override
    public void removeTemplate(String name) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.removeTemplate(name, this.flags));
    }

    public void removeCache(String cacheName) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.removeCache(cacheName, this.flags));
    }

    public EmbeddedCacheManagerAdmin withFlags(CacheContainerAdmin.AdminFlag ... flags) {
        EnumSet<CacheContainerAdmin.AdminFlag> newFlags = EnumSet.copyOf(this.flags);
        Collections.addAll(newFlags, flags);
        return new DefaultCacheManagerAdmin(this.cacheManager, this.authorizer, newFlags, this.subject, this.clusterConfigurationManager);
    }

    public EmbeddedCacheManagerAdmin withFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        EnumSet<CacheContainerAdmin.AdminFlag> newFlags = EnumSet.copyOf(this.flags);
        newFlags.addAll(flags);
        return new DefaultCacheManagerAdmin(this.cacheManager, this.authorizer, newFlags, this.subject, this.clusterConfigurationManager);
    }

    @Override
    public EmbeddedCacheManagerAdmin withSubject(Subject subject) {
        return new DefaultCacheManagerAdmin(this.cacheManager, this.authorizer, this.flags, subject, this.clusterConfigurationManager);
    }
}

