/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.BitSet;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.api.query.EntityEntry;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.core.impl.HybridQuery;
import org.infinispan.query.core.impl.MappingEntryIterator;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;

public class MetadataHybridQuery<T, S>
extends HybridQuery<T, S> {
    private final BitSet scoreProjections = new BitSet();

    public MetadataHybridQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, IckleParsingResult.StatementType statementType, Map<String, Object> namedParameters, ObjectFilter objectFilter, long startOffset, int maxResults, Query<?> baseQuery, LocalQueryStatistics queryStatistics, boolean local) {
        super(queryFactory, cache, queryString, statementType, namedParameters, objectFilter, startOffset, maxResults, baseQuery, queryStatistics, local);
        String[] projection = objectFilter.getProjection();
        if (projection == null) {
            return;
        }
        for (int i = 0; i < projection.length; ++i) {
            if (!"__ISPN_Score".equals(projection[i])) continue;
            this.scoreProjections.set(i);
        }
    }

    @Override
    protected CloseableIterator<ObjectFilter.FilterResult> getInternalIterator() {
        CloseableIterator iterator = this.baseQuery.startOffset(0L).maxResults(Integer.MAX_VALUE).local(this.local).scoreRequired(this.scoreProjections.cardinality() > 0).entryIterator();
        return new MappingEntryIterator(iterator, this::filter);
    }

    private ObjectFilter.FilterResult filter(EntityEntry entry) {
        ObjectFilter.FilterResult filter = this.objectFilter.filter(entry.key(), entry.value());
        String[] projection = this.objectFilter.getProjection();
        if (projection == null) {
            return filter;
        }
        this.scoreProjections.stream().forEach(i -> {
            filter.getProjection()[i] = Float.valueOf(entry.score());
        });
        return filter;
    }
}

