/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metrics.impl.BaseOperatingSystemAdditionalMetrics;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.ServerStateManager;
import org.infinispan.stats.ClusterContainerStats;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;

public abstract class BaseServerManagement
implements ServerManagement {
    private static final String PROTOBUF_METADATA_CACHE_NAME = "___protobuf_metadata";

    @Override
    public Json overviewReport() {
        DefaultCacheManager cacheManager = this.getCacheManager();
        GlobalComponentRegistry registry = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager);
        PersistentUUIDManager uuidManager = (PersistentUUIDManager)registry.getComponent(PersistentUUIDManager.class);
        ClusterContainerStats containerStats = (ClusterContainerStats)registry.getComponent(ClusterContainerStats.class, "LocalContainerStats");
        Address nodeAddress = cacheManager.getAddress();
        Address coordinatorAddress = cacheManager.getCoordinator();
        String clusterName = cacheManager.getClusterName();
        String nodeId = nodeAddress == null ? null : uuidManager.getPersistentUuid(nodeAddress).toString();
        String coordinatorId = coordinatorAddress == null ? null : uuidManager.getPersistentUuid(coordinatorAddress).toString();
        Json clusterMembers = Json.array();
        boolean showClusterMembers = true;
        if (cacheManager.getAddress() != null) {
            for (Address address : cacheManager.getMembers()) {
                PersistentUUID uuid = uuidManager.getPersistentUuid(address);
                if (uuid == null) {
                    showClusterMembers = false;
                    break;
                }
                clusterMembers.add((Object)uuid.toString());
            }
        } else {
            clusterMembers.add((Object)"local");
        }
        HashSet cacheStores = new HashSet();
        HashSet encodings = new HashSet();
        CacheManagerInfo info = cacheManager.getCacheManagerInfo();
        Map cacheFeatures = info.getCacheNames().map(name -> SecurityActions.getCacheConfiguration((EmbeddedCacheManager)cacheManager, (String)name)).map(configuration -> {
            BaseServerManagement.collectCacheStores(cacheStores, configuration);
            BaseServerManagement.collectEncodings(encodings, configuration);
            return BaseServerManagement.cacheFeatures(configuration);
        }).sorted().collect(Collectors.toMap(s -> s, s -> 1, Integer::sum, LinkedHashMap::new));
        Json features = Json.object();
        int numberOfCaches = 0;
        for (Map.Entry feature : cacheFeatures.entrySet()) {
            features.set((String)feature.getKey(), feature.getValue());
            numberOfCaches += ((Integer)feature.getValue()).intValue();
        }
        Json memory = Json.object().set("available", (Object)(containerStats != null ? containerStats.getMemoryAvailable() : -1L)).set("max", (Object)(containerStats != null ? containerStats.getMemoryMax() : -1L)).set("total", (Object)(containerStats != null ? containerStats.getMemoryTotal() : -1L)).set("used", (Object)(containerStats != null ? containerStats.getMemoryUsed() : -1L));
        Json cpu = new BaseOperatingSystemAdditionalMetrics().cpuReport();
        Json thread = null;
        try {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            thread = Json.object((Object[])new Object[]{"count", threadMXBean.getThreadCount()}).set("daemon-count", (Object)threadMXBean.getDaemonThreadCount()).set("max-count", (Object)threadMXBean.getPeakThreadCount()).set("total-started", (Object)threadMXBean.getTotalStartedThreadCount());
        }
        catch (Error threadMXBean) {
            // empty catch block
        }
        Set cacheNames = cacheManager.getCacheNames();
        int protoSchemas = !cacheNames.contains(PROTOBUF_METADATA_CACHE_NAME) ? 0 : SecurityActions.getUnwrappedCache((EmbeddedCacheManager)cacheManager, (String)PROTOBUF_METADATA_CACHE_NAME).size();
        ServerStateManager serverStateManager = this.getServerStateManager();
        Json clients = serverStateManager == null ? Json.nil() : serverStateManager.clientsReport();
        Json report = Json.object((Object[])new Object[]{"version", "1.0.0"}).set("node-id", (Object)nodeId).set("coordinator-id", (Object)coordinatorId).set("cluster-name", (Object)clusterName).set("cluster-size", (Object)info.getClusterSize());
        if (showClusterMembers) {
            report.set("cluster-members", clusterMembers);
        }
        report = report.set("number-of-caches", (Object)numberOfCaches).set("cache-features", features).set("cache-configurations", Json.make((Object)info.externalCacheConfigurations())).set("local-site", (Object)info.getLocalSite()).set("relay-node", (Object)info.isRelayNode()).set("sites-view", Json.make((Object)info.getSites())).set("memory", memory).set("cpu", cpu);
        if (thread != null) {
            report.set("thread", thread);
        }
        return report.set("proto-schemas", (Object)protoSchemas).set("cache-stores", cacheStores).set("used-encodings", encodings).set("clients", clients).set("security", this.securityOverviewReport());
    }

    private static void collectCacheStores(HashSet<String> cacheStores, Configuration configuration) {
        for (StoreConfiguration store : configuration.persistence().stores()) {
            if (!(store instanceof ConfigurationElement)) continue;
            String elementName = ((ConfigurationElement)store).elementName();
            cacheStores.add(elementName);
        }
    }

    private static void collectEncodings(HashSet<String> encodings, Configuration configuration) {
        MediaType valueDataType;
        MediaType keyMediaType;
        MediaType mediaType;
        EncodingConfiguration encoding = configuration.encoding();
        Attribute mediaTypeAttribute = encoding.attributes().attribute("media-type");
        if (mediaTypeAttribute != null && (mediaType = (MediaType)mediaTypeAttribute.get()) != null) {
            encodings.add(mediaType.toString());
        }
        if ((keyMediaType = encoding.keyDataType().mediaType()) != null) {
            encodings.add(keyMediaType.toString());
        }
        if ((valueDataType = encoding.valueDataType().mediaType()) != null) {
            encodings.add(valueDataType.toString());
        }
    }

    private static String cacheFeatures(Configuration configuration) {
        ArrayList<String> features = new ArrayList<String>(7);
        if (configuration.simpleCache()) {
            features.add("simpleCache");
        }
        if (configuration.transaction().transactionMode().isTransactional()) {
            features.add("transactional");
        }
        if (configuration.persistence().usingStores()) {
            features.add("persistence");
        }
        if (configuration.memory().whenFull().isEnabled()) {
            features.add("bounded");
        }
        if (configuration.security().authorization().enabled()) {
            features.add("secured");
        }
        if (configuration.indexing().enabled()) {
            features.add("indexed");
        }
        if (configuration.sites().hasBackups()) {
            features.add("hasRemoteBackup");
        }
        return features.isEmpty() ? "no-features" : String.join((CharSequence)"+", features);
    }
}

