/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.telemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import org.infinispan.server.core.telemetry.OpenTelemetrySpan;
import org.infinispan.telemetry.InfinispanSpan;
import org.infinispan.telemetry.InfinispanSpanAttributes;
import org.infinispan.telemetry.InfinispanSpanContext;
import org.infinispan.telemetry.InfinispanTelemetry;
import org.infinispan.telemetry.impl.DisabledInfinispanSpan;

public class OpenTelemetryService
implements InfinispanTelemetry,
TextMapGetter<InfinispanSpanContext> {
    private static final String INFINISPAN_SERVER_TRACING_NAME = "org.infinispan.server.tracing";
    private static final String INFINISPAN_SERVER_TRACING_VERSION = "1.0.0";
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;

    public OpenTelemetryService(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        this.tracer = openTelemetry.getTracer(INFINISPAN_SERVER_TRACING_NAME, INFINISPAN_SERVER_TRACING_VERSION);
    }

    public InfinispanSpan startTraceRequest(String operationName, InfinispanSpanAttributes attributes) {
        if (attributes.isCategoryDisabled()) {
            return DisabledInfinispanSpan.instance();
        }
        SpanBuilder builder = this.tracer.spanBuilder(operationName).setSpanKind(SpanKind.SERVER);
        return this.createOpenTelemetrySpan(builder, attributes);
    }

    public InfinispanSpan startTraceRequest(String operationName, InfinispanSpanAttributes attributes, InfinispanSpanContext context) {
        if (attributes.isCategoryDisabled()) {
            return DisabledInfinispanSpan.instance();
        }
        Context extractedContext = this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)context, (TextMapGetter)this);
        SpanBuilder builder = this.tracer.spanBuilder(operationName).setSpanKind(SpanKind.SERVER).setParent(extractedContext);
        return this.createOpenTelemetrySpan(builder, attributes);
    }

    private InfinispanSpan createOpenTelemetrySpan(SpanBuilder builder, InfinispanSpanAttributes attributes) {
        attributes.cacheName().ifPresent(cacheName -> builder.setAttribute("cache", cacheName));
        builder.setAttribute("category", attributes.category().toString());
        return new OpenTelemetrySpan(builder.startSpan());
    }

    public Iterable<String> keys(InfinispanSpanContext ctx) {
        return ctx.keys();
    }

    public String get(InfinispanSpanContext ctx, String key) {
        assert (ctx != null);
        return ctx.getKey(key);
    }
}

