/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SniHandler;
import io.netty.util.DomainWildcardMappingBuilder;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.transport.AccessControlFilter;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.StatsChannelHandler;
import org.infinispan.server.core.utils.SslUtils;

public class NettyChannelInitializer<A extends ProtocolServerConfiguration>
implements NettyInitializer {
    static final AtomicLong CHANNEL_ID = new AtomicLong();
    protected final ProtocolServer<A> server;
    protected final NettyTransport transport;
    protected final ChannelOutboundHandler encoder;
    protected final Supplier<ChannelInboundHandler> decoderSupplier;

    public NettyChannelInitializer(ProtocolServer<A> server, NettyTransport transport, ChannelOutboundHandler encoder, Supplier<ChannelInboundHandler> decoderSupplier) {
        this.server = server;
        this.transport = transport;
        this.encoder = encoder;
        this.decoderSupplier = decoderSupplier;
    }

    @Override
    public void initializeChannel(Channel ch) throws Exception {
        ChannelInboundHandler decoder;
        ConnectionMetadata info = ConnectionMetadata.getInstance(ch);
        info.id(CHANNEL_ID.getAndIncrement());
        info.created(Instant.now());
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("iprules", new AccessControlFilter<A>(this.server.getConfiguration()));
        if (this.transport != null) {
            pipeline.addLast("stats", (ChannelHandler)new StatsChannelHandler(this.transport));
            SslConfiguration ssl = ((ProtocolServerConfiguration)((Object)this.server.getConfiguration())).ssl();
            if (ssl.enabled()) {
                ApplicationProtocolConfig alpnConfig = this.getAlpnConfiguration();
                JdkSslContext defaultNettySslContext = SslUtils.createNettySslContext(ssl, ssl.sniDomainsConfiguration().get("*"), alpnConfig);
                DomainWildcardMappingBuilder domainMappingBuilder = new DomainWildcardMappingBuilder((Object)defaultNettySslContext);
                ssl.sniDomainsConfiguration().forEach((k, v) -> {
                    if (!"*".equals(k)) {
                        domainMappingBuilder.add(k, (Object)SslUtils.createNettySslContext(ssl, v, alpnConfig));
                    }
                });
                pipeline.addLast("sni", (ChannelHandler)new SniHandler(domainMappingBuilder.build()));
            }
        }
        ChannelInboundHandler channelInboundHandler = decoder = this.decoderSupplier != null ? this.decoderSupplier.get() : null;
        if (decoder != null) {
            pipeline.addLast("decoder", (ChannelHandler)decoder);
        }
        if (this.encoder != null) {
            pipeline.addLast("encoder", (ChannelHandler)this.encoder);
        }
    }

    protected ApplicationProtocolConfig getAlpnConfiguration() {
        return null;
    }
}

