/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.time.temporal.Temporal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.security.Security;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.memcached.MemcachedMetadata;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.MemcachedStats;
import org.infinispan.server.memcached.ParseUtil;
import org.infinispan.server.memcached.logging.Header;
import org.infinispan.server.memcached.logging.Log;
import org.infinispan.server.memcached.logging.MemcachedAccessLogging;
import org.infinispan.stats.Stats;
import org.infinispan.util.logging.LogFactory;

public abstract class MemcachedBaseDecoder
extends ByteToMessageDecoder {
    protected static final Subject ANONYMOUS = new Subject();
    protected static final Log log = (Log)LogFactory.getLog(MemcachedBaseDecoder.class, Log.class);
    protected final MemcachedServer server;
    protected final MemcachedStats statistics;
    protected final boolean statsEnabled;
    protected final boolean accessLogging;
    protected Temporal requestStart;
    protected ChannelHandlerContext ctx;
    protected final TimeService timeService;
    protected final VersionGenerator versionGenerator;
    protected final AdvancedCache<byte[], byte[]> cache;
    protected final Subject subject;
    protected final String principalName;
    protected final ByRef<MemcachedResponse> current = ByRef.create(null);
    private BiConsumer<ChannelHandlerContext, MemcachedResponse> errorHandler;

    protected MemcachedBaseDecoder(MemcachedServer server, Subject subject, AdvancedCache<byte[], byte[]> cache) {
        this.server = server;
        this.subject = subject;
        this.principalName = Security.getSubjectUserPrincipalName((Subject)subject);
        this.cache = cache.withSubject(subject);
        ComponentRegistry registry = ComponentRegistry.of(cache);
        VersionGenerator versionGenerator = (VersionGenerator)registry.getComponent(VersionGenerator.class);
        if (versionGenerator == null) {
            versionGenerator = new NumericVersionGenerator();
            registry.registerComponent((Object)versionGenerator, VersionGenerator.class);
        }
        this.versionGenerator = versionGenerator;
        this.timeService = registry.getTimeService();
        this.statistics = server.getStatistics();
        this.statsEnabled = this.statistics != null;
        this.accessLogging = MemcachedAccessLogging.isEnabled();
    }

    public void registerExceptionHandler(BiConsumer<ChannelHandlerContext, MemcachedResponse> handler) {
        this.errorHandler = handler;
    }

    protected final void exceptionCaught(Header header, Throwable t) {
        if (this.errorHandler != null) {
            this.errorHandler.accept(this.ctx, this.failedResponse(header, t));
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        super.handlerAdded(ctx);
    }

    public void resumeRead() {
        if (this.internalBuffer().isReadable() && this.ctx.channel().config().isAutoRead()) {
            this.ctx.channel().eventLoop().submit(() -> {
                try {
                    this.channelRead(this.ctx, Unpooled.EMPTY_BUFFER);
                    this.channelReadComplete(this.ctx);
                }
                catch (Throwable t) {
                    this.ctx.fireExceptionCaught(t);
                }
            });
        }
    }

    protected abstract MemcachedResponse failedResponse(Header var1, Throwable var2);

    protected abstract MemcachedResponse send(Header var1, CompletionStage<?> var2);

    protected abstract MemcachedResponse send(Header var1, CompletionStage<?> var2, GenericFutureListener<? extends Future<? super Void>> var3);

    protected Map<byte[], byte[]> statsMap() {
        Stats stats = this.cache.getAdvancedCache().getStats();
        LinkedHashMap<byte[], byte[]> map = new LinkedHashMap<byte[], byte[]>(35);
        map.put(MemcachedStats.MemcachedStatsKeys.PID, ParseUtil.writeAsciiLong(ProcessHandle.current().pid()));
        map.put(MemcachedStats.MemcachedStatsKeys.UPTIME, ParseUtil.writeAsciiLong(stats.getTimeSinceStart()));
        map.put(MemcachedStats.MemcachedStatsKeys.TIME, ParseUtil.writeAsciiLong(TimeUnit.MILLISECONDS.toSeconds(this.timeService.wallClockTime())));
        map.put(MemcachedStats.MemcachedStatsKeys.VERSION, this.cache.getVersion().getBytes(StandardCharsets.US_ASCII));
        map.put(MemcachedStats.MemcachedStatsKeys.POINTER_SIZE, ParseUtil.ZERO);
        map.put(MemcachedStats.MemcachedStatsKeys.RUSAGE_USER, ParseUtil.ZERO);
        map.put(MemcachedStats.MemcachedStatsKeys.RUSAGE_SYSTEM, ParseUtil.ZERO);
        map.put(MemcachedStats.MemcachedStatsKeys.CURR_ITEMS, ParseUtil.writeAsciiLong(stats.getApproximateEntries()));
        map.put(MemcachedStats.MemcachedStatsKeys.TOTAL_ITEMS, ParseUtil.writeAsciiLong(stats.getStores()));
        map.put(MemcachedStats.MemcachedStatsKeys.BYTES, ParseUtil.ZERO);
        map.put(MemcachedStats.MemcachedStatsKeys.CMD_GET, ParseUtil.writeAsciiLong(stats.getRetrievals()));
        map.put(MemcachedStats.MemcachedStatsKeys.CMD_SET, ParseUtil.writeAsciiLong(stats.getStores()));
        map.put(MemcachedStats.MemcachedStatsKeys.GET_HITS, ParseUtil.writeAsciiLong(stats.getHits()));
        map.put(MemcachedStats.MemcachedStatsKeys.GET_MISSES, ParseUtil.writeAsciiLong(stats.getMisses()));
        map.put(MemcachedStats.MemcachedStatsKeys.DELETE_MISSES, ParseUtil.writeAsciiLong(stats.getRemoveMisses()));
        map.put(MemcachedStats.MemcachedStatsKeys.DELETE_HITS, ParseUtil.writeAsciiLong(stats.getRemoveHits()));
        if (this.statsEnabled) {
            map.put(MemcachedStats.MemcachedStatsKeys.INCR_MISSES, ParseUtil.writeAsciiLong(MemcachedStats.INCR_MISSES.get(this.statistics)));
            map.put(MemcachedStats.MemcachedStatsKeys.INCR_HITS, ParseUtil.writeAsciiLong(MemcachedStats.INCR_HITS.get(this.statistics)));
            map.put(MemcachedStats.MemcachedStatsKeys.DECR_MISSES, ParseUtil.writeAsciiLong(MemcachedStats.DECR_MISSES.get(this.statistics)));
            map.put(MemcachedStats.MemcachedStatsKeys.DECR_HITS, ParseUtil.writeAsciiLong(MemcachedStats.DECR_HITS.get(this.statistics)));
            map.put(MemcachedStats.MemcachedStatsKeys.CAS_MISSES, ParseUtil.writeAsciiLong(MemcachedStats.CAS_MISSES.get(this.statistics)));
            map.put(MemcachedStats.MemcachedStatsKeys.CAS_HITS, ParseUtil.writeAsciiLong(MemcachedStats.CAS_HITS.get(this.statistics)));
            map.put(MemcachedStats.MemcachedStatsKeys.CAS_BADVAL, ParseUtil.writeAsciiLong(MemcachedStats.CAS_BADVAL.get(this.statistics)));
        }
        map.put(MemcachedStats.MemcachedStatsKeys.AUTH_CMDS, ParseUtil.ZERO);
        map.put(MemcachedStats.MemcachedStatsKeys.AUTH_ERRORS, ParseUtil.ZERO);
        map.put(MemcachedStats.MemcachedStatsKeys.EVICTIONS, ParseUtil.writeAsciiLong(stats.getEvictions()));
        NettyTransport transport = this.server.getTransport();
        if (transport == null) {
            transport = (NettyTransport)this.server.getEnclosingProtocolServer().getTransport();
        }
        map.put(MemcachedStats.MemcachedStatsKeys.BYTES_READ, ParseUtil.writeAsciiLong(transport.getTotalBytesRead()));
        map.put(MemcachedStats.MemcachedStatsKeys.BYTES_WRITTEN, ParseUtil.writeAsciiLong(transport.getTotalBytesWritten()));
        map.put(MemcachedStats.MemcachedStatsKeys.CURR_CONNECTIONS, ParseUtil.writeAsciiLong(transport.getNumberOfLocalConnections()));
        map.put(MemcachedStats.MemcachedStatsKeys.TOTAL_CONNECTIONS, ParseUtil.writeAsciiLong(transport.getNumberOfGlobalConnections()));
        map.put(MemcachedStats.MemcachedStatsKeys.THREADS, ParseUtil.ZERO);
        map.put(MemcachedStats.MemcachedStatsKeys.CONNECTION_STRUCTURES, ParseUtil.ZERO);
        map.put(MemcachedStats.MemcachedStatsKeys.LIMIT_MAXBYTES, ParseUtil.ZERO);
        map.put(MemcachedStats.MemcachedStatsKeys.CONN_YIELDS, ParseUtil.ZERO);
        map.put(MemcachedStats.MemcachedStatsKeys.RECLAIMED, ParseUtil.ZERO);
        return map;
    }

    protected Metadata touchMetadata(CacheEntry<?, ?> entry, int expiration) {
        return new MemcachedMetadata.Builder().merge(entry.getMetadata()).lifespan(this.toMillis(expiration)).build();
    }

    protected long toMillis(int lifespan) {
        if (lifespan > 2592000) {
            long unixTimeExpiry = TimeUnit.SECONDS.toMillis(lifespan) - this.timeService.wallClockTime();
            return unixTimeExpiry < 0L ? 0L : unixTimeExpiry;
        }
        return TimeUnit.SECONDS.toMillis(lifespan);
    }

    protected Metadata metadata(int flags, int expiration) {
        return new MemcachedMetadata.Builder().flags(flags).version((EntryVersion)this.versionGenerator.generateNew()).lifespan(expiration > 0 ? this.toMillis(expiration) : -1L).build();
    }
}

