/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.zonalstats;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.NullOpImage;
import javax.media.jai.ROI;
import org.jaitools.CollectionFactory;
import org.jaitools.imageutils.iterator.SimpleIterator;
import org.jaitools.media.jai.zonalstats.ZonalStats;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.RangeUtils;
import org.jaitools.numeric.Statistic;
import org.jaitools.numeric.StreamingSampleStats;

public class ZonalStatsOpImage
extends NullOpImage {
    private static final Logger LOGGER = Logger.getLogger("org.jaitools.zonalstats");
    private final Integer[] srcBands;
    private final ROI roi;
    private final Statistic[] stats;
    private final RenderedImage dataImage;
    private final Rectangle dataImageBounds;
    private final Rectangle zoneImageBounds;
    private final RenderedImage zoneImage;
    private final AffineTransform dataToZoneTransform;
    private final List<Range<Double>> ranges;
    private final List<Range<Double>> noDataRanges;
    private final boolean rangeLocalStats;
    private Range.Type rangesType;
    private SortedSet<Integer> zones;

    public ZonalStatsOpImage(RenderedImage dataImage, RenderedImage zoneImage, Map<?, ?> config, ImageLayout layout, Statistic[] stats, Integer[] bands, ROI roi, AffineTransform dataToZoneTransform, Collection<Range<Double>> ranges, Range.Type rangesType, boolean rangeLocalStats, Collection<Range<Double>> noDataRanges) {
        super(dataImage, layout, config, 1);
        this.dataImage = dataImage;
        this.zoneImage = zoneImage;
        this.dataImageBounds = new Rectangle(dataImage.getMinX(), dataImage.getMinY(), dataImage.getWidth(), dataImage.getHeight());
        this.dataToZoneTransform = dataToZoneTransform;
        if (zoneImage == null) {
            this.zoneImageBounds = null;
        } else if (dataToZoneTransform == null) {
            this.zoneImageBounds = this.dataImageBounds;
        } else {
            Rectangle r = null;
            try {
                AffineTransform inverse = dataToZoneTransform.createInverse();
                r = inverse.createTransformedShape(this.dataImageBounds).getBounds();
            }
            catch (NoninvertibleTransformException ex) {
                LOGGER.warning("The data to zone transform is non-invertible. The whole zone image will be scanned.");
                r = this.dataImageBounds;
            }
            this.zoneImageBounds = r;
        }
        this.stats = new Statistic[stats.length];
        System.arraycopy(stats, 0, this.stats, 0, stats.length);
        this.srcBands = new Integer[bands.length];
        System.arraycopy(bands, 0, this.srcBands, 0, bands.length);
        this.roi = roi;
        this.rangeLocalStats = rangeLocalStats;
        this.ranges = CollectionFactory.list();
        this.rangesType = rangesType;
        if (ranges != null && !ranges.isEmpty()) {
            for (Range<Double> r : ranges) {
                this.ranges.add((Range<Double>)new Range(r));
            }
        }
        this.noDataRanges = CollectionFactory.list();
        if (noDataRanges != null && !noDataRanges.isEmpty()) {
            for (Range<Double> r : noDataRanges) {
                this.noDataRanges.add((Range<Double>)new Range(r));
            }
        }
    }

    private void buildZoneList() {
        this.zones = CollectionFactory.sortedSet();
        if (this.zoneImage != null) {
            SimpleIterator iter = new SimpleIterator(this.dataImage, this.zoneImageBounds, null);
            do {
                Number zoneVal;
                if ((zoneVal = iter.getSample()) == null) continue;
                this.zones.add(zoneVal.intValue());
            } while (iter.next());
            iter.done();
        } else {
            this.zones.add(0);
        }
    }

    private synchronized ZonalStats compileStatistics() {
        if (this.zoneImage != null) {
            return this.compileZonalStatistics();
        }
        if (!this.rangeLocalStats) {
            return this.compileUnzonedStatistics();
        }
        return this.compileRangeStatistics();
    }

    protected StreamingSampleStats setupZoneStats(Map<Integer, StreamingSampleStats> resultsPerBand, Integer zone) {
        StreamingSampleStats sampleStats = new StreamingSampleStats(Range.Type.EXCLUDE);
        for (Range<Double> r : this.ranges) {
            sampleStats.addRange(r);
        }
        for (Range<Double> r : this.noDataRanges) {
            sampleStats.addNoDataRange(r);
        }
        sampleStats.setStatistics(this.stats);
        resultsPerBand.put(zone, sampleStats);
        return sampleStats;
    }

    private ZonalStats compileZonalStatistics() {
        SortedMap results = CollectionFactory.sortedMap();
        for (Integer n : this.srcBands) {
            SortedMap resultsPerBand = CollectionFactory.sortedMap();
            results.put(n, resultsPerBand);
        }
        SimpleIterator dataIter = new SimpleIterator(this.dataImage, this.dataImageBounds, null);
        SimpleIterator zoneIter = new SimpleIterator(this.zoneImage, this.zoneImageBounds, null);
        if (this.dataToZoneTransform == null) {
            do {
                if (this.roi == null || this.roi.contains(dataIter.getPos())) {
                    for (Integer band : this.srcBands) {
                        int zone;
                        Map resultPerBand = (Map)results.get(band);
                        StreamingSampleStats sss = (StreamingSampleStats)resultPerBand.get(zone = zoneIter.getSample().intValue());
                        if (sss == null) {
                            sss = this.setupZoneStats(resultPerBand, zone);
                        }
                        sss.offer(Double.valueOf(dataIter.getSample(band.intValue()).doubleValue()));
                    }
                }
                zoneIter.next();
            } while (dataIter.next());
        } else {
            Point zonePos = new Point();
            do {
                if (this.roi != null && !this.roi.contains(dataIter.getPos())) continue;
                this.dataToZoneTransform.transform(dataIter.getPos(), zonePos);
                for (Integer band : this.srcBands) {
                    int zone;
                    Map resultPerBand = (Map)results.get(band);
                    StreamingSampleStats sss = (StreamingSampleStats)resultPerBand.get(zone = zoneIter.getSample(zonePos.x, zonePos.y, 0).intValue());
                    if (sss == null) {
                        sss = this.setupZoneStats(resultPerBand, zone);
                    }
                    sss.offer(Double.valueOf(dataIter.getSample(band.intValue()).doubleValue()));
                }
            } while (!dataIter.next());
        }
        dataIter.done();
        zoneIter.done();
        TreeSet zonesFound = new TreeSet();
        for (Integer band : this.srcBands) {
            Set zoneSetForBand = ((Map)results.get(band)).keySet();
            zonesFound.addAll(zoneSetForBand);
        }
        ZonalStats zonalStats = new ZonalStats();
        for (Integer band : this.srcBands) {
            for (Integer zone : zonesFound) {
                zonalStats.setResults(band, zone, (StreamingSampleStats)((Map)results.get(band)).get(zone));
            }
        }
        return zonalStats;
    }

    private ZonalStats compileUnzonedStatistics() {
        this.buildZoneList();
        Integer zoneID = this.zones.first();
        StreamingSampleStats[] sampleStatsPerBand = new StreamingSampleStats[this.srcBands.length];
        for (int index = 0; index < this.srcBands.length; ++index) {
            StreamingSampleStats sampleStats = new StreamingSampleStats(this.rangesType);
            for (Range<Double> r : this.ranges) {
                sampleStats.addRange(r);
            }
            for (Range<Double> r : this.noDataRanges) {
                sampleStats.addNoDataRange(r);
            }
            sampleStats.setStatistics(this.stats);
            sampleStatsPerBand[index] = sampleStats;
        }
        SimpleIterator dataIter = new SimpleIterator(this.dataImage, this.dataImageBounds, null);
        do {
            if (this.roi != null && !this.roi.contains(dataIter.getPos())) continue;
            for (int k = 0; k < this.srcBands.length; ++k) {
                double value = dataIter.getSample(this.srcBands[k].intValue()).doubleValue();
                sampleStatsPerBand[k].offer(Double.valueOf(value));
            }
        } while (dataIter.next());
        dataIter.done();
        ZonalStats zs = new ZonalStats();
        for (int index = 0; index < this.srcBands.length; ++index) {
            StreamingSampleStats sampleStats = sampleStatsPerBand[index];
            List inclRanges = null;
            if (this.ranges != null && !this.ranges.isEmpty()) {
                switch (this.rangesType) {
                    case INCLUDE: {
                        inclRanges = CollectionFactory.list();
                        inclRanges.addAll(this.ranges);
                        break;
                    }
                    case EXCLUDE: {
                        inclRanges = CollectionFactory.list();
                        List incRanges = RangeUtils.createComplement((Collection)RangeUtils.sort(this.ranges));
                        inclRanges.addAll(incRanges);
                    }
                }
            }
            zs.setResults(this.srcBands[index], zoneID, sampleStats, inclRanges);
        }
        return zs;
    }

    private ZonalStats compileRangeStatistics() {
        this.buildZoneList();
        Integer zoneID = this.zones.first();
        ZonalStats zs = new ZonalStats();
        List localRanges = null;
        switch (this.rangesType) {
            case EXCLUDE: {
                List inRanges = RangeUtils.createComplement((Collection)RangeUtils.sort(this.ranges));
                localRanges = CollectionFactory.list();
                localRanges.addAll(inRanges);
                break;
            }
            case INCLUDE: {
                localRanges = CollectionFactory.list();
                localRanges.addAll(this.ranges);
                break;
            }
            case UNDEFINED: {
                throw new UnsupportedOperationException("Unable to compute range local statistics on UNDEFINED ranges type");
            }
        }
        for (Range range : localRanges) {
            StreamingSampleStats[] sampleStatsPerBand = new StreamingSampleStats[this.srcBands.length];
            for (int index = 0; index < this.srcBands.length; ++index) {
                StreamingSampleStats sampleStats = new StreamingSampleStats(this.rangesType);
                sampleStats.addRange(range);
                for (Range<Double> noDataRange : this.noDataRanges) {
                    sampleStats.addNoDataRange(noDataRange);
                }
                sampleStats.setStatistics(this.stats);
                sampleStatsPerBand[index] = sampleStats;
            }
            SimpleIterator dataIter = new SimpleIterator(this.dataImage, this.dataImageBounds, null);
            do {
                if (this.roi != null && !this.roi.contains(dataIter.getPos())) continue;
                for (int k = 0; k < this.srcBands.length; ++k) {
                    double value = dataIter.getSample(this.srcBands[k].intValue()).doubleValue();
                    sampleStatsPerBand[k].offer(Double.valueOf(value));
                }
            } while (dataIter.next());
            dataIter.done();
            for (int index = 0; index < this.srcBands.length; ++index) {
                StreamingSampleStats sampleStats = sampleStatsPerBand[index];
                List resultRanges = CollectionFactory.list();
                resultRanges.add(range);
                zs.setResults(this.srcBands[index], zoneID, sampleStats, resultRanges);
            }
        }
        return zs;
    }

    public Object getProperty(String name) {
        if ("ZonalStatsProperty".equalsIgnoreCase(name)) {
            return this.compileStatistics();
        }
        return super.getProperty(name);
    }

    public Class<?> getPropertyClass(String name) {
        if ("ZonalStatsProperty".equalsIgnoreCase(name)) {
            return Map.class;
        }
        return super.getPropertyClass(name);
    }

    public String[] getPropertyNames() {
        String[] names;
        int k = 0;
        String[] superNames = super.getPropertyNames();
        if (superNames != null) {
            names = new String[superNames.length + 1];
            for (String name : super.getPropertyNames()) {
                names[k++] = name;
            }
        } else {
            names = new String[1];
        }
        names[k] = "ZonalStatsProperty";
        return names;
    }
}

