/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import org.javasimon.console.ActionContext;
import org.javasimon.console.ActionException;
import org.javasimon.console.SimonConsolePlugin;
import org.javasimon.console.action.AbstractJsonAction;
import org.javasimon.console.json.ArrayJS;

public class PluginsJsonAction
extends AbstractJsonAction {
    public static final String PATH = "/data/plugins.json";
    private Class<? extends SimonConsolePlugin> type;
    private boolean invalidType = false;

    public PluginsJsonAction(ActionContext context) {
        super(context);
    }

    @Override
    public void readParameters() {
        super.readParameters();
        String sType = this.getContext().getParameterAsString("type", null);
        if (sType != null) {
            try {
                Class<?> oType = Class.forName(sType);
                if (SimonConsolePlugin.class.isAssignableFrom(oType)) {
                    this.type = oType;
                } else {
                    this.invalidType = true;
                }
            }
            catch (Exception e) {
                this.invalidType = true;
            }
        }
    }

    @Override
    public void execute() throws ServletException, IOException, ActionException {
        super.execute();
        List<Object> plugins = this.invalidType ? Collections.emptyList() : (this.type == null ? this.getContext().getPluginManager().getPlugins() : this.getContext().getPluginManager().getPluginsByType(this.type));
        ArrayJS pluginsJS = new ArrayJS();
        for (SimonConsolePlugin plugin : plugins) {
            pluginsJS.addElement(plugin.toJson(this.jsonStringifierFactory));
        }
        pluginsJS.write(this.getContext().getWriter());
    }
}

