/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.ref.Cleaner;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClientEngine;
import org.jboss.resteasy.client.jaxrs.engines.ClientEntityOutputStream;
import org.jboss.resteasy.client.jaxrs.engines.HttpContextProvider;
import org.jboss.resteasy.client.jaxrs.engines.SelfExpandingBufferredInputStream;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.FinalizedClientResponse;
import org.jboss.resteasy.spi.ResourceCleaner;
import org.jboss.resteasy.spi.config.ConfigurationFactory;
import org.jboss.resteasy.spi.config.SizeUnit;
import org.jboss.resteasy.spi.config.Threshold;
import org.jboss.resteasy.util.CaseInsensitiveMap;

@Deprecated(forRemoval=true, since="6.2")
public class ManualClosingApacheHttpClient43Engine
implements ApacheHttpClientEngine {
    static final String FILE_UPLOAD_IN_MEMORY_THRESHOLD_PROPERTY = "org.jboss.resteasy.client.jaxrs.engines.fileUploadInMemoryThreshold";
    private static final String processId;
    protected final HttpClient httpClient;
    protected final AtomicBoolean closed;
    private final AtomicBoolean autoClosed;
    private final Cleaner.Cleanable cleanable;
    protected final boolean allowClosingHttpClient;
    protected HttpContextProvider httpContextProvider;
    protected SSLContext sslContext;
    protected HostnameVerifier hostnameVerifier;
    protected int responseBufferSize = 8192;
    protected HttpHost defaultProxy = null;
    protected boolean chunked = false;
    protected boolean followRedirects = false;
    @Deprecated
    protected int fileUploadInMemoryThresholdLimit = 1;
    @Deprecated
    protected ApacheHttpClientEngine.MemoryUnit fileUploadMemoryUnit = ApacheHttpClientEngine.MemoryUnit.MB;
    protected Path fileUploadTempFileDir = ManualClosingApacheHttpClient43Engine.getTempDir();

    public ManualClosingApacheHttpClient43Engine() {
        this(null, null, true, null);
    }

    public ManualClosingApacheHttpClient43Engine(HttpHost defaultProxy) {
        this(null, null, true, defaultProxy);
    }

    public ManualClosingApacheHttpClient43Engine(HttpClient httpClient) {
        this(httpClient, null, true, null);
    }

    public ManualClosingApacheHttpClient43Engine(HttpClient httpClient, boolean closeHttpClient) {
        this(httpClient, null, closeHttpClient, null);
    }

    public ManualClosingApacheHttpClient43Engine(HttpClient httpClient, HttpContextProvider httpContextProvider) {
        this(httpClient, httpContextProvider, true, null);
    }

    private ManualClosingApacheHttpClient43Engine(HttpClient httpClient, HttpContextProvider httpContextProvider, boolean closeHttpClient, HttpHost defaultProxy) {
        HttpClient httpClient2 = this.httpClient = httpClient != null ? httpClient : this.createDefaultHttpClient();
        if (closeHttpClient && !(this.httpClient instanceof CloseableHttpClient)) {
            throw new IllegalArgumentException("httpClient must be a CloseableHttpClient instance in order for allowing engine to close it!");
        }
        this.httpContextProvider = httpContextProvider;
        this.allowClosingHttpClient = closeHttpClient;
        this.closed = new AtomicBoolean(false);
        this.autoClosed = new AtomicBoolean(true);
        this.cleanable = ManualClosingApacheHttpClient43Engine.createCleanable(this, closeHttpClient, this.closed, this.autoClosed, this.httpClient);
        this.defaultProxy = defaultProxy;
        try {
            int threshold = ManualClosingApacheHttpClient43Engine.getProperty(FILE_UPLOAD_IN_MEMORY_THRESHOLD_PROPERTY, Integer.class, () -> 1);
            if (threshold > -1) {
                this.fileUploadInMemoryThresholdLimit = threshold;
            }
            LogMessages.LOGGER.debugf("Negative threshold, %s, specified. Using default value", threshold);
        }
        catch (Exception e) {
            LogMessages.LOGGER.debug((Object)"Exception caught parsing memory threshold. Using default value.", (Throwable)e);
        }
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    @Deprecated
    public int getFileUploadInMemoryThresholdLimit() {
        return this.fileUploadInMemoryThresholdLimit;
    }

    @Deprecated
    public void setFileUploadInMemoryThresholdLimit(int fileUploadInMemoryThresholdLimit) {
        this.fileUploadInMemoryThresholdLimit = fileUploadInMemoryThresholdLimit;
    }

    public Threshold getFileUploadMemoryThreshold() {
        return Threshold.of((long)this.fileUploadInMemoryThresholdLimit, (SizeUnit)this.fileUploadMemoryUnit.toSizeUnit());
    }

    public void setFileUploadMemoryThreshold(Threshold threshold) {
        this.fileUploadInMemoryThresholdLimit = (int)threshold.toBytes();
        this.fileUploadMemoryUnit = ApacheHttpClientEngine.MemoryUnit.of(threshold.sizeUnit());
    }

    @Deprecated
    public ApacheHttpClientEngine.MemoryUnit getFileUploadMemoryUnit() {
        return this.fileUploadMemoryUnit;
    }

    @Deprecated
    public void setFileUploadMemoryUnit(ApacheHttpClientEngine.MemoryUnit fileUploadMemoryUnit) {
        this.fileUploadMemoryUnit = fileUploadMemoryUnit;
    }

    public File getFileUploadTempFileDir() {
        return this.fileUploadTempFileDir.toFile();
    }

    public void setFileUploadTempFileDir(File fileUploadTempFileDir) {
        this.fileUploadTempFileDir = fileUploadTempFileDir.toPath();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public static CaseInsensitiveMap<String> extractHeaders(HttpResponse response) {
        CaseInsensitiveMap headers = new CaseInsensitiveMap();
        for (Header header : response.getAllHeaders()) {
            headers.add((Object)header.getName(), (Object)header.getValue());
        }
        return headers;
    }

    protected InputStream createBufferedStream(InputStream is) {
        if (this.responseBufferSize == 0) {
            return is;
        }
        if (this.responseBufferSize < 0) {
            return new SelfExpandingBufferredInputStream(is);
        }
        return new BufferedInputStream(is, this.responseBufferSize);
    }

    public Response invoke(Invocation inv) {
        HttpResponse res;
        ClientInvocation request;
        block8: {
            request = (ClientInvocation)inv;
            String uri = request.getUri().toString();
            final HttpRequestBase httpMethod = this.createHttpMethod(uri, request.getMethod());
            try {
                this.loadHttpMethod(request, httpMethod);
                if (System.getSecurityManager() == null) {
                    res = this.httpClient.execute((HttpUriRequest)httpMethod, this.httpContextProvider == null ? null : this.httpContextProvider.getContext());
                    break block8;
                }
                try {
                    res = AccessController.doPrivileged(new PrivilegedExceptionAction<HttpResponse>(){

                        @Override
                        public HttpResponse run() throws Exception {
                            return ManualClosingApacheHttpClient43Engine.this.httpClient.execute((HttpUriRequest)httpMethod, ManualClosingApacheHttpClient43Engine.this.httpContextProvider == null ? null : ManualClosingApacheHttpClient43Engine.this.httpContextProvider.getContext());
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw new RuntimeException(pae);
                }
            }
            catch (Exception e) {
                LogMessages.LOGGER.clientSendProcessingFailure((Throwable)e);
                throw new ProcessingException(Messages.MESSAGES.unableToInvokeRequest(e.toString()), (Throwable)e);
            }
            finally {
                this.cleanUpAfterExecute(httpMethod);
            }
        }
        FinalizedClientResponse response = new FinalizedClientResponse(request.getClientConfiguration(), request.getTracingLogger()){
            InputStream stream;
            InputStream hc4Stream;

            @Override
            protected void setInputStream(InputStream is) {
                this.stream = is;
                this.resetEntity();
            }

            public InputStream getInputStream() {
                if (this.stream == null) {
                    HttpEntity entity = res.getEntity();
                    if (entity == null) {
                        return null;
                    }
                    try {
                        this.hc4Stream = entity.getContent();
                        this.stream = ManualClosingApacheHttpClient43Engine.this.createBufferedStream(this.hc4Stream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.stream;
            }

            public void releaseConnection() throws IOException {
                this.releaseConnection(true);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void releaseConnection(boolean consumeInputStream) throws IOException {
                if (consumeInputStream) {
                    try {
                        if (this.stream != null) {
                            this.stream.close();
                            return;
                        }
                        InputStream is = this.getInputStream();
                        if (is == null) return;
                        is.close();
                        return;
                    }
                    finally {
                        if (this.hc4Stream != null) {
                            try {
                                this.hc4Stream.close();
                            }
                            catch (IOException is) {}
                        } else {
                            try {
                                HttpEntity entity = res.getEntity();
                                if (entity != null) {
                                    entity.getContent().close();
                                }
                            }
                            catch (IOException entity) {}
                        }
                    }
                }
                if (!(res instanceof CloseableHttpResponse)) return;
                try {
                    ((CloseableHttpResponse)res).close();
                    return;
                }
                catch (IOException e) {
                    LogMessages.LOGGER.warn((Object)Messages.MESSAGES.couldNotCloseHttpResponse(), (Throwable)e);
                }
            }
        };
        response.setProperties(request.getMutableProperties());
        response.setStatus(res.getStatusLine().getStatusCode());
        response.setReasonPhrase(res.getStatusLine().getReasonPhrase());
        response.setHeaders((MultivaluedMap<String, String>)ManualClosingApacheHttpClient43Engine.extractHeaders(res));
        response.setClientConfiguration(request.getClientConfiguration());
        return response;
    }

    protected HttpRequestBase createHttpMethod(String url, String restVerb) {
        if ("GET".equals(restVerb)) {
            return new HttpGet(url);
        }
        if ("POST".equals(restVerb)) {
            return new HttpPost(url);
        }
        final String verb = restVerb;
        return new HttpPost(url){

            public String getMethod() {
                return verb;
            }
        };
    }

    protected void loadHttpMethod(ClientInvocation request, HttpRequestBase httpMethod) throws Exception {
        if (this.isFollowRedirects()) {
            this.setRedirectRequired(request, httpMethod);
        } else {
            this.setRedirectNotRequired(request, httpMethod);
        }
        if (request.getEntity() != null) {
            if (httpMethod instanceof HttpGet) {
                throw new ProcessingException(Messages.MESSAGES.getRequestCannotHaveBody());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            request.getDelegatingOutputStream().setDelegate((OutputStream)baos);
            try {
                HttpEntity entity = this.buildEntity(request);
                HttpPost post = (HttpPost)httpMethod;
                this.commitHeaders(request, httpMethod);
                post.setEntity(entity);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.commitHeaders(request, httpMethod);
        }
    }

    protected void commitHeaders(ClientInvocation request, HttpRequestBase httpMethod) {
        MultivaluedMap<String, String> headers = request.getHeaders().asMap();
        for (Map.Entry header : headers.entrySet()) {
            List values = (List)header.getValue();
            for (String value : values) {
                httpMethod.addHeader((String)header.getKey(), value);
            }
        }
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    protected void cleanUpAfterExecute(HttpRequestBase httpMethod) {
    }

    protected HttpEntity buildEntity(ClientInvocation request) throws IOException {
        AbstractHttpEntity entityToBuild = null;
        try (ClientEntityOutputStream entityStream = this.writeRequestBodyToOutputStream(request);){
            MediaType mediaType = request.getHeaders().getMediaType();
            entityToBuild = entityStream.toEntity();
            if (mediaType != null) {
                entityToBuild.setContentType((Header)new BasicHeader("Content-Type", mediaType.toString()));
            }
            if (request.isChunked()) {
                entityToBuild.setChunked(true);
            }
        }
        return entityToBuild;
    }

    private ClientEntityOutputStream writeRequestBodyToOutputStream(ClientInvocation request) throws IOException {
        try (ClientEntityOutputStream entityStream = new ClientEntityOutputStream(Threshold.of((long)this.fileUploadInMemoryThresholdLimit, (SizeUnit)this.fileUploadMemoryUnit.toSizeUnit()), this.fileUploadTempFileDir, this::getTempfilePrefix);){
            request.getDelegatingOutputStream().setDelegate((OutputStream)((Object)entityStream));
            request.writeRequestBody(request.getEntityStream());
            ClientEntityOutputStream clientEntityOutputStream = entityStream;
            return clientEntityOutputStream;
        }
    }

    protected String getTempfilePrefix() {
        return processId;
    }

    protected HttpClient createDefaultHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        if (this.defaultProxy != null) {
            requestBuilder.setProxy(this.defaultProxy);
        }
        builder.disableContentCompression();
        builder.setDefaultRequestConfig(requestBuilder.build());
        return builder.build();
    }

    public HttpHost getDefaultProxy() {
        Configurable clientConfiguration = (Configurable)this.httpClient;
        return clientConfiguration.getConfig().getProxy();
    }

    protected void setRedirectRequired(ClientInvocation request, HttpRequestBase httpMethod) {
        RequestConfig.Builder requestBuilder = RequestConfig.copy((RequestConfig)this.getCurrentConfiguration(request, httpMethod));
        requestBuilder.setRedirectsEnabled(true);
        httpMethod.setConfig(requestBuilder.build());
    }

    protected void setRedirectNotRequired(ClientInvocation request, HttpRequestBase httpMethod) {
        RequestConfig.Builder requestBuilder = RequestConfig.copy((RequestConfig)this.getCurrentConfiguration(request, httpMethod));
        requestBuilder.setRedirectsEnabled(false);
        httpMethod.setConfig(requestBuilder.build());
    }

    private RequestConfig getCurrentConfiguration(ClientInvocation request, HttpRequestBase httpMethod) {
        RequestConfig baseConfig;
        if (httpMethod != null && httpMethod.getConfig() != null) {
            baseConfig = httpMethod.getConfig();
        } else {
            ManualClosingApacheHttpClient43Engine engine = (ManualClosingApacheHttpClient43Engine)request.getClient().httpEngine();
            baseConfig = ((Configurable)engine.getHttpClient()).getConfig();
            if (baseConfig == null) {
                Configurable clientConfiguration = (Configurable)this.httpClient;
                baseConfig = clientConfiguration.getConfig();
            }
        }
        return baseConfig;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void close() {
        this.autoClosed.set(false);
        this.cleanable.clean();
    }

    private static Cleaner.Cleanable createCleanable(ManualClosingApacheHttpClient43Engine engine, boolean allowClose, AtomicBoolean closed, AtomicBoolean autoClosed, HttpClient client) {
        if (allowClose && client instanceof CloseableHttpClient) {
            return ResourceCleaner.register((Object)engine, (Runnable)new CleanupAction(closed, autoClosed, (CloseableHttpClient)client));
        }
        return () -> closed.set(true);
    }

    private static Path getTempDir() {
        return Path.of(ManualClosingApacheHttpClient43Engine.getProperty("java.io.tmpdir", String.class, () -> System.getProperty("java.io.tmpdir")), new String[0]);
    }

    private static <T> T getProperty(String name, Class<T> type, Supplier<T> dft) {
        if (System.getSecurityManager() == null) {
            return ConfigurationFactory.getInstance().getConfiguration().getOptionalValue(name, type).orElseGet(dft);
        }
        return (T)AccessController.doPrivileged(() -> ConfigurationFactory.getInstance().getConfiguration().getOptionalValue(name, type).orElseGet(dft));
    }

    static {
        try {
            processId = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return ManagementFactory.getRuntimeMXBean().getName().replaceAll("[^0-9a-zA-Z]", "");
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae);
        }
    }

    private static class CleanupAction
    implements Runnable {
        private final AtomicBoolean closed;
        private final AtomicBoolean autoClosed;
        private final CloseableHttpClient client;

        private CleanupAction(AtomicBoolean closed, AtomicBoolean autoClosed, CloseableHttpClient client) {
            this.closed = closed;
            this.autoClosed = autoClosed;
            this.client = client;
        }

        @Override
        public void run() {
            if (this.closed.compareAndSet(false, true) && this.client != null) {
                if (this.autoClosed.get()) {
                    LogMessages.LOGGER.closingForYou(this.getClass());
                }
                try {
                    this.client.close();
                }
                catch (Exception e) {
                    LogMessages.LOGGER.debugf((Throwable)e, "Failed to close client %s", (Object)this.client);
                }
            }
        }
    }
}

