/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceCheckListState;
import org.lastbamboo.common.ice.IceMediaStream;
import org.lastbamboo.common.ice.IceMediaStreamFactory;
import org.lastbamboo.common.ice.IceState;
import org.lastbamboo.common.ice.IceStunUdpPeer;
import org.lastbamboo.common.ice.IceTieBreaker;
import org.lastbamboo.common.ice.IceTransactionDelayCalculator;
import org.lastbamboo.common.ice.IceUdpConnectException;
import org.lastbamboo.common.ice.UdpSocketFactory;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidatePair;
import org.lastbamboo.common.ice.sdp.IceCandidateSdpDecoderImpl;
import org.lastbamboo.common.offer.answer.IceMediaStreamDesc;
import org.lastbamboo.common.offer.answer.OfferAnswer;
import org.lastbamboo.common.offer.answer.OfferAnswerListener;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceAgentImpl
implements IceAgent {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile boolean controlling;
    private AtomicReference<IceState> iceState = new AtomicReference<IceState>(IceState.RUNNING);
    private final Collection<IceMediaStream> mediaStreams = new ArrayList<IceMediaStream>(1);
    private final IceTieBreaker tieBreaker;
    private final IceMediaStream mediaStream;
    private final OfferAnswerListener offerAnswerListener;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final UdpSocketFactory reliableUdpSocketFactory;
    private final IceStunUdpPeer stunUdpPeer;
    private final UdpSocketFactory unreliableUdpSocketFactory;
    private final IceMediaStreamDesc iceMediaStreamDesc;

    public IceAgentImpl(IceMediaStreamFactory mediaStreamFactory, boolean controlling, OfferAnswerListener offerAnswerListener, UdpSocketFactory udpSocketFactory, UdpSocketFactory unreliableUdpSocketFactory, IceMediaStreamDesc iceMediaStreamDesc) throws IceUdpConnectException {
        this.controlling = controlling;
        this.offerAnswerListener = offerAnswerListener;
        this.reliableUdpSocketFactory = udpSocketFactory;
        this.unreliableUdpSocketFactory = unreliableUdpSocketFactory;
        this.iceMediaStreamDesc = iceMediaStreamDesc;
        this.tieBreaker = new IceTieBreaker();
        this.mediaStream = mediaStreamFactory.newStream(this, iceMediaStreamDesc);
        this.stunUdpPeer = this.mediaStream.getStunUdpPeer();
        this.mediaStreams.add(this.mediaStream);
    }

    private void setIceState(IceState state) {
        this.iceState.set(state);
        if (state == IceState.COMPLETED) {
            IceCandidatePair pair = this.getNominatedPair();
            IoSession session = pair.getIoSession();
            if (this.iceMediaStreamDesc.isReliable()) {
                this.reliableUdpSocketFactory.newEndpoint(session, this.isControlling(), this.offerAnswerListener, this.stunUdpPeer, this);
            } else {
                this.unreliableUdpSocketFactory.newEndpoint(session, this.isControlling(), this.offerAnswerListener, this.stunUdpPeer, this);
            }
        } else if (state == IceState.FAILED) {
            this.log.debug("Got ICE failed.  Closing.");
            this.close();
            this.offerAnswerListener.onOfferAnswerFailed((OfferAnswer)this);
        }
    }

    @Override
    public void checkValidPairsForAllComponents(IceMediaStream mediaStream) {
    }

    @Override
    public void onUnfreezeCheckLists(IceMediaStream mediaStream) {
    }

    @Override
    public long calculateDelay(int Ta_i) {
        return IceTransactionDelayCalculator.calculateDelay(Ta_i, this.mediaStreams.size());
    }

    @Override
    public boolean isControlling() {
        return this.controlling;
    }

    @Override
    public void setControlling(boolean controlling) {
        Thread.dumpStack();
        this.log.warn("Setting controlling to: " + controlling);
    }

    @Override
    public void recomputePairPriorities() {
        this.mediaStream.recomputePairPriorities(this.controlling);
    }

    @Override
    public IceTieBreaker getTieBreaker() {
        return this.tieBreaker;
    }

    public byte[] generateAnswer() {
        return this.mediaStream.encodeCandidates();
    }

    public byte[] generateOffer() {
        return this.mediaStream.encodeCandidates();
    }

    public void processOffer(ByteBuffer offer) {
        this.processRemoteCandidates(offer);
    }

    public void processAnswer(ByteBuffer answer) {
        if (this.closed.get()) {
            this.log.info("UDP ICE agent is already closed! Ignoring answer.");
            return;
        }
        this.processRemoteCandidates(answer);
    }

    private void processRemoteCandidates(ByteBuffer encodedCandidates) {
        Collection<IceCandidate> remoteCandidates;
        if (this.closed.get()) {
            this.log.info("Already closed -- not processing remote candidates");
            return;
        }
        IceCandidateSdpDecoderImpl decoder = new IceCandidateSdpDecoderImpl();
        try {
            remoteCandidates = decoder.decode(encodedCandidates, !this.controlling);
        }
        catch (IOException e) {
            this.log.warn("Could not process remote candidates", (Throwable)e);
            this.setIceState(IceState.FAILED);
            return;
        }
        try {
            this.mediaStream.establishStream(remoteCandidates);
        }
        catch (RuntimeException e) {
            this.log.error("Error establishing stream", (Throwable)e);
            this.setIceState(IceState.FAILED);
        }
    }

    @Override
    public Collection<IceMediaStream> getMediaStreams() {
        return Collections.unmodifiableCollection(this.mediaStreams);
    }

    @Override
    public void onNominatedPair(IceCandidatePair pair, IceMediaStream mediaStream) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received nominated pair on agent.  Controlling: {} pair: {}", (Object)this.isControlling(), (Object)pair);
        }
        if (this.closed.get()) {
            this.log.info("Agent closed. Ignoring nomination.");
            return;
        }
        IceCheckListState state = mediaStream.getCheckListState();
        if (state == IceCheckListState.RUNNING) {
            mediaStream.onNominated(pair);
            mediaStream.setCheckListState(IceCheckListState.COMPLETED);
            if (this.allCheckListsInState(IceCheckListState.COMPLETED)) {
                this.setIceState(IceState.COMPLETED);
                if (this.isControlling()) {
                    // empty if block
                }
            }
        } else if (state == IceCheckListState.FAILED) {
            if (this.allCheckListsInState(IceCheckListState.FAILED)) {
                this.log.debug("All check lists are failed...agent is failed");
                this.setIceState(IceState.FAILED);
            } else if (this.anyCheckListInState(IceCheckListState.COMPLETED)) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean anyCheckListInState(IceCheckListState state) {
        Collection<IceMediaStream> collection = this.mediaStreams;
        synchronized (collection) {
            for (IceMediaStream stream : this.mediaStreams) {
                IceCheckListState curState = stream.getCheckListState();
                if (state != curState) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allCheckListsInState(IceCheckListState state) {
        Collection<IceMediaStream> collection = this.mediaStreams;
        synchronized (collection) {
            for (IceMediaStream stream : this.mediaStreams) {
                IceCheckListState curState = stream.getCheckListState();
                if (state == curState) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public IceState getIceState() {
        return this.iceState.get();
    }

    @Override
    public Queue<IceCandidatePair> getNominatedPairs() {
        return this.mediaStream.getNominatedPairs();
    }

    @Override
    public void onValidPairs(IceMediaStream mediaStream) {
        this.log.debug("Processing valid pair...");
        if (this.closed.get()) {
            this.log.info("Already closed...ingoring");
            return;
        }
        if (!this.isControlling()) {
            this.log.debug("Not the controlling agent, so not sending a message to select the final pair.");
        } else {
            Queue<IceCandidatePair> validPairs = mediaStream.getValidPairs();
            IceCandidatePair pair = validPairs.peek();
            if (pair.isNominated()) {
                this.log.debug("Pair already nominated!!!");
                return;
            }
            this.log.debug("Repeating check that produced the valid pair using USE-CANDIDATE");
            pair.useCandidate();
            mediaStream.addTriggeredPair(pair);
        }
    }

    private IceCandidatePair getNominatedPair() {
        Queue<IceCandidatePair> pairs = this.getNominatedPairs();
        IceCandidatePair topPriorityPair = pairs.peek();
        if (topPriorityPair == null) {
            this.log.warn("No nominated pairs");
            return null;
        }
        return topPriorityPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean wasClosed = this.closed.getAndSet(true);
        if (wasClosed) {
            this.log.debug("Already closed.");
            return;
        }
        this.log.info("Closing ICE agent.");
        Collection<IceMediaStream> collection = this.mediaStreams;
        synchronized (collection) {
            for (IceMediaStream stream : this.mediaStreams) {
                stream.close();
            }
        }
    }

    @Override
    public void onNoMorePairs() {
        this.log.debug("No more pairs.");
        if (this.iceState.get() != IceState.COMPLETED && this.iceState.get() != IceState.FAILED) {
            this.log.debug("Setting ice state to failed -- no more pairs.");
            this.setIceState(IceState.FAILED);
        }
    }

    public void closeTcp() {
    }

    public void closeUdp() {
        this.close();
    }

    @Override
    public Collection<? extends IceCandidate> gatherCandidates() {
        return this.mediaStream.getLocalCandidates();
    }

    public InetAddress getPublicAdress() {
        return this.mediaStream.getPublicAddress();
    }

    public void useRelay() {
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }
}

