/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import javax.net.SocketFactory;
import org.lastbamboo.common.ice.IceAgentImpl;
import org.lastbamboo.common.ice.IceMediaStreamFactory;
import org.lastbamboo.common.ice.IceOfferAnswer;
import org.lastbamboo.common.ice.IceUdpConnectException;
import org.lastbamboo.common.ice.MappedServerSocket;
import org.lastbamboo.common.ice.MappedTcpOffererServerPool;
import org.lastbamboo.common.ice.RawUdpSocketFactory;
import org.lastbamboo.common.ice.TcpOfferAnswer;
import org.lastbamboo.common.ice.TcpTurnOfferAnswer;
import org.lastbamboo.common.ice.UdpSocketFactory;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.sdp.IceCandidateSdpEncoder;
import org.lastbamboo.common.offer.answer.IceMediaStreamDesc;
import org.lastbamboo.common.offer.answer.OfferAnswer;
import org.lastbamboo.common.offer.answer.OfferAnswerConnectException;
import org.lastbamboo.common.offer.answer.OfferAnswerFactory;
import org.lastbamboo.common.offer.answer.OfferAnswerListener;
import org.lastbamboo.common.turn.client.TurnClientListener;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.util.CandidateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceOfferAnswerFactory<T>
implements OfferAnswerFactory<T> {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final IceMediaStreamFactory m_mediaStreamFactory;
    private final UdpSocketFactory<T> m_udpSocketFactory;
    private final CandidateProvider<InetSocketAddress> m_turnCandidateProvider;
    private final MappedServerSocket m_answererServer;
    private final TurnClientListener m_turnClientListener;
    private final CandidateProvider<InetSocketAddress> m_stunCandidateProvider;
    private final MappedTcpOffererServerPool m_offererServer;
    private final SocketFactory m_socketFactory;

    public IceOfferAnswerFactory(IceMediaStreamFactory mediaStreamFactory, UdpSocketFactory<T> udpSocketFactory, CandidateProvider<InetSocketAddress> turnCandidateProvider, MappedServerSocket answererServer, TurnClientListener turnClientListener, CandidateProvider<InetSocketAddress> stunCandidateProvider, MappedTcpOffererServerPool offererServer, SocketFactory socketFactory) {
        this.m_mediaStreamFactory = mediaStreamFactory;
        this.m_udpSocketFactory = udpSocketFactory;
        this.m_turnCandidateProvider = turnCandidateProvider;
        this.m_answererServer = answererServer;
        this.m_turnClientListener = turnClientListener;
        this.m_stunCandidateProvider = stunCandidateProvider;
        this.m_offererServer = offererServer;
        this.m_socketFactory = socketFactory;
    }

    public OfferAnswer createAnswerer(OfferAnswerListener<T> offerAnswerListener, boolean useRelay) throws OfferAnswerConnectException {
        return this.createOfferAnswer(false, offerAnswerListener, new IceMediaStreamDesc(true, true, "message", "http", 1, useRelay, true));
    }

    public OfferAnswer createOfferer(OfferAnswerListener<T> offerAnswerListener, IceMediaStreamDesc desc) throws OfferAnswerConnectException {
        return this.createOfferAnswer(true, offerAnswerListener, desc);
    }

    private OfferAnswer createOfferAnswer(final boolean controlling, OfferAnswerListener<T> offerAnswerListener, final IceMediaStreamDesc mediaDesc) throws OfferAnswerConnectException {
        final IceOfferAnswer turnOfferAnswer = this.newTurnOfferAnswer(controlling, offerAnswerListener, mediaDesc);
        final IceOfferAnswer udp = this.newUdpOfferAnswer(controlling, offerAnswerListener, mediaDesc);
        final IceOfferAnswer tcp = this.newTcpOfferAnswer(offerAnswerListener, controlling, mediaDesc);
        return new OfferAnswer(){

            public byte[] generateOffer() {
                return IceOfferAnswerFactory.this.encodeCandidates(controlling, tcp, udp, turnOfferAnswer, mediaDesc);
            }

            public byte[] generateAnswer() {
                return IceOfferAnswerFactory.this.encodeCandidates(controlling, tcp, udp, turnOfferAnswer, mediaDesc);
            }

            public void close() {
                if (tcp != null) {
                    tcp.close();
                }
                if (turnOfferAnswer != null) {
                    turnOfferAnswer.close();
                }
                if (udp != null) {
                    udp.close();
                }
            }

            public void processAnswer(ByteBuffer answer) {
                IceOfferAnswerFactory.this.m_log.info("Processing answer...");
                IceOfferAnswerFactory.this.m_log.info("Turn offer answer: {}", (Object)turnOfferAnswer);
                if (mediaDesc.isUseRelay() && turnOfferAnswer != null) {
                    turnOfferAnswer.processAnswer(answer.duplicate());
                }
                if (mediaDesc.isTcp() && tcp != null) {
                    tcp.processAnswer(answer.duplicate());
                }
                if (mediaDesc.isUdp() && udp != null) {
                    udp.processAnswer(answer.duplicate());
                }
            }

            public void processOffer(ByteBuffer offer) {
                IceOfferAnswerFactory.this.m_log.info("Processing offer...");
                if (mediaDesc.isTcp() && tcp != null) {
                    tcp.processOffer(offer);
                }
                if (mediaDesc.isUdp() && udp != null) {
                    udp.processOffer(offer);
                }
                if (mediaDesc.isUseRelay() && turnOfferAnswer != null) {
                    turnOfferAnswer.processOffer(offer);
                }
                IceOfferAnswerFactory.this.m_log.info("Done processing offer...");
            }

            public void closeTcp() {
                if (tcp != null) {
                    tcp.close();
                }
                if (turnOfferAnswer != null) {
                    turnOfferAnswer.close();
                }
            }

            public void closeUdp() {
                if (udp != null) {
                    udp.close();
                }
            }

            public void useRelay() {
                IceOfferAnswerFactory.this.m_log.info("Sending use relay notification.");
                if (tcp != null) {
                    tcp.useRelay();
                }
                if (turnOfferAnswer != null) {
                    turnOfferAnswer.useRelay();
                }
            }
        };
    }

    private IceOfferAnswer newTcpOfferAnswer(OfferAnswerListener<T> offerAnswerListener, boolean controlling, IceMediaStreamDesc mediaDesc) {
        if (mediaDesc.isTcp()) {
            this.m_log.info("Creating new TCP offer answer");
            return new TcpOfferAnswer<T>(offerAnswerListener, controlling, this.m_answererServer, this.m_stunCandidateProvider, this.m_offererServer, this.m_socketFactory);
        }
        return null;
    }

    private IceOfferAnswer newUdpOfferAnswer(boolean controlling, OfferAnswerListener<T> offerAnswerListener, IceMediaStreamDesc mediaDesc) throws OfferAnswerConnectException {
        if (mediaDesc.isUdp()) {
            try {
                this.m_log.info("Creating UDP offer answer...");
                return new IceAgentImpl(this.m_mediaStreamFactory, controlling, offerAnswerListener, this.m_udpSocketFactory, new RawUdpSocketFactory(), mediaDesc);
            }
            catch (IceUdpConnectException e) {
                throw new OfferAnswerConnectException("Could not create UDP connection", (Exception)e);
            }
        }
        return null;
    }

    private byte[] encodeCandidates(boolean controlling, IceOfferAnswer tcp, IceOfferAnswer udp, IceOfferAnswer tcpTurn, IceMediaStreamDesc mediaDesc) {
        IceCandidateSdpEncoder encoder = new IceCandidateSdpEncoder(mediaDesc.getMimeContentType(), mediaDesc.getMimeContentSubtype());
        HashSet<IceCandidate> localCandidates = new HashSet<IceCandidate>();
        if (tcp != null) {
            localCandidates.addAll(tcp.gatherCandidates());
        }
        if (udp != null) {
            localCandidates.addAll(udp.gatherCandidates());
        }
        if (!controlling && mediaDesc.isUseRelay() && tcpTurn != null) {
            localCandidates.addAll(tcpTurn.gatherCandidates());
        }
        encoder.visitCandidates(localCandidates);
        return encoder.getSdp();
    }

    private IceOfferAnswer newTurnOfferAnswer(boolean controlling, OfferAnswerListener<T> offerAnswerListener, IceMediaStreamDesc mediaDesc) {
        if (!mediaDesc.isUseRelay()) {
            return null;
        }
        try {
            TcpTurnOfferAnswer turn = new TcpTurnOfferAnswer(this.m_turnCandidateProvider, controlling, offerAnswerListener, this.m_turnClientListener);
            if (!controlling) {
                turn.connect();
            }
            return turn;
        }
        catch (IOException e) {
            this.m_log.error("Could not connect to TURN server!!", (Throwable)e);
            return null;
        }
    }

    public boolean isAnswererPortMapped() {
        return this.m_answererServer.isPortMapped();
    }

    public int getMappedPort() {
        return this.m_answererServer.getMappedPort();
    }
}

