/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import org.lastbamboo.common.ice.IceTransportProtocol;
import org.lastbamboo.common.ice.candidate.IceCandidateType;

public class IcePriorityCalculator {
    private static final int DEFAULT_COMPONENT_ID = 1;
    private static final int LOCAL_PREFERENCE = 65535;
    private static final int TCP_TRANSPORT_PREF = 15;
    private static final int UDP_TRANSPORT_PREF = 6;

    public static long calculatePriority(IceCandidateType type, IceTransportProtocol transport) {
        return (long)(Math.pow(2.0, 24.0) * (double)type.getTypePreference()) + (long)(Math.pow(2.0, 8.0) * (double)IcePriorityCalculator.calculateLocalPreference(transport)) + (long)((int)(Math.pow(2.0, 0.0) * 255.0));
    }

    private static long calculateLocalPreference(IceTransportProtocol transport) {
        long transportPref = 0L;
        long directionPref = 0L;
        switch (transport) {
            case TCP_ACT: {
                transportPref = 15L;
                directionPref = 5L;
                break;
            }
            case TCP_PASS: {
                transportPref = 15L;
                directionPref = 2L;
                break;
            }
            case TCP_SO: {
                transportPref = 15L;
                directionPref = 7L;
                break;
            }
            case UDP: {
                transportPref = 6L;
                directionPref = 4L;
            }
        }
        int otherPref = 511;
        return (long)(Math.pow(2.0, 12.0) * (double)transportPref) + (long)(Math.pow(2.0, 9.0) * (double)directionPref) + (long)((int)(Math.pow(2.0, 0.0) * 511.0));
    }
}

