/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ServerSocketFactory;
import org.apache.commons.io.IOExceptionWithCause;
import org.lastbamboo.common.ice.PortMappedServerSocket;
import org.lastbamboo.common.portmapping.NatPmpService;
import org.lastbamboo.common.portmapping.PortMapListener;
import org.lastbamboo.common.portmapping.PortMappingProtocol;
import org.lastbamboo.common.portmapping.UpnpService;
import org.littleshoot.util.CommonUtils;
import org.littleshoot.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedTcpOffererServerPool {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Queue<PortMappedServerSocket> servers = new ConcurrentLinkedQueue<PortMappedServerSocket>();
    private final NatPmpService natPmpService;
    private final UpnpService upnpService;
    private final ServerSocketFactory serverSocketFactory;

    public MappedTcpOffererServerPool(NatPmpService natPmpService, UpnpService upnpService, ServerSocketFactory serverSocketFactory) {
        this.natPmpService = natPmpService;
        this.upnpService = upnpService;
        this.serverSocketFactory = serverSocketFactory;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 6; ++i) {
                    try {
                        MappedTcpOffererServerPool.this.addServerSocket(MappedTcpOffererServerPool.this.serverSocket());
                        continue;
                    }
                    catch (IOException e) {
                        MappedTcpOffererServerPool.this.log.error("Could not create server socket!");
                    }
                }
            }
        };
        Thread t = new Thread(runner, "Mapped-Offerer-Server-Socket-Creation-Thread");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortMappedServerSocket serverSocket() throws IOException {
        Queue<PortMappedServerSocket> queue = this.servers;
        synchronized (queue) {
            if (this.servers.isEmpty()) {
                return this.randomPortServer();
            }
            return this.servers.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerSocket(PortMappedServerSocket ss) {
        Queue<PortMappedServerSocket> queue = this.servers;
        synchronized (queue) {
            if (this.servers.contains(ss)) {
                this.log.warn("We already have this server socket -- bug in calling code?", (Object)ss);
            } else {
                this.servers.add(ss);
            }
        }
    }

    private PortMappedServerSocket randomPortServer() throws IOException {
        IOException ioe = null;
        InetAddress lh = NetworkUtils.getLocalHost();
        for (int i = 0; i < 20; ++i) {
            try {
                ServerSocket ss = this.serverSocketFactory.createServerSocket();
                int port = CommonUtils.randomPort();
                InetSocketAddress endpoint = new InetSocketAddress(lh, port);
                ss.bind(endpoint);
                ss.setSoTimeout(30000);
                boolean isPublic = NetworkUtils.isPublicAddress((InetAddress)lh);
                PortMappedServerSocket pmss = new PortMappedServerSocket(ss, isPublic);
                this.log.info("Attempting to map port {} via UPnP", (Object)port);
                this.upnpService.addUpnpMapping(PortMappingProtocol.TCP, port, port, (PortMapListener)pmss);
                this.log.info("Attempting to map port {} via NAT-PMP", (Object)port);
                this.natPmpService.addNatPmpMapping(PortMappingProtocol.TCP, port, port, (PortMapListener)pmss);
                return pmss;
            }
            catch (IOException e) {
                this.log.info("Error binding?", (Throwable)e);
                ioe = e;
                continue;
            }
        }
        if (ioe == null) {
            throw new IOException("Could not create server socket after many tries");
        }
        throw new IOExceptionWithCause("Could not create server socket after many tries", ioe);
    }
}

