/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceStunUdpPeer;
import org.lastbamboo.common.ice.UdpSocketFactory;
import org.lastbamboo.common.offer.answer.OfferAnswerListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.util.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawUdpSocketFactory
implements UdpSocketFactory<Socket> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void newEndpoint(IoSession session, boolean controlling, OfferAnswerListener<Socket> socketListener, IceStunUdpPeer stunUdpPeer, IceAgent iceAgent) {
        this.log.info("Creating new raw UDP Socket");
        if (session == null) {
            this.log.error("Null session: {}", (Object)session);
            return;
        }
        stunUdpPeer.close();
        try {
            DatagramChannel dc = DatagramChannel.open();
            dc.configureBlocking(true);
            dc.socket().bind(session.getLocalAddress());
            dc.connect(session.getRemoteAddress());
            DatagramSocketWrapper sock = new DatagramSocketWrapper(dc);
            socketListener.onUdpSocket((Object)sock);
        }
        catch (IOException e) {
            this.log.info("Could not create raw UDP socket", (Throwable)e);
        }
    }

    private static final class DatagramSocketOutputStreamWrapper
    extends OutputStream {
        private final DatagramChannel dc;

        public DatagramSocketOutputStreamWrapper(DatagramChannel dc) {
            this.dc = dc;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] byteArray) throws IOException {
            this.write(byteArray, 0, byteArray.length);
        }

        @Override
        public void write(byte[] byteArray, int offset, int length) throws IOException {
            int mtu = 1450;
            ByteBuffer[] srcs = ByteBufferUtils.toArray((byte[])byteArray, (int)1450);
            this.dc.write(srcs, offset, length);
        }
    }

    private static final class DatagramSocketInputStreamWrapper
    extends InputStream {
        private final DatagramChannel dc;

        public DatagramSocketInputStreamWrapper(DatagramChannel dc) {
            this.dc = dc;
        }

        @Override
        public int read() throws IOException {
            return this.read(new byte[1]);
        }

        @Override
        public int read(byte[] data) throws IOException {
            return this.read(data, 0, data.length);
        }

        @Override
        public int read(byte[] byteArray, int offset, int length) throws IOException {
            return this.dc.read(ByteBuffer.wrap(byteArray, offset, length));
        }
    }

    private static final class DatagramSocketWrapper
    extends Socket {
        private final DatagramChannel dc;

        private DatagramSocketWrapper(DatagramChannel dc) {
            this.dc = dc;
        }

        @Override
        public InputStream getInputStream() {
            return new DatagramSocketInputStreamWrapper(this.dc);
        }

        @Override
        public OutputStream getOutputStream() {
            return new DatagramSocketOutputStreamWrapper(this.dc);
        }

        @Override
        public synchronized void close() {
            try {
                this.dc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

