/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.lastbamboo.common.ice.IceOfferAnswer;
import org.lastbamboo.common.ice.MappedServerSocket;
import org.lastbamboo.common.ice.MappedTcpOffererServerPool;
import org.lastbamboo.common.ice.PortMappedServerSocket;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidateVisitorAdapter;
import org.lastbamboo.common.ice.candidate.IceTcpHostPassiveCandidate;
import org.lastbamboo.common.ice.sdp.IceCandidateSdpDecoderImpl;
import org.lastbamboo.common.offer.answer.OfferAnswerListener;
import org.lastbamboo.common.stun.client.PublicIpAddress;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.stun.stack.StunAddressProvider;
import org.littleshoot.util.CandidateProvider;
import org.littleshoot.util.RuntimeIoException;
import org.littleshoot.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpOfferAnswer<T>
implements IceOfferAnswer,
StunAddressProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<Socket> socketRef = new AtomicReference();
    private final boolean controlling;
    private final OfferAnswerListener<T> offerAnswerListener;
    private final MappedTcpOffererServerPool offererServer;
    private PortMappedServerSocket portMappedServerSocket;
    private final MappedServerSocket mappedServerSocket;
    private final SocketFactory socketFactory;
    private static final ExecutorService tcpIceServerThreadPool = Executors.newCachedThreadPool(new ThreadFactory(){
        private int count = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "TCP-Ice-Server-Thread-" + this.hashCode() + "-" + this.count);
            t.setDaemon(true);
            ++this.count;
            return t;
        }
    });

    public TcpOfferAnswer(OfferAnswerListener<T> offerAnswerListener, boolean controlling, MappedServerSocket answererServer, CandidateProvider<InetSocketAddress> stunCandidateProvider, MappedTcpOffererServerPool offererServer, SocketFactory socketFactory) {
        this.offerAnswerListener = offerAnswerListener;
        this.controlling = controlling;
        this.offererServer = offererServer;
        this.socketFactory = socketFactory;
        if (controlling || answererServer == null) {
            this.log.info("Using pooled offerer server");
            try {
                this.portMappedServerSocket = offererServer.serverSocket();
                this.mappedServerSocket = this.portMappedServerSocket;
                this.listen();
                this.log.info("Starting offer answer");
            }
            catch (IOException e) {
                this.log.error("Could not bind server socket", (Throwable)e);
                throw new RuntimeIoException("Could not bind server socket", (Exception)e);
            }
        } else {
            this.log.info("Using mapped server socket");
            this.mappedServerSocket = answererServer;
        }
    }

    public void close() {
        this.log.info("Closing!!");
        Socket sock = this.socketRef.get();
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException e) {
                this.log.info("Exception closing socket", (Throwable)e);
            }
        }
    }

    public void closeTcp() {
        this.close();
    }

    public void closeUdp() {
    }

    private void listen() {
        final ServerSocket ss = this.portMappedServerSocket.getServerSocket();
        final InetSocketAddress socketAddress = (InetSocketAddress)ss.getLocalSocketAddress();
        if (ss instanceof SSLServerSocket) {
            this.log.info("Enabled cipher suites on SSL server socket: {}", Arrays.asList(((SSLServerSocket)ss).getEnabledCipherSuites()));
        }
        Runnable serverRunner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TcpOfferAnswer.this.log.info("Waiting for incoming socket on: {}", (Object)socketAddress);
                    Socket sock = ss.accept();
                    if (sock instanceof SSLSocket) {
                        SSLSocket ssl = (SSLSocket)sock;
                        TcpOfferAnswer.this.log.info("Enabled cipher suites on accepted server socket: {}", Arrays.asList(ssl.getEnabledCipherSuites()));
                    }
                    TcpOfferAnswer.this.log.info("GOT INCOMING SOCKET FROM " + sock.getRemoteSocketAddress() + "!! Controlling: {}", (Object)TcpOfferAnswer.this.controlling);
                    sock.setKeepAlive(true);
                    TcpOfferAnswer.this.onSocket(sock);
                }
                catch (IOException e) {
                    TcpOfferAnswer.this.log.info("Exception accepting socket. This will often happen when the client side connects first, and we simply return the socket back to the pool.", (Throwable)e);
                }
                finally {
                    TcpOfferAnswer.this.offererServer.addServerSocket(TcpOfferAnswer.this.portMappedServerSocket);
                }
            }
        };
        tcpIceServerThreadPool.execute(serverRunner);
    }

    public byte[] generateAnswer() {
        String msg = "We fallback to the old code for gathering this for now.";
        this.log.error("TCP implemenation can't generate offers or answers");
        throw new UnsupportedOperationException("We fallback to the old code for gathering this for now.");
    }

    public byte[] generateOffer() {
        String msg = "We fallback to the old code for gathering this for now.";
        this.log.error("TCP implemenation can't generate offers or answers");
        throw new UnsupportedOperationException("We fallback to the old code for gathering this for now.");
    }

    public void processOffer(ByteBuffer offer) {
        this.processRemoteCandidates(offer);
    }

    public void processAnswer(ByteBuffer answer) {
        if (this.socketRef.get() != null) {
            this.log.info("Controlling side already has a socket -- ignoring answer.");
            return;
        }
        this.processRemoteCandidates(answer);
    }

    private void processRemoteCandidates(ByteBuffer encodedCandidates) {
        Collection<IceCandidate> remoteCandidates;
        IceCandidateSdpDecoderImpl decoder = new IceCandidateSdpDecoderImpl();
        try {
            remoteCandidates = decoder.decode(encodedCandidates, this.controlling);
        }
        catch (IOException e) {
            this.log.warn("Could not process remote candidates", (Throwable)e);
            return;
        }
        IceCandidateVisitorAdapter<Object> visitor = new IceCandidateVisitorAdapter<Object>(){

            @Override
            public Object visitTcpHostPassiveCandidate(IceTcpHostPassiveCandidate candidate) {
                TcpOfferAnswer.this.log.info("Visiting TCP passive host candidate: {}", (Object)candidate);
                return TcpOfferAnswer.this.connectToCandidate(candidate);
            }
        };
        for (IceCandidate candidate : remoteCandidates) {
            candidate.accept(visitor);
        }
    }

    private Object connectToCandidate(final IceCandidate candidate) {
        if (candidate == null) {
            this.log.warn("Null candidate?? " + ThreadUtils.dumpStack());
            return null;
        }
        Runnable threadRunner = new Runnable(){

            @Override
            public void run() {
                Socket sock = null;
                try {
                    TcpOfferAnswer.this.log.info("Connecting to: {}", (Object)candidate);
                    sock = TcpOfferAnswer.this.socketFactory.createSocket();
                    sock.setKeepAlive(true);
                    sock.connect(candidate.getSocketAddress(), 30000);
                    if (sock instanceof SSLSocket) {
                        SSLSocket ssl = (SSLSocket)sock;
                        TcpOfferAnswer.this.log.info("Enabled cipher suites on client side SSL socket: {}", Arrays.asList(ssl.getEnabledCipherSuites()));
                    }
                    TcpOfferAnswer.this.log.info("Client socket connected to: {}", (Object)sock.getRemoteSocketAddress());
                    TcpOfferAnswer.this.onSocket(sock);
                }
                catch (IOException e) {
                    TcpOfferAnswer.this.log.info("IO Exception connecting to: " + candidate, (Throwable)e);
                }
            }
        };
        tcpIceServerThreadPool.execute(threadRunner);
        return null;
    }

    private void onSocket(Socket sock) {
        if (this.socketRef.compareAndSet(null, sock)) {
            this.log.info("Notifying listener of TCP socket: {}", this.offerAnswerListener);
            this.offerAnswerListener.onTcpSocket(sock);
        } else {
            this.log.debug("Socket already exists! Ignoring second");
            if (this.controlling) {
                this.log.debug("Closing on controlling candidate");
                try {
                    sock.close();
                }
                catch (IOException e) {
                    this.log.error("Could not close socket", (Throwable)e);
                }
            } else {
                this.log.debug("Not closing on controlled candidate");
                this.offerAnswerListener.onTcpSocket(sock);
            }
        }
    }

    @Override
    public Collection<? extends IceCandidate> gatherCandidates() {
        ArrayList<IceTcpHostPassiveCandidate> candidates = new ArrayList<IceTcpHostPassiveCandidate>(2);
        InetSocketAddress hostAddress = this.getHostAddress();
        IceTcpHostPassiveCandidate hostCandidate = new IceTcpHostPassiveCandidate(hostAddress, this.controlling);
        candidates.add(hostCandidate);
        PublicIpAddress ip = new PublicIpAddress();
        InetAddress publicIp = ip.getPublicIpAddress();
        if (publicIp != null && this.mappedServerSocket.isPortMapped()) {
            this.log.info("Adding public TCP address");
            InetSocketAddress publicHostAddress = new InetSocketAddress(publicIp, this.mappedServerSocket.getMappedPort());
            IceTcpHostPassiveCandidate publicHostCandidate = new IceTcpHostPassiveCandidate(publicHostAddress, this.controlling);
            candidates.add(publicHostCandidate);
        } else {
            this.log.info("Not adding public candidate. PA: " + publicIp + " mapped: " + this.mappedServerSocket.isPortMapped());
        }
        return candidates;
    }

    public InetSocketAddress getHostAddress() {
        return this.mappedServerSocket.getHostAddress();
    }

    public InetSocketAddress getRelayAddress() {
        return null;
    }

    public InetSocketAddress getServerReflexiveAddress() throws IOException {
        return null;
    }

    public InetAddress getStunServerAddress() {
        return null;
    }

    public void useRelay() {
    }
}

