/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.candidate;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.lastbamboo.common.ice.IcePriorityCalculator;
import org.lastbamboo.common.ice.IceTransportProtocol;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidateType;
import org.lastbamboo.common.ice.candidate.IceFoundationCalculator;

public abstract class AbstractIceCandidate
implements IceCandidate,
Comparable<AbstractIceCandidate> {
    private final InetSocketAddress m_address;
    private final IceTransportProtocol m_transport;
    private final IceCandidateType m_candidateType;
    private final long m_priority;
    private final String m_foundation;
    private boolean m_controlling;
    private final IceCandidate m_baseCandidate;
    private final int m_componentId;
    private final InetAddress m_relatedAddress;
    private final int m_relatedPort;
    protected static final int DEFAULT_COMPONENT_ID = 1;
    private final boolean m_isUdp;

    public AbstractIceCandidate(InetSocketAddress socketAddress, InetAddress baseAddress, IceCandidateType type, IceTransportProtocol transport, boolean controlling) {
        this(socketAddress, IceFoundationCalculator.calculateFoundation(type, baseAddress, transport), type, transport, IcePriorityCalculator.calculatePriority(type, transport), controlling, 1, null, null, -1);
    }

    protected AbstractIceCandidate(InetSocketAddress socketAddress, String foundation, IceCandidateType type, IceTransportProtocol transport, long priority, boolean controlling, int componentId, IceCandidate baseCandidate, InetAddress relatedAddress, int relatedPort) {
        if (socketAddress == null) {
            throw new NullPointerException("Null socket address");
        }
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        if (transport == null) {
            throw new NullPointerException("Null transport");
        }
        this.m_address = socketAddress;
        this.m_candidateType = type;
        this.m_transport = transport;
        this.m_priority = priority;
        this.m_foundation = foundation;
        this.m_controlling = controlling;
        this.m_componentId = componentId;
        this.m_baseCandidate = baseCandidate == null ? this : baseCandidate;
        this.m_relatedAddress = relatedAddress;
        this.m_relatedPort = relatedPort;
        boolean udp = true;
        switch (transport) {
            case TCP_ACT: 
            case TCP_PASS: 
            case TCP_SO: {
                udp = false;
                break;
            }
            case UDP: {
                udp = true;
            }
        }
        this.m_isUdp = udp;
    }

    @Override
    public void setControlling(boolean controlling) {
        this.m_controlling = controlling;
    }

    @Override
    public IceTransportProtocol getTransport() {
        return this.m_transport;
    }

    @Override
    public IceCandidateType getType() {
        return this.m_candidateType;
    }

    @Override
    public final InetSocketAddress getSocketAddress() {
        return this.m_address;
    }

    @Override
    public final long getPriority() {
        return this.m_priority;
    }

    @Override
    public int getComponentId() {
        return this.m_componentId;
    }

    @Override
    public String getFoundation() {
        return this.m_foundation;
    }

    @Override
    public boolean isControlling() {
        return this.m_controlling;
    }

    @Override
    public IceCandidate getBaseCandidate() {
        return this.m_baseCandidate;
    }

    @Override
    public InetAddress getRelatedAddress() {
        return this.m_relatedAddress;
    }

    @Override
    public int getRelatedPort() {
        return this.m_relatedPort;
    }

    @Override
    public boolean isUdp() {
        return this.m_isUdp;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.m_address == null ? 0 : this.m_address.hashCode());
        result = 31 * result + (this.m_candidateType == null ? 0 : this.m_candidateType.hashCode());
        result = 31 * result + this.m_componentId;
        result = 31 * result + (this.m_foundation == null ? 0 : this.m_foundation.hashCode());
        result = 31 * result + (int)(this.m_priority ^ this.m_priority >>> 32);
        result = 31 * result + (this.m_transport == null ? 0 : this.m_transport.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractIceCandidate other = (AbstractIceCandidate)obj;
        if (this.m_address == null ? other.m_address != null : !this.m_address.equals(other.m_address)) {
            return false;
        }
        if (this.m_candidateType == null ? other.m_candidateType != null : !this.m_candidateType.equals((Object)other.m_candidateType)) {
            return false;
        }
        if (this.m_componentId != other.m_componentId) {
            return false;
        }
        if (this.m_foundation == null ? other.m_foundation != null : !this.m_foundation.equals(other.m_foundation)) {
            return false;
        }
        if (this.m_priority != other.m_priority) {
            return false;
        }
        return !(this.m_transport == null ? other.m_transport != null : !this.m_transport.equals((Object)other.m_transport));
    }

    @Override
    public int compareTo(AbstractIceCandidate other) {
        Long priority2;
        Long priority1 = this.m_priority;
        int priorityComparison = priority1.compareTo(priority2 = Long.valueOf(other.getPriority()));
        if (priorityComparison != 0) {
            return -priorityComparison;
        }
        if (!this.m_address.equals(other.m_address)) {
            return -1;
        }
        if (!this.m_candidateType.equals((Object)other.m_candidateType)) {
            return -1;
        }
        if (this.m_foundation != other.m_foundation) {
            return -1;
        }
        if (this.m_controlling != other.m_controlling) {
            return -1;
        }
        if (!this.m_transport.equals((Object)other.m_transport)) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" ");
        sb.append(this.m_controlling ? "controlling" : "controlled");
        sb.append(" ");
        sb.append(this.m_address);
        sb.append(this.m_isUdp ? " UDP" : " TCP");
        return sb.toString();
    }
}

