/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.sdp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.Vector;
import org.lastbamboo.common.ice.IceTransportProtocol;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidateType;
import org.lastbamboo.common.ice.candidate.IceTcpActiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpHostPassiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpRelayPassiveCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpHostCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpServerReflexiveCandidate;
import org.lastbamboo.common.ice.sdp.IceCandidateSdpDecoder;
import org.lastbamboo.common.sdp.api.Attribute;
import org.lastbamboo.common.sdp.api.MediaDescription;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpFactory;
import org.lastbamboo.common.sdp.api.SdpParseException;
import org.lastbamboo.common.sdp.api.SessionDescription;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.util.IoExceptionWithCause;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IceCandidateSdpDecoderImpl
implements IceCandidateSdpDecoder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String CANDIDATE_KEY = "candidate";
    private final SdpFactory sdpFactory = new SdpFactory();

    @Override
    public Collection<IceCandidate> decode(ByteBuffer buf, boolean controlling) throws IOException {
        String responseBodyString = MinaUtils.toAsciiString((ByteBuffer)buf);
        try {
            SessionDescription sdp = this.sdpFactory.createSessionDescription(responseBodyString);
            Vector mediaDescriptions = sdp.getMediaDescriptions(true);
            this.log.debug("Creating candidates from media descs:\n" + mediaDescriptions);
            return this.createCandidates(mediaDescriptions, controlling);
        }
        catch (SdpException e) {
            this.log.warn("Could not parse SDP: " + MinaUtils.toAsciiString((ByteBuffer)buf));
            throw new IoExceptionWithCause("Could not parse SDP", (Throwable)e);
        }
    }

    private Collection<IceCandidate> createCandidates(Collection<MediaDescription> remoteMediaDescriptions, boolean controlling) {
        ArrayList<IceCandidate> candidates = new ArrayList<IceCandidate>();
        for (MediaDescription mediaDesc : remoteMediaDescriptions) {
            Vector attributes = mediaDesc.getAttributes(true);
            for (Attribute attribute : attributes) {
                try {
                    if (!attribute.getName().equals(CANDIDATE_KEY)) continue;
                    String attributeValue = attribute.getValue();
                    Collection<IceCandidate> newCandidates = this.createCandidates(attributeValue, controlling);
                    candidates.addAll(newCandidates);
                }
                catch (UnknownHostException e) {
                    this.log.warn("Could not parse SDP", (Throwable)e);
                }
                catch (SdpParseException e) {
                    this.log.warn("Could not parse SDP", (Throwable)e);
                }
            }
        }
        return candidates;
    }

    private Collection<IceCandidate> createCandidates(String attribute, boolean controlling) throws UnknownHostException {
        this.log.trace("Parsing attribute: " + attribute);
        LinkedList<IceCandidate> candidates = new LinkedList<IceCandidate>();
        Scanner scanner = new Scanner(attribute);
        scanner.useDelimiter(" ");
        while (scanner.hasNext()) {
            IceCandidate candidate = this.createIceCandidate(scanner, controlling);
            candidates.add(candidate);
        }
        return candidates;
    }

    private IceCandidate createIceCandidate(Scanner scanner, boolean controlling) throws UnknownHostException {
        String foundation = scanner.next();
        int componentId = Integer.parseInt(scanner.next());
        String transportString = scanner.next();
        IceTransportProtocol transportProtocol = IceTransportProtocol.toTransport(transportString);
        if (transportProtocol == null) {
            this.log.warn("Null transport");
            throw new NullPointerException("Null transport");
        }
        int priority = Integer.parseInt(scanner.next());
        InetAddress address = InetAddress.getByName(scanner.next());
        int port = Integer.parseInt(scanner.next());
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        String typeToken = scanner.next();
        if (!typeToken.equals("typ")) {
            this.log.error("Unexpected type token: " + typeToken);
            throw new IllegalArgumentException("Unexpected type token: " + typeToken);
        }
        String typeString = scanner.next();
        IceCandidateType type = IceCandidateType.toType(typeString);
        if (type == null) {
            this.log.warn("Unrecognized type: " + typeString);
            throw new IllegalArgumentException("Unrecognized type: " + typeString);
        }
        block0 : switch (transportProtocol) {
            case UDP: {
                switch (type) {
                    case HOST: {
                        return new IceUdpHostCandidate(socketAddress, foundation, priority, controlling, componentId);
                    }
                    case RELAYED: {
                        break block0;
                    }
                    case PEER_REFLEXIVE: {
                        break block0;
                    }
                    case SERVER_REFLEXIVE: {
                        InetSocketAddress related = this.parseRelated(scanner);
                        return new IceUdpServerReflexiveCandidate(socketAddress, foundation, related.getAddress(), related.getPort(), controlling, priority, componentId);
                    }
                }
                break;
            }
            case TCP_PASS: {
                switch (type) {
                    case HOST: {
                        return new IceTcpHostPassiveCandidate(socketAddress, foundation, controlling, priority, componentId);
                    }
                    case RELAYED: {
                        this.log.debug("Received a TCP relay passive candidate");
                        InetSocketAddress related = this.parseRelated(scanner);
                        return new IceTcpRelayPassiveCandidate(socketAddress, foundation, related.getAddress(), related.getPort(), controlling, priority, componentId);
                    }
                    case PEER_REFLEXIVE: {
                        break block0;
                    }
                }
                break;
            }
            case TCP_SO: {
                switch (type) {
                    case HOST: {
                        break block0;
                    }
                    case RELAYED: {
                        break block0;
                    }
                    case PEER_REFLEXIVE: {
                        break block0;
                    }
                }
                break;
            }
            case TCP_ACT: {
                switch (type) {
                    case HOST: {
                        return new IceTcpActiveCandidate(socketAddress, controlling);
                    }
                    case RELAYED: {
                        break block0;
                    }
                    case PEER_REFLEXIVE: {
                        break block0;
                    }
                }
            }
        }
        this.log.warn("Returning null candidate for type: " + (Object)((Object)type) + " and protocol " + (Object)((Object)transportProtocol));
        return null;
    }

    private InetSocketAddress parseRelated(Scanner scanner) throws UnknownHostException {
        String raddr = scanner.next();
        if (!raddr.equals("raddr")) {
            this.log.error("Bad related address: " + raddr);
        }
        InetAddress relatedAddress = InetAddress.getByName(scanner.next());
        String rport = scanner.next();
        if (!rport.equals("rport")) {
            this.log.error("Bad related port: " + rport);
        }
        int relatedPort = Integer.parseInt(scanner.next());
        return new InetSocketAddress(relatedAddress, relatedPort);
    }
}

