/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.transport;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.id.uuid.UUID;
import org.lastbamboo.common.ice.IceStunChecker;
import org.littleshoot.mina.common.CloseFuture;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.CanceledStunMessage;
import org.littleshoot.stun.stack.message.NullStunMessage;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.transaction.StunTransactionListener;
import org.littleshoot.stun.stack.transaction.StunTransactionTracker;
import org.littleshoot.util.RuntimeIoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIceStunChecker
implements IceStunChecker,
StunTransactionListener {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    protected final IoSession m_ioSession;
    protected volatile int m_writeCallsForChecker = 0;
    protected final Map<UUID, StunMessage> m_idsToResponses = new ConcurrentHashMap<UUID, StunMessage>();
    protected final StunTransactionTracker<StunMessage> m_transactionTracker;
    protected final Object m_requestLock = new Object();
    protected volatile boolean m_transactionCanceled = false;
    protected volatile boolean m_closed = false;

    public AbstractIceStunChecker(IoSession ioSession, StunTransactionTracker<StunMessage> transactionTracker) {
        if (ioSession == null) {
            throw new NullPointerException("Null session!!");
        }
        this.m_transactionTracker = transactionTracker;
        this.m_ioSession = ioSession;
    }

    @Override
    public StunMessage write(BindingRequest bindingRequest, long rto) {
        this.m_log.debug("Writing Binding Request...");
        ++this.m_writeCallsForChecker;
        if (this.m_writeCallsForChecker > 1) {
            this.m_log.debug("Second call to checker!!");
            throw new RuntimeIoException("Too many calls to checker: " + this.m_writeCallsForChecker);
        }
        if (this.m_transactionCanceled || this.m_closed || this.m_ioSession.isClosing()) {
            this.m_log.debug("Already closed");
            return new CanceledStunMessage();
        }
        try {
            return this.writeInternal(bindingRequest, rto);
        }
        catch (Throwable t) {
            this.m_log.error("Could not write Binding Request", t);
            return new NullStunMessage();
        }
    }

    protected abstract StunMessage writeInternal(BindingRequest var1, long var2);

    protected final void waitIfNoResponse(BindingRequest request, long waitTime) {
        if (waitTime == 0L) {
            return;
        }
        if (!this.m_idsToResponses.containsKey(request.getTransactionId())) {
            try {
                this.m_requestLock.wait(waitTime);
            }
            catch (InterruptedException e) {
                this.m_log.error("Unexpected interrupt", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTransaction() {
        this.m_log.debug("Cancelling transaction!!");
        this.m_transactionCanceled = true;
        Object object = this.m_requestLock;
        synchronized (object) {
            this.m_requestLock.notifyAll();
        }
    }

    public Object onTransactionFailed(StunMessage request, StunMessage response) {
        this.m_log.warn("Transaction failed");
        return this.notifyWaiters(request, response);
    }

    public Object onTransactionSucceeded(StunMessage request, StunMessage response) {
        return this.notifyWaiters(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object notifyWaiters(StunMessage request, StunMessage response) {
        Object object = this.m_requestLock;
        synchronized (object) {
            this.m_idsToResponses.put(request.getTransactionId(), response);
            this.m_requestLock.notifyAll();
        }
        return null;
    }

    @Override
    public void close() {
        if (this.m_ioSession == null) {
            this.m_log.debug("Can't close null session");
            return;
        }
        CloseFuture future = this.m_ioSession.close();
        future.join();
        this.m_closed = true;
    }
}

