/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.arguments;

import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.helpers.Args;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;

public class OptionalNamedArg
implements NamedArgument {
    protected final String name;
    protected final String exampleValue;
    protected final String defaultValue;
    protected final String description;
    protected final String[] allowedValues;

    public OptionalNamedArg(String name, String exampleValue, String defaultValue, String description) {
        this.name = name;
        this.exampleValue = exampleValue;
        this.defaultValue = defaultValue;
        this.description = description;
        this.allowedValues = new String[0];
    }

    public OptionalNamedArg(String name, String[] allowedValues, String defaultValue, String description) {
        this.name = name;
        this.allowedValues = allowedValues;
        this.exampleValue = String.join((CharSequence)"|", allowedValues);
        this.defaultValue = defaultValue;
        this.description = description;
    }

    @Override
    public String optionsListing() {
        return String.format("--%s=<%s>", this.name, this.exampleValue);
    }

    @Override
    public String usage() {
        return String.format("[--%s=<%s>]", this.name, this.exampleValue);
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String exampleValue() {
        return this.exampleValue;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    @Override
    public String parse(String ... args) {
        String value = (String)Args.parse((String[])args).interpretOption(this.name, Converters.withDefault((Object)this.defaultValue), Converters.identity(), new Validator[0]);
        if (this.allowedValues.length > 0) {
            for (String allowedValue : this.allowedValues) {
                if (!allowedValue.equals(value)) continue;
                return value;
            }
            throw new IllegalArgumentException(String.format("'%s' must be one of [%s], not: %s", this.name, String.join((CharSequence)",", this.allowedValues), value));
        }
        return value;
    }
}

