/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.basicType;

import java.io.Serializable;
import java.util.function.Function;
import org.ofdrw.core.OFDSimpleTypeElement;

public abstract class STBase
implements Serializable {
    public OFDSimpleTypeElement getElement(String name) {
        return new OFDSimpleTypeElement(name, (Serializable)((Object)this.toString()));
    }

    public static String fmt(double d) {
        if (d == (double)((long)d)) {
            return String.format("%d", (long)d);
        }
        return String.format("%s", d);
    }

    public static Double toDouble(String str) {
        Double res = STBase.num(str, Double::parseDouble);
        return res == null ? 0.0 : res;
    }

    public static Integer toInt(String str) {
        Integer res = STBase.num(str, Integer::parseInt);
        return res == null ? 0 : res;
    }

    private static <R extends Number> R num(String str, Function<String, R> mapper) {
        Number res = null;
        try {
            res = (Number)mapper.apply(str);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            for (char c : str.toCharArray()) {
                if (c == '-' || c == '+' || c == '.') {
                    sb.append(c);
                    continue;
                }
                if ('0' > c || c > '9') continue;
                sb.append(c);
            }
            try {
                res = (Number)mapper.apply(sb.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (R)res;
    }
}

