/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.graphics2d;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import org.ofdrw.core.basicStructure.pageObj.Content;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.Type;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.graph.pathObj.AbbreviatedData;
import org.ofdrw.core.graph.pathObj.CT_Path;
import org.ofdrw.core.pageDescription.clips.Area;
import org.ofdrw.core.pageDescription.clips.CT_Clip;
import org.ofdrw.core.pageDescription.clips.ClipAble;
import org.ofdrw.core.pageDescription.clips.Clips;
import org.ofdrw.graphics2d.OFDGraphics2DDrawParam;
import org.ofdrw.graphics2d.OFDGraphicsDocument;
import org.ofdrw.graphics2d.OFDPageGraphicsConfiguration;
import org.ofdrw.graphics2d.OFDShapes;
import org.ofdrw.pkg.container.PageDir;

public class OFDPageGraphics2D
extends Graphics2D {
    private final OFDGraphicsDocument doc;
    private final PageDir pageDir;
    private final Page pageObj;
    private final CT_PageBlock container;
    private final OFDGraphics2DDrawParam drawParam;
    private final ST_Box size;
    public final ST_ID pageID;
    private OFDPageGraphicsConfiguration devConfig;
    private final Graphics2D fmg;

    OFDPageGraphics2D(OFDGraphicsDocument doc, ST_ID pageID, PageDir pageDir, Page pageObj, ST_Box box) {
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
        this.doc = doc;
        this.pageID = pageID;
        this.pageDir = pageDir;
        this.pageObj = pageObj;
        this.size = box;
        this.drawParam = new OFDGraphics2DDrawParam(doc, box);
        Content content = new Content();
        pageObj.setContent(content);
        CT_Layer ctlayer = new CT_Layer();
        ctlayer.setType(Type.Body);
        ctlayer.setObjID(doc.newID());
        content.addLayer(ctlayer);
        this.container = new CT_PageBlock();
        this.container.setObjID(doc.newID());
        ctlayer.addPageBlock((PageBlockType)this.container);
    }

    private OFDPageGraphics2D(OFDPageGraphics2D parent) {
        this.doc = parent.doc;
        this.pageID = parent.pageID;
        this.pageDir = parent.pageDir;
        this.pageObj = parent.pageObj;
        this.container = parent.container;
        this.size = parent.size.clone();
        this.drawParam = parent.drawParam.clone();
        this.devConfig = parent.devConfig;
        this.fmg = parent.fmg;
    }

    @Override
    public void draw(Shape s) {
        AbbreviatedData pData;
        if (s == null) {
            return;
        }
        if (!this.drawParam.ctm.isIdentity()) {
            s = this.drawParam.ctm.createTransformedShape(s);
        }
        if ((pData = OFDShapes.path(s)).size() == 0) {
            return;
        }
        CT_Path pathObj = new CT_Path();
        pathObj.setBoundary(this.size);
        pathObj.setStroke(Boolean.valueOf(true));
        pathObj.setAbbreviatedData(pData);
        if (this.drawParam.clip != null) {
            Clips clips = this.makeClip(s, new AffineTransform(this.drawParam.ctm));
            pathObj.setClips(clips);
        }
        ST_RefID dpId = this.drawParam.makeDrawParam();
        pathObj.setDrawParam(dpId);
        this.container.addPageBlock((PageBlockType)pathObj.toObj(this.doc.newID()));
    }

    @Override
    public void drawString(String str, int x, int y) {
        GlyphVector gv = this.getFont().createGlyphVector(this.getFontRenderContext(), str);
        this.drawGlyphVector(gv, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        GlyphVector gv = this.getFont().createGlyphVector(this.getFontRenderContext(), str);
        this.drawGlyphVector(gv, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
        layout.draw(this, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
        layout.draw(this, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Shape glyphOutline = g.getOutline(x, y);
        this.fill(glyphOutline);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int w = img.getWidth(observer);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(observer);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        int alpha;
        if (img == null) {
            return true;
        }
        AffineTransform before = this.getTransform();
        AffineTransform imgCTM = new AffineTransform(before);
        imgCTM.concatenate(new AffineTransform(width, 0.0f, 0.0f, height, x, y));
        ST_ID objId = this.doc.addResImg(img);
        ImageObject imgObj = new ImageObject(this.doc.newID());
        imgObj.setCTM(this.trans(imgCTM));
        imgObj.setResourceID(objId.ref());
        imgObj.setBoundary(this.size);
        if (this.drawParam.gColor instanceof Color && (alpha = ((Color)this.drawParam.gColor).getAlpha()) != 255) {
            imgObj.setAlpha(Integer.valueOf(alpha));
        }
        ST_RefID dpId = this.drawParam.makeDrawParam();
        imgObj.setDrawParam(dpId);
        if (this.drawParam.clip != null) {
            Shape imgShape = imgCTM.createTransformedShape(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0));
            Clips clips = this.makeClip(imgShape, imgCTM);
            imgObj.setClips(clips);
        }
        this.container.addPageBlock((PageBlockType)imgObj);
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int w = img.getWidth(null);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(null);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(x, y, width, height);
        this.setPaint(saved);
        return this.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        int w = dx2 - dx1;
        int h = dy2 - dy1;
        BufferedImage img2 = new BufferedImage(w, h, 2);
        Graphics2D g2 = img2.createGraphics();
        g2.drawImage(img, 0, 0, w, h, sx1, sy1, sx2, sy2, null);
        return this.drawImage((Image)img2, dx1, dy1, null);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
        this.setPaint(saved);
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform old = this.getTransform();
        if (xform != null) {
            this.transform(xform);
        }
        boolean res = this.drawImage(img, 0, 0, obs);
        if (xform != null) {
            this.setTransform(old);
        }
        return res;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage img1 = img;
        if (op != null) {
            img1 = op.filter(img, null);
        }
        this.drawImage(img1, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        if (img == null) {
            return;
        }
        BufferedImage bufferedImage = this.convert2Img(img);
        this.drawImage(bufferedImage, xform, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        if (img == null) {
            return;
        }
        RenderedImage rImg = img.createDefaultRendering();
        this.drawRenderedImage(rImg, xform);
    }

    @Override
    public void fill(Shape s) {
        AbbreviatedData pData;
        if (s == null) {
            return;
        }
        if (!this.drawParam.ctm.isIdentity()) {
            s = this.drawParam.ctm.createTransformedShape(s);
        }
        if ((pData = OFDShapes.path(s)).size() == 0) {
            return;
        }
        CT_Path pathObj = new CT_Path();
        pathObj.setBoundary(this.size);
        pathObj.setFill(Boolean.valueOf(true));
        pathObj.setStroke(Boolean.valueOf(false));
        pathObj.setAbbreviatedData(pData);
        if (this.drawParam.clip != null) {
            Clips clips = this.makeClip(s, new AffineTransform(this.drawParam.ctm));
            pathObj.setClips(clips);
        }
        ST_RefID dpId = this.drawParam.makeDrawParam();
        pathObj.setDrawParam(dpId);
        this.container.addPageBlock((PageBlockType)pathObj.toObj(this.doc.newID()));
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            s = this.drawParam.gStroke.createStrokedShape(s);
        }
        s = this.drawParam.ctm.createTransformedShape(s);
        return s.intersects(rect);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        if (this.devConfig == null) {
            this.devConfig = new OFDPageGraphicsConfiguration(this.size.getWidth(), this.size.getHeight());
        }
        return this.devConfig;
    }

    @Override
    public void setComposite(Composite comp) {
        this.drawParam.composite = comp;
    }

    @Override
    public void setPaint(Paint paint) {
        this.drawParam.setColor(paint);
    }

    @Override
    public void setStroke(Stroke s) {
        this.drawParam.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.drawParam.fontRenderCtx = null;
        this.drawParam.hints.put(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.drawParam.hints.get(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.drawParam.fontRenderCtx = null;
        this.drawParam.hints.clear();
        this.drawParam.hints.putAll(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.drawParam.fontRenderCtx = null;
        this.drawParam.hints.putAll(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.drawParam.hints.clone();
    }

    @Override
    public Graphics create() {
        return new OFDPageGraphics2D(this);
    }

    @Override
    public Color getColor() {
        return this.drawParam.gForeground;
    }

    @Override
    public void setColor(Color c) {
        if (c == null) {
            return;
        }
        this.drawParam.setForeground(c);
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public Font getFont() {
        return this.drawParam.font;
    }

    @Override
    public void setFont(Font font) {
        this.drawParam.font = font;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.fmg.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        Shape c = this.getClip();
        if (c == null) {
            return null;
        }
        return c.getBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public Shape getClip() {
        return this.drawParam.clip;
    }

    @Override
    public void clip(Shape s) {
        if (s == null) {
            this.drawParam.clip = null;
            return;
        }
        if (!this.drawParam.ctm.isIdentity()) {
            s = this.drawParam.ctm.createTransformedShape(s);
        }
        if (this.drawParam.clip == null) {
            this.drawParam.clip = new java.awt.geom.Area(s);
        } else {
            this.drawParam.clip.intersect(new java.awt.geom.Area(s));
        }
    }

    @Override
    public void setClip(Shape s) {
        if (s == null) {
            this.drawParam.clip = null;
            return;
        }
        if (!this.drawParam.ctm.isIdentity()) {
            s = this.drawParam.ctm.createTransformedShape(s);
        }
        this.drawParam.clip = new java.awt.geom.Area(s);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        this.draw(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.drawParam.gBackground == null) {
            return;
        }
        Paint saved = this.getPaint();
        this.setPaint(this.drawParam.gBackground);
        this.fillRect(x, y, width, height);
        this.setPaint(saved);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2));
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = new GeneralPath();
        p.moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            p.lineTo(xPoints[i], yPoints[i]);
        }
        this.draw(p);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = new GeneralPath();
        p.moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            p.lineTo(xPoints[i], yPoints[i]);
        }
        p.closePath();
        this.draw(p);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = new GeneralPath();
        p.moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            p.lineTo(xPoints[i], yPoints[i]);
        }
        p.closePath();
        this.fill(p);
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
        this.drawParam.ref = null;
    }

    @Override
    public void translate(double tx, double ty) {
        this.drawParam.ctm.translate(tx, ty);
        this.drawParam.ref = null;
    }

    @Override
    public void rotate(double theta) {
        this.drawParam.ctm.rotate(theta);
        this.drawParam.ref = null;
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
        this.drawParam.ref = null;
    }

    @Override
    public void scale(double sx, double sy) {
        this.drawParam.ctm.scale(sx, sy);
        this.drawParam.ref = null;
    }

    @Override
    public void shear(double shx, double shy) {
        this.drawParam.ctm.shear(shx, shy);
        this.drawParam.ref = null;
    }

    @Override
    public void transform(AffineTransform tx) {
        if (tx == null) {
            return;
        }
        this.drawParam.ctm.concatenate(tx);
        this.drawParam.ref = null;
    }

    @Override
    public void setTransform(AffineTransform tx) {
        if (tx == null) {
            tx = new AffineTransform();
        }
        this.drawParam.ctm = new AffineTransform(tx);
        this.drawParam.ref = null;
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.drawParam.ctm);
    }

    @Override
    public Paint getPaint() {
        return this.drawParam.gColor;
    }

    @Override
    public Composite getComposite() {
        return this.drawParam.composite;
    }

    @Override
    public void setBackground(Color color) {
        this.drawParam.gBackground = color;
    }

    @Override
    public Color getBackground() {
        return this.drawParam.gBackground;
    }

    @Override
    public Stroke getStroke() {
        return this.drawParam.gStroke;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.drawParam.getFontRenderContext();
    }

    @Override
    public void dispose() {
    }

    private Clips makeClip(Shape s, AffineTransform objCTM) {
        Rectangle2D bounds = s.getBounds2D();
        double w = bounds.getWidth() - 1.0E-6;
        double h = bounds.getHeight() - 1.0E-6;
        if (!this.drawParam.clip.contains(bounds = new Rectangle2D.Double(bounds.getX() + 1.0E-6, bounds.getY() + 1.0E-6, w < 0.0 ? 0.0 : w, h < 0.0 ? 0.0 : h))) {
            Clips clips = new Clips();
            Area area = new Area();
            CT_Path clipObj = new CT_Path().setAbbreviatedData(OFDShapes.path(new GeneralPath(this.drawParam.clip)));
            clipObj.setFill(Boolean.valueOf(true));
            clipObj.setBoundary(this.size);
            try {
                AffineTransform inverse = objCTM.createInverse();
                clipObj.setCTM(this.trans(inverse));
                area.setClipObj((ClipAble)clipObj);
                clips.addClip(new CT_Clip().addArea(area));
                return clips;
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return null;
    }

    private BufferedImage convert2Img(RenderedImage img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        ColorModel cm = img.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = img.getPropertyNames();
        if (keys != null) {
            for (String key : keys) {
                properties.put(key, img.getProperty(key));
            }
        }
        BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
        img.copyData(raster);
        return result;
    }

    public ST_Array trans(AffineTransform tx) {
        return new ST_Array(tx.getScaleX(), tx.getShearY(), tx.getShearX(), tx.getScaleY(), tx.getTranslateX(), tx.getTranslateY());
    }
}

