/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign.signContainer;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.jcajce.provider.digest.SM3;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.ofdrw.core.signatures.SigType;
import org.ofdrw.sign.ExtendSignatureContainer;

public class DigitalSignContainer
implements ExtendSignatureContainer {
    private final PrivateKey prvKey;

    public DigitalSignContainer(PrivateKey prvKey) {
        if (prvKey == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u4f7f\u7528\u79c1\u94a5\uff08prvKey\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.prvKey = prvKey;
    }

    @Override
    public MessageDigest getDigestFnc() {
        return new SM3.Digest();
    }

    @Override
    public ASN1ObjectIdentifier getSignAlgOID() {
        return GMObjectIdentifiers.sm2sign_with_sm3;
    }

    @Override
    public byte[] sign(InputStream inData, String propertyInfo) throws GeneralSecurityException, IOException {
        Signature signatureFnc = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)new BouncyCastleProvider());
        signatureFnc.initSign(this.prvKey);
        signatureFnc.update(IOUtils.toByteArray((InputStream)inData));
        return signatureFnc.sign();
    }

    @Override
    public byte[] getSeal() throws IOException {
        return null;
    }

    @Override
    public SigType getSignType() {
        return SigType.Sign;
    }
}

