/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import java.util.ArrayList;
import java.util.List;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Clients
extends InitializableObject {
    private static final Logger logger = LoggerFactory.getLogger(Clients.class);
    public static final String DEFAULT_CLIENT_NAME_PARAMETER = "client_name";
    private String clientNameParameter = "client_name";
    private List<Client> clients;
    private String callbackUrl;

    public Clients() {
    }

    public Clients(String callbackUrl, List<Client> clients) {
        this.setCallbackUrl(callbackUrl);
        this.setClientsList(clients);
    }

    public Clients(String callbackUrl, Client ... clients) {
        this.setCallbackUrl(callbackUrl);
        this.setClients(clients);
    }

    @Override
    protected void internalInit() {
        CommonHelper.assertNotBlank("callbackUrl", this.callbackUrl);
        CommonHelper.assertNotNull("clients", this.clients);
        for (Client client : this.clients) {
            BaseClient baseClient = (BaseClient)client;
            String baseClientCallbackUrl = baseClient.getCallbackUrl();
            if (baseClientCallbackUrl == null) {
                baseClient.setCallbackUrl(CommonHelper.addParameter(this.callbackUrl, this.clientNameParameter, baseClient.getName()));
                continue;
            }
            if (baseClientCallbackUrl.indexOf(this.clientNameParameter + "=") >= 0) continue;
            baseClient.setCallbackUrl(CommonHelper.addParameter(baseClientCallbackUrl, this.clientNameParameter, baseClient.getName()));
        }
    }

    public Client findClient(WebContext context) {
        String name = context.getRequestParameter(this.clientNameParameter);
        CommonHelper.assertNotBlank("name", name);
        return this.findClient(name);
    }

    public Client findClient(String name) {
        this.init();
        for (Client client : this.clients) {
            if (!CommonHelper.areEquals(name, client.getName())) continue;
            return client;
        }
        String message = "No client found for name: " + name;
        logger.error(message);
        throw new TechnicalException(message);
    }

    public <C extends Client> C findClient(Class<C> clazz) {
        this.init();
        if (clazz != null) {
            for (Client client : this.clients) {
                if (!clazz.isAssignableFrom(client.getClass())) continue;
                return (C)client;
            }
        }
        String message = "No client found for class: " + clazz;
        logger.error(message);
        throw new TechnicalException(message);
    }

    public List<Client> findAllClients() {
        this.init();
        return this.clients;
    }

    public String getClientNameParameter() {
        return this.clientNameParameter;
    }

    public void setClientNameParameter(String clientNameParameter) {
        this.clientNameParameter = clientNameParameter;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public void setClientsList(List<Client> clients) {
        this.clients = clients;
    }

    public void setClients(Client ... clients) {
        this.clients = new ArrayList<Client>();
        for (Client client : clients) {
            this.clients.add(client);
        }
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "callbackUrl", this.callbackUrl, "clientTypeParameter", this.clientNameParameter, "clients", this.clients);
    }
}

