/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.kryo;

import com.esotericsoftware.kryo.serialize.LongSerializer;
import com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.esotericsoftware.kryo.serialize.StringSerializer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Locale;
import org.pac4j.core.kryo.LocaleSerializer;
import org.pac4j.core.profile.FormattedDate;

public class FormattedDateSerializer
extends SimpleSerializer<FormattedDate> {
    private final LongSerializer longSerializer = new LongSerializer();
    private final StringSerializer stringSerializer = new StringSerializer();
    private final LocaleSerializer localeSerializer = new LocaleSerializer();

    public FormattedDate read(ByteBuffer buffer) {
        Long time = (Long)this.longSerializer.readObject(buffer, Long.class);
        String format = (String)this.stringSerializer.readObject(buffer, String.class);
        Locale locale = (Locale)this.localeSerializer.readObject(buffer, Locale.class);
        return new FormattedDate(new Date(time), format, locale);
    }

    public void write(ByteBuffer buffer, FormattedDate object) {
        this.longSerializer.writeObject(buffer, (Object)object.getTime());
        this.stringSerializer.writeObject(buffer, (Object)object.getFormat());
        this.localeSerializer.writeObject(buffer, object.getLocale());
    }
}

