/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import java.util.List;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.HttpActionAdapter;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.ProfileManagerFactoryAware;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCallbackLogic<R, C extends WebContext>
extends ProfileManagerFactoryAware<C>
implements CallbackLogic<R, C> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public R perform(C context, Config config, HttpActionAdapter<R, C> httpActionAdapter, String inputDefaultUrl, Boolean inputMultiProfile, Boolean inputRenewSession) {
        HttpAction action;
        this.logger.debug("=== CALLBACK ===");
        String defaultUrl = inputDefaultUrl == null ? "/" : inputDefaultUrl;
        boolean multiProfile = inputMultiProfile == null ? false : inputMultiProfile;
        boolean renewSession = inputRenewSession == null ? true : inputRenewSession;
        CommonHelper.assertNotNull("context", context);
        CommonHelper.assertNotNull("config", config);
        CommonHelper.assertNotNull("httpActionAdapter", httpActionAdapter);
        CommonHelper.assertNotBlank("defaultUrl", defaultUrl);
        Clients clients = config.getClients();
        CommonHelper.assertNotNull("clients", clients);
        Client client = clients.findClient((WebContext)context);
        this.logger.debug("client: {}", (Object)client);
        CommonHelper.assertNotNull("client", client);
        CommonHelper.assertTrue(client instanceof IndirectClient, "only indirect clients are allowed on the callback url");
        try {
            Object credentials = client.getCredentials((WebContext)context);
            this.logger.debug("credentials: {}", credentials);
            Object profile = client.getUserProfile(credentials, (WebContext)context);
            this.logger.debug("profile: {}", profile);
            this.saveUserProfile(context, config, (CommonProfile)profile, multiProfile, renewSession);
            action = this.redirectToOriginallyRequestedUrl(context, defaultUrl);
        }
        catch (HttpAction e) {
            this.logger.debug("extra HTTP action required in callback: {}", (Object)e.getCode());
            action = e;
        }
        return httpActionAdapter.adapt(action.getCode(), context);
    }

    protected void saveUserProfile(C context, Config config, CommonProfile profile, boolean multiProfile, boolean renewSession) {
        ProfileManager manager = this.getProfileManager(context, config);
        if (profile != null) {
            manager.save(true, profile, multiProfile);
            if (renewSession) {
                this.renewSession(context, config);
            }
        }
    }

    protected void renewSession(C context, Config config) {
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore != null) {
            String oldSessionId = sessionStore.getOrCreateSessionId(context);
            boolean renewed = sessionStore.renewSession(context);
            if (renewed) {
                String newSessionId = sessionStore.getOrCreateSessionId(context);
                this.logger.debug("Renewing session: {} -> {}", (Object)oldSessionId, (Object)newSessionId);
                Clients clients = config.getClients();
                if (clients != null) {
                    List<Client> clientList = clients.getClients();
                    for (Client client : clientList) {
                        BaseClient baseClient = (BaseClient)client;
                        baseClient.notifySessionRenewal(oldSessionId, (WebContext)context);
                    }
                }
            } else {
                this.logger.error("Unable to renew the session. The session store may not support this feature");
            }
        } else {
            this.logger.error("No session store available for this web context");
        }
    }

    protected HttpAction redirectToOriginallyRequestedUrl(C context, String defaultUrl) {
        String requestedUrl = (String)context.getSessionAttribute("pac4jRequestedUrl");
        String redirectUrl = defaultUrl;
        if (CommonHelper.isNotBlank(requestedUrl)) {
            context.setSessionAttribute("pac4jRequestedUrl", null);
            redirectUrl = requestedUrl;
        }
        this.logger.debug("redirectUrl: {}", (Object)redirectUrl);
        return HttpAction.redirect("redirect", context, redirectUrl);
    }
}

