/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pgvector;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGobject;

public class PGsparsevec
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    private int dimensions;
    private int[] indices;
    private float[] values;

    public PGsparsevec() {
        this.type = "sparsevec";
    }

    public PGsparsevec(float[] v) {
        this();
        int nnz = 0;
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == 0.0f) continue;
            ++nnz;
        }
        this.dimensions = v.length;
        this.indices = new int[nnz];
        this.values = new float[nnz];
        int j = 0;
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == 0.0f) continue;
            this.indices[j] = i;
            this.values[j] = v[i];
            ++j;
        }
    }

    public <T extends Number> PGsparsevec(List<T> v) {
        this();
        if (v == null) {
            this.indices = null;
        } else {
            int nnz = 0;
            for (Number f : v) {
                if (f.floatValue() == 0.0f) continue;
                ++nnz;
            }
            this.dimensions = v.size();
            this.indices = new int[nnz];
            this.values = new float[nnz];
            int i = 0;
            int j = 0;
            for (Number f : v) {
                float fv = f.floatValue();
                if (fv != 0.0f) {
                    this.indices[j] = i;
                    this.values[j] = fv;
                    ++j;
                }
                ++i;
            }
        }
    }

    public <T extends Number> PGsparsevec(Map<Integer, T> map, int dimensions) {
        this();
        ArrayList<Map.Entry<Integer, T>> elements = new ArrayList<Map.Entry<Integer, T>>();
        if (map != null) {
            elements.addAll(map.entrySet());
        }
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (((Number)entry.getValue()).floatValue() != 0.0f) continue;
            it.remove();
        }
        Collections.sort(elements, new Comparator<Map.Entry<Integer, T>>(){

            @Override
            public int compare(Map.Entry<Integer, T> a, Map.Entry<Integer, T> b) {
                return a.getKey().compareTo(b.getKey());
            }
        });
        int nnz = elements.size();
        this.indices = new int[nnz];
        this.values = new float[nnz];
        int i = 0;
        for (Map.Entry entry : elements) {
            this.indices[i] = (Integer)entry.getKey();
            this.values[i] = ((Number)entry.getValue()).floatValue();
            ++i;
        }
        this.dimensions = dimensions;
    }

    public PGsparsevec(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s == null) {
            this.indices = null;
        } else {
            String[] sp = s.split("/", 2);
            String[] elements = sp[0].substring(1, sp[0].length() - 1).split(",");
            this.dimensions = Integer.parseInt(sp[1]);
            this.indices = new int[elements.length];
            this.values = new float[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                String[] ep = elements[i].split(":", 2);
                this.indices[i] = Integer.parseInt(ep[0]) - 1;
                this.values[i] = Float.parseFloat(ep[1]);
            }
        }
    }

    @Override
    public String getValue() {
        if (this.indices == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(13 + 27 * this.indices.length);
        sb.append('{');
        for (int i = 0; i < this.indices.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.indices[i] + 1);
            sb.append(':');
            sb.append(this.values[i]);
        }
        sb.append('}');
        sb.append('/');
        sb.append(this.dimensions);
        return sb.toString();
    }

    @Override
    public int lengthInBytes() {
        return this.indices == null ? 0 : 12 + this.indices.length * 4 + this.values.length * 4;
    }

    @Override
    public void setByteValue(byte[] value, int offset) throws SQLException {
        int i;
        this.dimensions = ByteConverter.int4(value, offset);
        int nnz = ByteConverter.int4(value, offset + 4);
        int unused = ByteConverter.int4(value, offset + 8);
        if (unused != 0) {
            throw new SQLException("expected unused to be 0");
        }
        this.indices = new int[nnz];
        for (i = 0; i < nnz; ++i) {
            this.indices[i] = ByteConverter.int4(value, offset + 12 + i * 4);
        }
        this.values = new float[nnz];
        for (i = 0; i < nnz; ++i) {
            this.values[i] = ByteConverter.float4(value, offset + 12 + nnz * 4 + i * 4);
        }
    }

    @Override
    public void toBytes(byte[] bytes, int offset) {
        int i;
        if (this.indices == null) {
            return;
        }
        ByteConverter.int4(bytes, offset, this.dimensions);
        ByteConverter.int4(bytes, offset + 4, this.indices.length);
        ByteConverter.int4(bytes, offset + 8, 0);
        for (i = 0; i < this.indices.length; ++i) {
            ByteConverter.int4(bytes, offset + 12 + i * 4, this.indices[i]);
        }
        for (i = 0; i < this.values.length; ++i) {
            ByteConverter.float4(bytes, offset + 12 + this.indices.length * 4 + i * 4, this.values[i]);
        }
    }

    public float[] toArray() {
        if (this.indices == null) {
            return null;
        }
        float[] vec = new float[this.dimensions];
        for (int i = 0; i < this.indices.length; ++i) {
            vec[this.indices[i]] = this.values[i];
        }
        return vec;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public float[] getValues() {
        return this.values;
    }
}

