/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.filesystem.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v137.filesystem.model.File;
import org.openqa.selenium.json.JsonInput;

public class Directory {
    private final String name;
    private final List<String> nestedDirectories;
    private final List<File> nestedFiles;

    public Directory(String name, List<String> nestedDirectories, List<File> nestedFiles) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.nestedDirectories = Objects.requireNonNull(nestedDirectories, "nestedDirectories is required");
        this.nestedFiles = Objects.requireNonNull(nestedFiles, "nestedFiles is required");
    }

    public String getName() {
        return this.name;
    }

    public List<String> getNestedDirectories() {
        return this.nestedDirectories;
    }

    public List<File> getNestedFiles() {
        return this.nestedFiles;
    }

    private static Directory fromJson(JsonInput input) {
        String name = null;
        List nestedDirectories = null;
        List nestedFiles = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block10;
                }
                case "nestedDirectories": {
                    nestedDirectories = input.readArray(String.class);
                    continue block10;
                }
                case "nestedFiles": {
                    nestedFiles = input.readArray(File.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Directory(name, nestedDirectories, nestedFiles);
    }
}

