/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.transport.WebFluxSseServerTransport;
import io.modelcontextprotocol.spec.ServerMcpTransport;
import org.springframework.ai.autoconfigure.mcp.server.McpServerProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.web.reactive.function.server.RouterFunction;

@AutoConfiguration
@ConditionalOnClass(value={WebFluxSseServerTransport.class})
@ConditionalOnMissingBean(value={ServerMcpTransport.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"stdio"}, havingValue="false", matchIfMissing=true)
public class MpcWebFluxServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WebFluxSseServerTransport webFluxTransport(McpServerProperties serverProperties) {
        return new WebFluxSseServerTransport(new ObjectMapper(), serverProperties.getSseMessageEndpoint());
    }

    @Bean
    public RouterFunction<?> webfluxMcpRouterFunction(WebFluxSseServerTransport webFluxTransport) {
        return webFluxTransport.getRouterFunction();
    }
}

