/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.springframework.ai.mcp.AsyncMcpToolCallback;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.util.ToolUtils;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class AsyncMcpToolCallbackProvider
implements ToolCallbackProvider {
    private final List<McpAsyncClient> mcpClients;
    private final BiPredicate<McpAsyncClient, McpSchema.Tool> toolFilter;

    public AsyncMcpToolCallbackProvider(BiPredicate<McpAsyncClient, McpSchema.Tool> toolFilter, List<McpAsyncClient> mcpClients) {
        Assert.notNull(mcpClients, (String)"MCP clients must not be null");
        Assert.notNull(toolFilter, (String)"Tool filter must not be null");
        this.mcpClients = mcpClients;
        this.toolFilter = toolFilter;
    }

    public AsyncMcpToolCallbackProvider(List<McpAsyncClient> mcpClients) {
        this((McpAsyncClient mcpClient, McpSchema.Tool tool) -> true, mcpClients);
    }

    public AsyncMcpToolCallbackProvider(BiPredicate<McpAsyncClient, McpSchema.Tool> toolFilter, McpAsyncClient ... mcpClients) {
        this(toolFilter, List.of(mcpClients));
    }

    public AsyncMcpToolCallbackProvider(McpAsyncClient ... mcpClients) {
        this(List.of(mcpClients));
    }

    public ToolCallback[] getToolCallbacks() {
        ArrayList<ToolCallback> toolCallbackList = new ArrayList<ToolCallback>();
        for (McpAsyncClient mcpClient : this.mcpClients) {
            ToolCallback[] toolCallbacks = (ToolCallback[])mcpClient.listTools().map(response -> (ToolCallback[])response.tools().stream().filter(tool -> this.toolFilter.test(mcpClient, (McpSchema.Tool)tool)).map(tool -> new AsyncMcpToolCallback(mcpClient, (McpSchema.Tool)tool)).toArray(ToolCallback[]::new)).block();
            this.validateToolCallbacks(toolCallbacks);
            toolCallbackList.addAll(List.of(toolCallbacks));
        }
        return toolCallbackList.toArray(new ToolCallback[0]);
    }

    private void validateToolCallbacks(ToolCallback[] toolCallbacks) {
        List duplicateToolNames = ToolUtils.getDuplicateToolNames((FunctionCallback[])toolCallbacks);
        if (!duplicateToolNames.isEmpty()) {
            throw new IllegalStateException("Multiple tools with the same name (%s)".formatted(String.join((CharSequence)", ", duplicateToolNames)));
        }
    }

    public static Flux<ToolCallback> asyncToolCallbacks(List<McpAsyncClient> mcpClients) {
        if (CollectionUtils.isEmpty(mcpClients)) {
            return Flux.empty();
        }
        return Flux.fromArray((Object[])new AsyncMcpToolCallbackProvider(mcpClients).getToolCallbacks());
    }
}

