/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;

public abstract class AbstractEndpointMvcAdapter<E extends Endpoint<?>>
implements MvcEndpoint {
    private final E delegate;
    private String path;

    public AbstractEndpointMvcAdapter(E delegate) {
        Assert.notNull(delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
    }

    protected Object invoke() {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        return this.delegate.invoke();
    }

    public E getDelegate() {
        return this.delegate;
    }

    @Override
    public String getPath() {
        return this.path != null ? this.path : "/" + this.delegate.getId();
    }

    public void setPath(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
    }

    @Override
    public boolean isSensitive() {
        return this.delegate.isSensitive();
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return this.delegate.getClass();
    }

    protected ResponseEntity<?> getDisabledResponse() {
        return MvcEndpoint.DISABLED_RESPONSE;
    }
}

