/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.rsocket;

import io.rsocket.RSocketFactory;
import io.rsocket.transport.netty.server.TcpServerTransport;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.rsocket.RSocketStrategiesAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.rsocket.MessageHandlerAcceptor;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.ClassUtils;
import org.springframework.util.RouteMatcher;
import org.springframework.web.util.pattern.PathPatternParser;
import org.springframework.web.util.pattern.PathPatternRouteMatcher;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RSocketRequester.class, RSocketFactory.class, TcpServerTransport.class})
@AutoConfigureAfter(value={RSocketStrategiesAutoConfiguration.class})
public class RSocketMessagingAutoConfiguration {
    private static final String PATHPATTERN_ROUTEMATCHER_CLASS = "org.springframework.web.util.pattern.PathPatternRouteMatcher";

    @Bean
    @ConditionalOnMissingBean
    public MessageHandlerAcceptor messageHandlerAcceptor(RSocketStrategies rSocketStrategies) {
        MessageHandlerAcceptor acceptor = new MessageHandlerAcceptor();
        acceptor.setRSocketStrategies(rSocketStrategies);
        if (ClassUtils.isPresent((String)PATHPATTERN_ROUTEMATCHER_CLASS, null)) {
            PathPatternParser parser = new PathPatternParser();
            parser.setSeparator('.');
            acceptor.setRouteMatcher((RouteMatcher)new PathPatternRouteMatcher(parser));
        }
        return acceptor;
    }
}

