/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.rsocket;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.rsocket.RSocketFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.rsocket.messaging.RSocketStrategiesCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.CharSequenceEncoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.codec.cbor.Jackson2CborDecoder;
import org.springframework.http.codec.cbor.Jackson2CborEncoder;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.MimeType;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RSocketFactory.class, RSocketStrategies.class, PooledByteBufAllocator.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class RSocketStrategiesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RSocketStrategies rSocketStrategies(ObjectProvider<RSocketStrategiesCustomizer> customizers) {
        RSocketStrategies.Builder builder = RSocketStrategies.builder();
        builder.reactiveAdapterStrategy(ReactiveAdapterRegistry.getSharedInstance());
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        builder.decoder(new Decoder[]{StringDecoder.textPlainOnly()});
        builder.encoder(new Encoder[]{CharSequenceEncoder.allMimeTypes()});
        builder.dataBufferFactory((DataBufferFactory)new NettyDataBufferFactory((ByteBufAllocator)PooledByteBufAllocator.DEFAULT));
        return builder.build();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    protected static class JacksonJsonStrategyConfiguration {
        private static final MediaType[] SUPPORTED_TYPES = new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")};

        protected JacksonJsonStrategyConfiguration() {
        }

        @Bean
        @Order(value=1)
        @ConditionalOnBean(value={ObjectMapper.class})
        public RSocketStrategiesCustomizer jacksonJsonRSocketStrategyCustomizer(ObjectMapper objectMapper) {
            return strategy -> {
                strategy.decoder(new Decoder[]{new Jackson2JsonDecoder(objectMapper, (MimeType[])SUPPORTED_TYPES)});
                strategy.encoder(new Encoder[]{new Jackson2JsonEncoder(objectMapper, (MimeType[])SUPPORTED_TYPES)});
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class, CBORFactory.class})
    protected static class JacksonCborStrategyConfiguration {
        private static final MediaType[] SUPPORTED_TYPES = new MediaType[]{MediaType.APPLICATION_CBOR};

        protected JacksonCborStrategyConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnBean(value={Jackson2ObjectMapperBuilder.class})
        public RSocketStrategiesCustomizer jacksonCborRSocketStrategyCustomizer(Jackson2ObjectMapperBuilder builder) {
            return strategy -> {
                ObjectMapper objectMapper = builder.factory((JsonFactory)new CBORFactory()).build();
                strategy.decoder(new Decoder[]{new Jackson2CborDecoder(objectMapper, (MimeType[])SUPPORTED_TYPES)});
                strategy.encoder(new Encoder[]{new Jackson2CborEncoder(objectMapper, (MimeType[])SUPPORTED_TYPES)});
            };
        }
    }
}

