/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.springframework.boot.loader.tools.FileUtils;
import org.springframework.boot.maven.AbstractRunMojo;

public abstract class AbstractApplicationRunMojo
extends AbstractRunMojo {
    @Parameter(property="spring-boot.run.addResources", defaultValue="false")
    private boolean addResources = false;
    @Parameter(property="spring-boot.run.agents")
    private File[] agents;
    @Parameter(property="spring-boot.run.noverify")
    private boolean noverify = false;
    @Parameter(property="spring-boot.run.useTestClasspath", defaultValue="false")
    private Boolean useTestClasspath;

    @Override
    protected void run(File workingDirectory, String startClassName, Map<String, String> environmentVariables) throws MojoExecutionException, MojoFailureException {
        ArrayList<String> args = new ArrayList<String>();
        this.addAgents(args);
        this.addJvmArgs(args);
        this.addClasspath(args);
        args.add(startClassName);
        this.addArgs(args);
        this.run(workingDirectory, args, environmentVariables);
    }

    protected abstract void run(File var1, List<String> var2, Map<String, String> var3) throws MojoExecutionException, MojoFailureException;

    @Override
    protected URL[] getClassPathUrls() throws MojoExecutionException {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            this.addUserDefinedDirectories(urls);
            this.addResources(urls);
            this.addProjectClasses(urls);
            FilterArtifacts filters = this.useTestClasspath != false ? this.getFilters(new ArtifactsFilter[0]) : this.getFilters(new ArtifactsFilter[]{new AbstractRunMojo.TestArtifactFilter()});
            this.addDependencies(urls, filters);
            return urls.toArray(new URL[0]);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to build classpath", (Exception)ex);
        }
    }

    private void addAgents(List<String> args) {
        if (this.agents != null) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Attaching agents: " + Arrays.asList(this.agents)));
            }
            for (File agent : this.agents) {
                args.add("-javaagent:" + agent);
            }
        }
        if (this.noverify) {
            args.add("-noverify");
        }
    }

    private void addResources(List<URL> urls) throws IOException {
        if (this.addResources) {
            for (Resource resource : this.project.getResources()) {
                File directory = new File(resource.getDirectory());
                urls.add(directory.toURI().toURL());
                FileUtils.removeDuplicatesFromOutputDirectory((File)this.classesDirectory, (File)directory);
            }
        }
    }
}

