/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JCircuitBreaker;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4jBulkheadProvider;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.util.Assert;

public class Resilience4JCircuitBreakerFactory
extends CircuitBreakerFactory<Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration, Resilience4JConfigBuilder> {
    private Resilience4jBulkheadProvider bulkheadProvider;
    private Function<String, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration> defaultConfiguration;
    private CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.ofDefaults();
    private TimeLimiterRegistry timeLimiterRegistry = TimeLimiterRegistry.ofDefaults();
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private ConcurrentHashMap<String, ExecutorService> executorServices = new ConcurrentHashMap();
    private Map<String, Customizer<CircuitBreaker>> circuitBreakerCustomizers = new HashMap<String, Customizer<CircuitBreaker>>();

    @Deprecated
    public Resilience4JCircuitBreakerFactory() {
        this.defaultConfiguration = id -> new Resilience4JConfigBuilder((String)id).circuitBreakerConfig((CircuitBreakerConfig)this.circuitBreakerRegistry.getDefaultConfig()).timeLimiterConfig((TimeLimiterConfig)this.timeLimiterRegistry.getDefaultConfig()).build();
    }

    public Resilience4JCircuitBreakerFactory(CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, Resilience4jBulkheadProvider bulkheadProvider) {
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.timeLimiterRegistry = timeLimiterRegistry;
        this.bulkheadProvider = bulkheadProvider;
        this.defaultConfiguration = id -> new Resilience4JConfigBuilder((String)id).circuitBreakerConfig((CircuitBreakerConfig)this.circuitBreakerRegistry.getDefaultConfig()).timeLimiterConfig((TimeLimiterConfig)this.timeLimiterRegistry.getDefaultConfig()).build();
    }

    protected Resilience4JConfigBuilder configBuilder(String id) {
        return new Resilience4JConfigBuilder(id);
    }

    public void configureDefault(Function<String, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void configureCircuitBreakerRegistry(CircuitBreakerRegistry registry) {
        this.circuitBreakerRegistry = registry;
    }

    public CircuitBreakerRegistry getCircuitBreakerRegistry() {
        return this.circuitBreakerRegistry;
    }

    public TimeLimiterRegistry getTimeLimiterRegistry() {
        return this.timeLimiterRegistry;
    }

    public Resilience4jBulkheadProvider getBulkheadProvider() {
        return this.bulkheadProvider;
    }

    public void configureExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Resilience4JCircuitBreaker create(String id) {
        Assert.hasText((String)id, (String)"A CircuitBreaker must have an id.");
        return this.create(id, id, this.executorService);
    }

    public Resilience4JCircuitBreaker create(String id, String groupName) {
        Assert.hasText((String)id, (String)"A CircuitBreaker must have an id.");
        Assert.hasText((String)groupName, (String)"A CircuitBreaker must have a group name.");
        ExecutorService groupExecutorService = this.executorServices.computeIfAbsent(groupName, group -> Executors.newCachedThreadPool());
        return this.create(id, groupName, groupExecutorService);
    }

    public void addCircuitBreakerCustomizer(Customizer<CircuitBreaker> customizer, String ... ids) {
        for (String id : ids) {
            this.circuitBreakerCustomizers.put(id, customizer);
        }
    }

    private Resilience4JCircuitBreaker create(String id, String groupName, ExecutorService circuitBreakerExecutorService) {
        Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration config = this.getConfigurations().computeIfAbsent(id, this.defaultConfiguration);
        return new Resilience4JCircuitBreaker(id, groupName, config.getCircuitBreakerConfig(), config.getTimeLimiterConfig(), this.circuitBreakerRegistry, this.timeLimiterRegistry, circuitBreakerExecutorService, Optional.ofNullable(this.circuitBreakerCustomizers.get(id)), this.bulkheadProvider);
    }
}

