/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.aot;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.aot.ApplicationContextAotGenerator;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.javapoet.ClassName;
import org.springframework.util.Assert;

public class LoadBalancerChildContextInitializer
implements BeanRegistrationAotProcessor,
ApplicationListener<WebServerInitializedEvent> {
    private final ApplicationContext applicationContext;
    private final LoadBalancerClientFactory loadBalancerClientFactory;
    private final Map<String, ApplicationContextInitializer<GenericApplicationContext>> applicationContextInitializers;

    public LoadBalancerChildContextInitializer(LoadBalancerClientFactory loadBalancerClientFactory, ApplicationContext applicationContext) {
        this(loadBalancerClientFactory, applicationContext, new HashMap<String, ApplicationContextInitializer<GenericApplicationContext>>());
    }

    public LoadBalancerChildContextInitializer(LoadBalancerClientFactory loadBalancerClientFactory, ApplicationContext applicationContext, Map<String, ApplicationContextInitializer<GenericApplicationContext>> applicationContextInitializers) {
        this.loadBalancerClientFactory = loadBalancerClientFactory;
        this.applicationContext = applicationContext;
        this.applicationContextInitializers = applicationContextInitializers;
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)this.applicationContext);
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)this.applicationContext;
        ConfigurableListableBeanFactory applicationBeanFactory = context.getBeanFactory();
        if (!registeredBean.getBeanClass().equals(this.getClass()) || !registeredBean.getBeanFactory().equals(applicationBeanFactory)) {
            return null;
        }
        HashSet<String> contextIds = new HashSet<String>();
        contextIds.addAll(this.getContextIdsFromConfig());
        contextIds.addAll(this.getEagerLoadContextIds());
        Map<String, GenericApplicationContext> childContextAotContributions = contextIds.stream().map(contextId -> Map.entry(contextId, this.buildChildContext((String)contextId))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new AotContribution(childContextAotContributions);
    }

    private Set<String> getContextIdsFromConfig() {
        Map configurations = this.loadBalancerClientFactory.getConfigurations();
        return configurations.keySet().stream().filter(key -> !key.startsWith("default.")).collect(Collectors.toSet());
    }

    private Set<String> getEagerLoadContextIds() {
        return (Set)Binder.get((Environment)this.applicationContext.getEnvironment()).bind("spring.cloud.loadbalancer.eager-load.clients", Bindable.setOf(String.class)).orElse(Collections.emptySet());
    }

    private GenericApplicationContext buildChildContext(String contextId) {
        GenericApplicationContext childContext = this.loadBalancerClientFactory.buildContext(contextId);
        this.loadBalancerClientFactory.registerBeans(contextId, childContext);
        return childContext;
    }

    public LoadBalancerChildContextInitializer withApplicationContextInitializers(Map<String, Object> applicationContextInitializers) {
        HashMap<String, ApplicationContextInitializer<GenericApplicationContext>> convertedInitializers = new HashMap<String, ApplicationContextInitializer<GenericApplicationContext>>();
        applicationContextInitializers.keySet().forEach(contextId -> convertedInitializers.put((String)contextId, (ApplicationContextInitializer<GenericApplicationContext>)((ApplicationContextInitializer)applicationContextInitializers.get(contextId))));
        return new LoadBalancerChildContextInitializer(this.loadBalancerClientFactory, this.applicationContext, convertedInitializers);
    }

    public boolean isBeanExcludedFromAotProcessing() {
        return false;
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        if (this.applicationContext.equals(event.getApplicationContext())) {
            this.applicationContextInitializers.keySet().forEach(contextId -> {
                GenericApplicationContext childContext = this.loadBalancerClientFactory.buildContext((String)contextId);
                this.applicationContextInitializers.get(contextId).initialize((ConfigurableApplicationContext)childContext);
                this.loadBalancerClientFactory.addContext((String)contextId, childContext);
                childContext.refresh();
            });
        }
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private final Map<String, GenericApplicationContext> childContexts;

        AotContribution(Map<String, GenericApplicationContext> childContexts) {
            this.childContexts = childContexts.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> Map.entry((String)entry.getKey(), (GenericApplicationContext)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            Map<String, ClassName> generatedInitializerClassNames = this.childContexts.entrySet().stream().map(entry -> {
                String name = ((GenericApplicationContext)entry.getValue()).getDisplayName();
                name = name.replaceAll("[-]", "_");
                GenerationContext childGenerationContext = generationContext.withName(name);
                ClassName initializerClassName = new ApplicationContextAotGenerator().processAheadOfTime((GenericApplicationContext)entry.getValue(), childGenerationContext);
                return Map.entry((String)entry.getKey(), initializerClassName);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            GeneratedMethod postProcessorMethod = beanRegistrationCode.getMethods().add("addChildContextInitializer", method -> {
                method.addJavadoc("Use AOT child context management initialization", new Object[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(RegisteredBean.class, "registeredBean", new Modifier[0]).addParameter(LoadBalancerChildContextInitializer.class, "instance", new Modifier[0]).returns(LoadBalancerChildContextInitializer.class).addStatement("$T<String, Object> initializers = new $T<>()", new Object[]{Map.class, HashMap.class});
                generatedInitializerClassNames.keySet().forEach(contextId -> method.addStatement("initializers.put($S, new $L())", new Object[]{contextId, generatedInitializerClassNames.get(contextId)}));
                method.addStatement("return instance.withApplicationContextInitializers(initializers)", new Object[0]);
            });
            beanRegistrationCode.addInstancePostProcessor(postProcessorMethod.toMethodReference());
        }
    }
}

