/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.convert;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.support.ExampleMatcherAccessor;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class QueryByExamplePredicateBuilder {
    private static final Set<Attribute.PersistentAttributeType> ASSOCIATION_TYPES = EnumSet.of(Attribute.PersistentAttributeType.MANY_TO_MANY, Attribute.PersistentAttributeType.MANY_TO_ONE, Attribute.PersistentAttributeType.ONE_TO_MANY, Attribute.PersistentAttributeType.ONE_TO_ONE);

    public static <T> Predicate getPredicate(Root<T> root, CriteriaBuilder cb, Example<T> example) {
        return QueryByExamplePredicateBuilder.getPredicate(root, cb, example, EscapeCharacter.DEFAULT);
    }

    public static <T> Predicate getPredicate(Root<T> root, CriteriaBuilder cb, Example<T> example, EscapeCharacter escapeCharacter) {
        Assert.notNull(root, (String)"Root must not be null!");
        Assert.notNull((Object)cb, (String)"CriteriaBuilder must not be null!");
        Assert.notNull(example, (String)"Example must not be null!");
        ExampleMatcher matcher = example.getMatcher();
        List<Predicate> predicates = QueryByExamplePredicateBuilder.getPredicates("", cb, root, root.getModel(), example.getProbe(), example.getProbeType(), new ExampleMatcherAccessor(matcher), new PathNode("root", null, example.getProbe()), escapeCharacter);
        if (predicates.isEmpty()) {
            return cb.isTrue(cb.literal((Object)true));
        }
        if (predicates.size() == 1) {
            return predicates.iterator().next();
        }
        Predicate[] array = predicates.toArray(new Predicate[0]);
        return matcher.isAllMatching() ? cb.and(array) : cb.or(array);
    }

    static List<Predicate> getPredicates(String path, CriteriaBuilder cb, Path<?> from, ManagedType<?> type, Object value, Class<?> probeType, ExampleMatcherAccessor exampleAccessor, PathNode currentNode, EscapeCharacter escapeCharacter) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        DirectFieldAccessFallbackBeanWrapper beanWrapper = new DirectFieldAccessFallbackBeanWrapper(value);
        for (SingularAttribute attribute : type.getSingularAttributes()) {
            Object currentPath = !StringUtils.hasText((String)path) ? attribute.getName() : path + "." + attribute.getName();
            if (exampleAccessor.isIgnoredPath((String)currentPath)) continue;
            ExampleMatcher.PropertyValueTransformer transformer = exampleAccessor.getValueTransformerForPath((String)currentPath);
            Optional optionalValue = (Optional)transformer.apply(Optional.ofNullable(beanWrapper.getPropertyValue(attribute.getName())));
            if (!optionalValue.isPresent()) {
                if (!exampleAccessor.getNullHandler().equals((Object)ExampleMatcher.NullHandler.INCLUDE)) continue;
                predicates.add(cb.isNull((Expression)from.get(attribute)));
                continue;
            }
            Object attributeValue = optionalValue.get();
            if (attribute.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.EMBEDDED) || QueryByExamplePredicateBuilder.isAssociation(attribute) && !(from instanceof From)) {
                predicates.addAll(QueryByExamplePredicateBuilder.getPredicates((String)currentPath, cb, from.get(attribute.getName()), (ManagedType)attribute.getType(), attributeValue, probeType, exampleAccessor, currentNode, escapeCharacter));
                continue;
            }
            if (QueryByExamplePredicateBuilder.isAssociation(attribute)) {
                PathNode node = currentNode.add(attribute.getName(), attributeValue);
                if (node.spansCycle()) {
                    throw new InvalidDataAccessApiUsageException(String.format("Path '%s' from root %s must not span a cyclic property reference!%n%s", currentPath, ClassUtils.getShortName(probeType), node));
                }
                predicates.addAll(QueryByExamplePredicateBuilder.getPredicates((String)currentPath, cb, ((From)from).join(attribute.getName()), (ManagedType)attribute.getType(), attributeValue, probeType, exampleAccessor, node, escapeCharacter));
                continue;
            }
            if (attribute.getJavaType().equals(String.class)) {
                Path expression = from.get(attribute);
                if (exampleAccessor.isIgnoreCaseForPath((String)currentPath)) {
                    expression = cb.lower((Expression)expression);
                    attributeValue = attributeValue.toString().toLowerCase();
                }
                switch (exampleAccessor.getStringMatcherForPath((String)currentPath)) {
                    case DEFAULT: 
                    case EXACT: {
                        predicates.add(cb.equal((Expression)expression, attributeValue));
                        break;
                    }
                    case CONTAINING: {
                        predicates.add(cb.like((Expression)expression, "%" + escapeCharacter.escape(attributeValue.toString()) + "%", escapeCharacter.getEscapeCharacter()));
                        break;
                    }
                    case STARTING: {
                        predicates.add(cb.like((Expression)expression, escapeCharacter.escape(attributeValue.toString()) + "%", escapeCharacter.getEscapeCharacter()));
                        break;
                    }
                    case ENDING: {
                        predicates.add(cb.like((Expression)expression, "%" + escapeCharacter.escape(attributeValue.toString()), escapeCharacter.getEscapeCharacter()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported StringMatcher " + exampleAccessor.getStringMatcherForPath((String)currentPath));
                    }
                }
                continue;
            }
            predicates.add(cb.equal((Expression)from.get(attribute), attributeValue));
        }
        return predicates;
    }

    private static boolean isAssociation(Attribute<?, ?> attribute) {
        return ASSOCIATION_TYPES.contains(attribute.getPersistentAttributeType());
    }

    private static class PathNode {
        String name;
        @Nullable
        PathNode parent;
        List<PathNode> siblings = new ArrayList<PathNode>();
        @Nullable
        Object value;

        PathNode(String edge, @Nullable PathNode parent, @Nullable Object value) {
            this.name = edge;
            this.parent = parent;
            this.value = value;
        }

        PathNode add(String attribute, @Nullable Object value) {
            PathNode node = new PathNode(attribute, this, value);
            this.siblings.add(node);
            return node;
        }

        boolean spansCycle() {
            if (this.value == null) {
                return false;
            }
            String identityHex = ObjectUtils.getIdentityHexString((Object)this.value);
            PathNode current = this.parent;
            while (current != null) {
                if (current.value != null && ObjectUtils.getIdentityHexString((Object)current.value).equals(identityHex)) {
                    return true;
                }
                current = current.parent;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.parent != null) {
                sb.append(this.parent.toString());
                sb.append(" -");
                sb.append(this.name);
                sb.append("-> ");
            }
            sb.append("[{ ");
            sb.append(ObjectUtils.nullSafeToString((Object)this.value));
            sb.append(" }]");
            return sb.toString();
        }
    }
}

