/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import jakarta.persistence.IdClass;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.data.util.ProxyUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JpaMetamodelEntityInformation<T, ID>
extends JpaEntityInformationSupport<T, ID> {
    private final IdMetadata<T> idMetadata;
    private final Optional<SingularAttribute<? super T, ?>> versionAttribute;
    private final Metamodel metamodel;
    @Nullable
    private final String entityName;

    public JpaMetamodelEntityInformation(Class<T> domainClass, Metamodel metamodel) {
        super(domainClass);
        Assert.notNull((Object)metamodel, (String)"Metamodel must not be null!");
        this.metamodel = metamodel;
        ManagedType type = metamodel.managedType(domainClass);
        if (type == null) {
            throw new IllegalArgumentException("The given domain class can not be found in the given Metamodel!");
        }
        String string = this.entityName = type instanceof EntityType ? ((EntityType)type).getName() : null;
        if (!(type instanceof IdentifiableType)) {
            throw new IllegalArgumentException("The given domain class does not contain an id attribute!");
        }
        IdentifiableType identifiableType = (IdentifiableType)type;
        this.idMetadata = new IdMetadata(identifiableType, PersistenceProvider.fromMetamodel(metamodel));
        this.versionAttribute = JpaMetamodelEntityInformation.findVersionAttribute(identifiableType, metamodel);
    }

    @Override
    public String getEntityName() {
        return this.entityName != null ? this.entityName : super.getEntityName();
    }

    private static <T> Optional<SingularAttribute<? super T, ?>> findVersionAttribute(IdentifiableType<T> type, Metamodel metamodel) {
        try {
            return Optional.ofNullable(type.getVersion(Object.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Set attributes = type.getSingularAttributes();
            for (SingularAttribute attribute : attributes) {
                if (!attribute.isVersion()) continue;
                return Optional.of(attribute);
            }
            Class superType = type.getJavaType().getSuperclass();
            if (!JpaMetamodel.of(metamodel).isJpaManaged(superType)) {
                return Optional.empty();
            }
            ManagedType managedSuperType = metamodel.managedType(superType);
            if (!(managedSuperType instanceof IdentifiableType)) {
                return Optional.empty();
            }
            return JpaMetamodelEntityInformation.findVersionAttribute((IdentifiableType)managedSuperType, metamodel);
        }
    }

    @Nullable
    public ID getId(T entity) {
        PersistenceProvider persistenceProvider = PersistenceProvider.fromMetamodel(this.metamodel);
        if (persistenceProvider.shouldUseAccessorFor(entity)) {
            return (ID)persistenceProvider.getIdentifierFrom(entity);
        }
        DirectFieldAccessFallbackBeanWrapper entityWrapper = new DirectFieldAccessFallbackBeanWrapper(entity);
        if (this.idMetadata.hasSimpleId()) {
            return (ID)entityWrapper.getPropertyValue(this.idMetadata.getSimpleIdAttribute().getName());
        }
        IdentifierDerivingDirectFieldAccessFallbackBeanWrapper idWrapper = new IdentifierDerivingDirectFieldAccessFallbackBeanWrapper(this.idMetadata.getType(), this.metamodel);
        boolean partialIdValueFound = false;
        for (SingularAttribute<T, ?> attribute : this.idMetadata) {
            Object propertyValue = entityWrapper.getPropertyValue(attribute.getName());
            if (propertyValue != null) {
                partialIdValueFound = true;
            }
            idWrapper.setPropertyValue(attribute.getName(), propertyValue);
        }
        return (ID)(partialIdValueFound ? idWrapper.getWrappedInstance() : null);
    }

    public Class<ID> getIdType() {
        return this.idMetadata.getType();
    }

    @Override
    public SingularAttribute<? super T, ?> getIdAttribute() {
        return this.idMetadata.getSimpleIdAttribute();
    }

    @Override
    public boolean hasCompositeId() {
        return !this.idMetadata.hasSimpleId();
    }

    @Override
    public Iterable<String> getIdAttributeNames() {
        ArrayList<String> attributeNames = new ArrayList<String>(this.idMetadata.attributes.size());
        for (SingularAttribute singularAttribute : this.idMetadata.attributes) {
            attributeNames.add(singularAttribute.getName());
        }
        return attributeNames;
    }

    @Override
    public Object getCompositeIdAttributeValue(Object id, String idAttribute) {
        Assert.isTrue((boolean)this.hasCompositeId(), (String)"Model must have a composite Id!");
        return new DirectFieldAccessFallbackBeanWrapper(id).getPropertyValue(idAttribute);
    }

    public boolean isNew(T entity) {
        if (!this.versionAttribute.isPresent() || this.versionAttribute.map(Attribute::getJavaType).map(Class::isPrimitive).orElse(false).booleanValue()) {
            return super.isNew(entity);
        }
        DirectFieldAccessFallbackBeanWrapper wrapper = new DirectFieldAccessFallbackBeanWrapper(entity);
        return this.versionAttribute.map(arg_0 -> JpaMetamodelEntityInformation.lambda$isNew$0((BeanWrapper)wrapper, arg_0)).orElse(true);
    }

    private static /* synthetic */ Boolean lambda$isNew$0(BeanWrapper wrapper, SingularAttribute it) {
        return wrapper.getPropertyValue(it.getName()) == null;
    }

    private static class IdMetadata<T>
    implements Iterable<SingularAttribute<? super T, ?>> {
        private final IdentifiableType<T> type;
        private final Set<SingularAttribute<? super T, ?>> idClassAttributes;
        private final Set<SingularAttribute<? super T, ?>> attributes;
        @Nullable
        private Class<?> idType;

        IdMetadata(IdentifiableType<T> source, PersistenceProvider persistenceProvider) {
            this.type = source;
            this.idClassAttributes = persistenceProvider.getIdClassAttributes(source);
            this.attributes = source.hasSingleIdAttribute() ? Collections.singleton(source.getId(source.getIdType().getJavaType())) : source.getIdClassAttributes();
        }

        boolean hasSimpleId() {
            return this.idClassAttributes.isEmpty() && this.attributes.size() == 1;
        }

        public Class<?> getType() {
            if (this.idType != null) {
                return this.idType;
            }
            this.idType = this.tryExtractIdTypeWithFallbackToIdTypeLookup();
            if (this.idType == null) {
                throw new IllegalStateException("Cannot resolve Id type from " + this.type);
            }
            return this.idType;
        }

        @Nullable
        private Class<?> tryExtractIdTypeWithFallbackToIdTypeLookup() {
            try {
                Class<T> idClassType = IdMetadata.lookupIdClass(this.type);
                if (idClassType != null) {
                    return idClassType;
                }
                Type idType = this.type.getIdType();
                return idType == null ? null : idType.getJavaType();
            }
            catch (IllegalStateException e) {
                return null;
            }
        }

        @Nullable
        private static Class<?> lookupIdClass(IdentifiableType<?> type) {
            IdClass annotation = type.getJavaType() != null ? (IdClass)AnnotationUtils.findAnnotation((Class)type.getJavaType(), IdClass.class) : null;
            return annotation == null ? null : annotation.value();
        }

        SingularAttribute<? super T, ?> getSimpleIdAttribute() {
            return this.attributes.iterator().next();
        }

        @Override
        public Iterator<SingularAttribute<? super T, ?>> iterator() {
            return this.attributes.iterator();
        }
    }

    private static class IdentifierDerivingDirectFieldAccessFallbackBeanWrapper
    extends DirectFieldAccessFallbackBeanWrapper {
        private final Metamodel metamodel;
        private final JpaMetamodel jpaMetamodel;

        IdentifierDerivingDirectFieldAccessFallbackBeanWrapper(Class<?> type, Metamodel metamodel) {
            super(type);
            this.metamodel = metamodel;
            this.jpaMetamodel = JpaMetamodel.of(metamodel);
        }

        public void setPropertyValue(String propertyName, @Nullable Object value) {
            if (!this.isIdentifierDerivationNecessary(value)) {
                super.setPropertyValue(propertyName, value);
                return;
            }
            JpaMetamodelEntityInformation nestedEntityInformation = new JpaMetamodelEntityInformation(ProxyUtils.getUserClass((Object)value), this.metamodel);
            if (!nestedEntityInformation.getJavaType().isAnnotationPresent(IdClass.class)) {
                Object nestedIdPropertyValue = new DirectFieldAccessFallbackBeanWrapper(value).getPropertyValue(nestedEntityInformation.getRequiredIdAttribute().getName());
                super.setPropertyValue(propertyName, nestedIdPropertyValue);
                return;
            }
            DirectFieldAccessFallbackBeanWrapper sourceIdValueWrapper = new DirectFieldAccessFallbackBeanWrapper(value);
            BeanWrapperImpl targetIdClassTypeWrapper = new BeanWrapperImpl(nestedEntityInformation.getIdType());
            for (String idAttributeName : nestedEntityInformation.getIdAttributeNames()) {
                targetIdClassTypeWrapper.setPropertyValue(idAttributeName, this.extractActualIdPropertyValue((BeanWrapper)sourceIdValueWrapper, idAttributeName));
            }
            super.setPropertyValue(propertyName, targetIdClassTypeWrapper.getWrappedInstance());
        }

        @Nullable
        private Object extractActualIdPropertyValue(BeanWrapper sourceIdValueWrapper, String idAttributeName) {
            Object idPropertyValue = sourceIdValueWrapper.getPropertyValue(idAttributeName);
            if (idPropertyValue != null) {
                Class<?> idPropertyValueType = idPropertyValue.getClass();
                if (!this.jpaMetamodel.isJpaManaged(idPropertyValueType)) {
                    return idPropertyValue;
                }
                return new DirectFieldAccessFallbackBeanWrapper(idPropertyValue).getPropertyValue(this.tryFindSingularIdAttributeNameOrUseFallback(idPropertyValueType, idAttributeName));
            }
            return null;
        }

        private String tryFindSingularIdAttributeNameOrUseFallback(Class<?> idPropertyValueType, String fallbackIdTypePropertyName) {
            ManagedType idPropertyType = this.metamodel.managedType(idPropertyValueType);
            for (SingularAttribute sa : idPropertyType.getSingularAttributes()) {
                if (!sa.isId()) continue;
                return sa.getName();
            }
            return fallbackIdTypePropertyName;
        }

        private boolean isIdentifierDerivationNecessary(@Nullable Object value) {
            if (value == null) {
                return false;
            }
            Class userClass = ProxyUtils.getUserClass((Object)value);
            if (!this.jpaMetamodel.isJpaManaged(userClass)) {
                return false;
            }
            ManagedType managedType = this.metamodel.managedType(userClass);
            if (managedType == null) {
                throw new IllegalStateException("ManagedType must not be null. We checked that it exists before.");
            }
            return managedType.getPersistenceType() == Type.PersistenceType.ENTITY;
        }
    }
}

