/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.NoSuchElementException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.keyvalue.core.UncategorizedKeyValueException;

public class KeyValuePersistenceExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException e) {
        if (e == null || e instanceof DataAccessException) {
            return (DataAccessException)e;
        }
        if (e instanceof NoSuchElementException || e instanceof IndexOutOfBoundsException || e instanceof IllegalStateException) {
            return new DataRetrievalFailureException(e.getMessage(), (Throwable)e);
        }
        if (e.getClass().getName().startsWith("java")) {
            return new UncategorizedKeyValueException(e.getMessage(), e);
        }
        return null;
    }
}

