/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveZSetCommands {
    default public Mono<Long> zAdd(ByteBuffer key, Double score, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)score, (String)"Score must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zAdd((Publisher<ZAddCommand>)Mono.just((Object)ZAddCommand.tuple(new DefaultTuple(ByteUtils.getBytes(value), score)).to(key))).next().map(resp -> ((Number)resp.getOutput()).longValue());
    }

    default public Mono<Long> zAdd(ByteBuffer key, Collection<? extends RedisZSetCommands.Tuple> tuples) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        return this.zAdd((Publisher<ZAddCommand>)Mono.just((Object)ZAddCommand.tuples(tuples).to(key))).next().map(resp -> ((Number)resp.getOutput()).longValue());
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZAddCommand, Number>> zAdd(Publisher<ZAddCommand> var1);

    default public Mono<Long> zRem(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zRem(key, Collections.singletonList(value));
    }

    default public Mono<Long> zRem(ByteBuffer key, Collection<ByteBuffer> values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        return this.zRem((Publisher<ZRemCommand>)Mono.just((Object)ZRemCommand.values(values).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZRemCommand, Long>> zRem(Publisher<ZRemCommand> var1);

    default public Mono<Double> zIncrBy(ByteBuffer key, Number increment, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)increment, (String)"Increment must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zIncrBy((Publisher<ZIncrByCommand>)Mono.just((Object)ZIncrByCommand.scoreOf(value).by(increment).storedWithin(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZIncrByCommand, Double>> zIncrBy(Publisher<ZIncrByCommand> var1);

    default public Mono<ByteBuffer> zRandMember(ByteBuffer key) {
        return this.zRandMember((Publisher<ZRandMemberCommand>)Mono.just((Object)ZRandMemberCommand.singleValue().from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).next();
    }

    default public Flux<ByteBuffer> zRandMember(ByteBuffer key, long count) {
        return this.zRandMember((Publisher<ZRandMemberCommand>)Mono.just((Object)ZRandMemberCommand.valueCount(count).from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZRandMemberCommand, Flux<ByteBuffer>>> zRandMember(Publisher<ZRandMemberCommand> var1);

    default public Mono<RedisZSetCommands.Tuple> zRandMemberWithScore(ByteBuffer key) {
        return this.zRandMemberWithScore((Publisher<ZRandMemberCommand>)Mono.just((Object)ZRandMemberCommand.singleValue().from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).next();
    }

    default public Flux<RedisZSetCommands.Tuple> zRandMemberWithScore(ByteBuffer key, long count) {
        return this.zRandMemberWithScore((Publisher<ZRandMemberCommand>)Mono.just((Object)ZRandMemberCommand.valueCount(count).from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZRandMemberCommand, Flux<RedisZSetCommands.Tuple>>> zRandMemberWithScore(Publisher<ZRandMemberCommand> var1);

    default public Mono<Long> zRank(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zRank((Publisher<ZRankCommand>)Mono.just((Object)ZRankCommand.indexOf(value).storedWithin(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> zRevRank(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zRank((Publisher<ZRankCommand>)Mono.just((Object)ZRankCommand.reverseIndexOf(value).storedWithin(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZRankCommand, Long>> zRank(Publisher<ZRankCommand> var1);

    default public Flux<ByteBuffer> zRange(ByteBuffer key, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRange((Publisher<ZRangeCommand>)Mono.just((Object)ZRangeCommand.valuesWithin(range).from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<RedisZSetCommands.Tuple> zRangeWithScores(ByteBuffer key, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.zRange((Publisher<ZRangeCommand>)Mono.just((Object)ZRangeCommand.valuesWithin(range).withScores().from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<ByteBuffer> zRevRange(ByteBuffer key, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.zRange((Publisher<ZRangeCommand>)Mono.just((Object)ZRangeCommand.reverseValuesWithin(range).from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<RedisZSetCommands.Tuple> zRevRangeWithScores(ByteBuffer key, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.zRange((Publisher<ZRangeCommand>)Mono.just((Object)ZRangeCommand.reverseValuesWithin(range).withScores().from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZRangeCommand, Flux<RedisZSetCommands.Tuple>>> zRange(Publisher<ZRangeCommand> var1);

    default public Flux<ByteBuffer> zRangeByScore(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.scoresWithin(range).from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<ByteBuffer> zRangeByScore(ByteBuffer key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.scoresWithin(range).from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<RedisZSetCommands.Tuple> zRangeByScoreWithScores(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.scoresWithin(range).withScores().from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<RedisZSetCommands.Tuple> zRangeByScoreWithScores(ByteBuffer key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.scoresWithin(range).withScores().from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<ByteBuffer> zRevRangeByScore(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.reverseScoresWithin(range).from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<ByteBuffer> zRevRangeByScore(ByteBuffer key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.reverseScoresWithin(range).from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput).map(tuple -> ByteBuffer.wrap(tuple.getValue()));
    }

    default public Flux<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.reverseScoresWithin(range).withScores().from(key))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(ByteBuffer key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.zRangeByScore((Publisher<ZRangeByScoreCommand>)Mono.just((Object)ZRangeByScoreCommand.reverseScoresWithin(range).withScores().from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZRangeByScoreCommand, Flux<RedisZSetCommands.Tuple>>> zRangeByScore(Publisher<ZRangeByScoreCommand> var1);

    default public Flux<RedisZSetCommands.Tuple> zScan(ByteBuffer key) {
        return this.zScan(key, ScanOptions.NONE);
    }

    default public Flux<RedisZSetCommands.Tuple> zScan(ByteBuffer key, ScanOptions options) {
        return this.zScan((Publisher<ReactiveRedisConnection.KeyScanCommand>)Mono.just((Object)ReactiveRedisConnection.KeyScanCommand.key(key).withOptions(options))).map(ReactiveRedisConnection.CommandResponse::getOutput).flatMap(it -> it);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<RedisZSetCommands.Tuple>>> zScan(Publisher<ReactiveRedisConnection.KeyScanCommand> var1);

    default public Mono<Long> zCount(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zCount((Publisher<ZCountCommand>)Mono.just((Object)ZCountCommand.scoresWithin(range).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZCountCommand, Long>> zCount(Publisher<ZCountCommand> var1);

    default public Mono<Long> zLexCount(ByteBuffer key, Range<String> range) {
        return this.zLexCount((Publisher<ZLexCountCommand>)Mono.just((Object)ZLexCountCommand.stringsWithin(range).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZLexCountCommand, Long>> zLexCount(Publisher<ZLexCountCommand> var1);

    default public Mono<RedisZSetCommands.Tuple> zPopMin(ByteBuffer key) {
        return this.zPop((Publisher<ZPopCommand>)Mono.just((Object)ZPopCommand.min().from(key))).map(ReactiveRedisConnection.CommandResponse::getOutput).flatMap(Flux::next).next();
    }

    default public Flux<RedisZSetCommands.Tuple> zPopMin(ByteBuffer key, long count) {
        return this.zPop((Publisher<ZPopCommand>)Mono.just((Object)ZPopCommand.min().from(key).count(count))).map(ReactiveRedisConnection.CommandResponse::getOutput).flatMap(Function.identity());
    }

    default public Mono<RedisZSetCommands.Tuple> bZPopMin(ByteBuffer key, Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.bZPop((Publisher<BZPopCommand>)Mono.just((Object)BZPopCommand.min().from(key).blockingFor(timeout))).map(ReactiveRedisConnection.CommandResponse::getOutput).flatMap(Flux::next).next();
    }

    default public Mono<RedisZSetCommands.Tuple> zPopMax(ByteBuffer key) {
        return this.zPop((Publisher<ZPopCommand>)Mono.just((Object)ZPopCommand.max().from(key))).map(ReactiveRedisConnection.CommandResponse::getOutput).flatMap(Flux::next).next();
    }

    default public Flux<RedisZSetCommands.Tuple> zPopMax(ByteBuffer key, long count) {
        return this.zPop((Publisher<ZPopCommand>)Mono.just((Object)ZPopCommand.max().from(key).count(count))).map(ReactiveRedisConnection.CommandResponse::getOutput).flatMap(Function.identity());
    }

    default public Mono<RedisZSetCommands.Tuple> bZPopMax(ByteBuffer key, Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.bZPop((Publisher<BZPopCommand>)Mono.just((Object)BZPopCommand.max().from(key).blockingFor(timeout))).map(ReactiveRedisConnection.CommandResponse::getOutput).flatMap(Flux::next).next();
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZPopCommand, Flux<RedisZSetCommands.Tuple>>> zPop(Publisher<ZPopCommand> var1);

    public Flux<ReactiveRedisConnection.CommandResponse<BZPopCommand, Flux<RedisZSetCommands.Tuple>>> bZPop(Publisher<BZPopCommand> var1);

    default public Mono<Long> zCard(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.zCard((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> zCard(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public Mono<Double> zScore(ByteBuffer key, ByteBuffer value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.zScore((Publisher<ZScoreCommand>)Mono.just((Object)ZScoreCommand.scoreOf(value).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZScoreCommand, Double>> zScore(Publisher<ZScoreCommand> var1);

    default public Mono<List<Double>> zMScore(ByteBuffer key, Collection<ByteBuffer> values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        return this.zMScore((Publisher<ZMScoreCommand>)Mono.just((Object)ZMScoreCommand.scoreOf(values).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<ZMScoreCommand, Double>> zMScore(Publisher<ZMScoreCommand> var1);

    default public Mono<Long> zRemRangeByRank(ByteBuffer key, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRemRangeByRank((Publisher<ZRemRangeByRankCommand>)Mono.just((Object)ZRemRangeByRankCommand.valuesWithin(range).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZRemRangeByRankCommand, Long>> zRemRangeByRank(Publisher<ZRemRangeByRankCommand> var1);

    default public Mono<Long> zRemRangeByScore(ByteBuffer key, Range<Double> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRemRangeByScore((Publisher<ZRemRangeByScoreCommand>)Mono.just((Object)ZRemRangeByScoreCommand.scoresWithin(range).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZRemRangeByScoreCommand, Long>> zRemRangeByScore(Publisher<ZRemRangeByScoreCommand> var1);

    default public Mono<Long> zRemRangeByLex(ByteBuffer key, Range<String> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRemRangeByLex((Publisher<ZRemRangeByLexCommand>)Mono.just((Object)ZRemRangeByLexCommand.lexWithin(range).from(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZRemRangeByLexCommand, Long>> zRemRangeByLex(Publisher<ZRemRangeByLexCommand> var1);

    default public Flux<ByteBuffer> zDiff(List<ByteBuffer> sets) {
        return this.zDiff((Publisher<? extends ZDiffCommand>)Mono.just((Object)ZDiffCommand.sets(sets))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZDiffCommand, Flux<ByteBuffer>>> zDiff(Publisher<? extends ZDiffCommand> var1);

    default public Flux<RedisZSetCommands.Tuple> zDiffWithScores(List<ByteBuffer> sets) {
        return this.zDiffWithScores((Publisher<? extends ZDiffCommand>)Mono.just((Object)ZDiffCommand.sets(sets))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZDiffCommand, Flux<RedisZSetCommands.Tuple>>> zDiffWithScores(Publisher<? extends ZDiffCommand> var1);

    default public Mono<Long> zDiffStore(ByteBuffer destinationKey, List<ByteBuffer> sets) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zDiffStore((Publisher<ZDiffStoreCommand>)Mono.just((Object)ZDiffStoreCommand.sourceKeys(sets).storeAs(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZDiffStoreCommand, Long>> zDiffStore(Publisher<ZDiffStoreCommand> var1);

    default public Flux<ByteBuffer> zInter(List<ByteBuffer> sets) {
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zInter((Publisher<? extends ZAggregateCommand>)Mono.just((Object)ZAggregateCommand.sets(sets))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZAggregateCommand, Flux<ByteBuffer>>> zInter(Publisher<? extends ZAggregateCommand> var1);

    default public Flux<RedisZSetCommands.Tuple> zInterWithScores(List<ByteBuffer> sets) {
        return this.zInterWithScores(sets, Collections.emptyList());
    }

    default public Flux<RedisZSetCommands.Tuple> zInterWithScores(List<ByteBuffer> sets, List<Double> weights) {
        return this.zInterWithScores(sets, weights, null);
    }

    default public Flux<RedisZSetCommands.Tuple> zInterWithScores(List<ByteBuffer> sets, RedisZSetCommands.Weights weights) {
        return this.zInterWithScores(sets, weights, null);
    }

    default public Flux<RedisZSetCommands.Tuple> zInterWithScores(List<ByteBuffer> sets, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zInterWithScores((Publisher<? extends ZAggregateCommand>)Mono.just((Object)ZAggregateCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights(weights))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<RedisZSetCommands.Tuple> zInterWithScores(List<ByteBuffer> sets, RedisZSetCommands.Weights weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zInterWithScores((Publisher<? extends ZAggregateCommand>)Mono.just((Object)ZAggregateCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights(weights))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZAggregateCommand, Flux<RedisZSetCommands.Tuple>>> zInterWithScores(Publisher<? extends ZAggregateCommand> var1);

    default public Mono<Long> zInterStore(ByteBuffer destinationKey, List<ByteBuffer> sets) {
        return this.zInterStore(destinationKey, sets, Collections.emptyList());
    }

    default public Mono<Long> zInterStore(ByteBuffer destinationKey, List<ByteBuffer> sets, List<Double> weights) {
        return this.zInterStore(destinationKey, sets, weights, null);
    }

    default public Mono<Long> zInterStore(ByteBuffer destinationKey, List<ByteBuffer> sets, RedisZSetCommands.Weights weights) {
        return this.zInterStore(destinationKey, sets, weights, null);
    }

    default public Mono<Long> zInterStore(ByteBuffer destinationKey, List<ByteBuffer> sets, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zInterStore((Publisher<? extends ZAggregateStoreCommand>)Mono.just((Object)((ZInterStoreCommand)ZInterStoreCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights((List)weights)).storeAs(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> zInterStore(ByteBuffer destinationKey, List<ByteBuffer> sets, RedisZSetCommands.Weights weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zInterStore((Publisher<? extends ZAggregateStoreCommand>)Mono.just((Object)ZInterStoreCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights(weights).storeAs(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZAggregateStoreCommand, Long>> zInterStore(Publisher<? extends ZAggregateStoreCommand> var1);

    default public Flux<ByteBuffer> zUnion(List<ByteBuffer> sets) {
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zUnion((Publisher<? extends ZAggregateCommand>)Mono.just((Object)ZAggregateCommand.sets(sets))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<RedisZSetCommands.Tuple> zUnionWithScores(List<ByteBuffer> sets) {
        return this.zUnionWithScores(sets, Collections.emptyList());
    }

    default public Flux<RedisZSetCommands.Tuple> zUnionWithScores(List<ByteBuffer> sets, List<Double> weights) {
        return this.zUnionWithScores(sets, weights, null);
    }

    default public Flux<RedisZSetCommands.Tuple> zUnionWithScores(List<ByteBuffer> sets, RedisZSetCommands.Weights weights) {
        return this.zUnionWithScores(sets, weights, null);
    }

    default public Flux<RedisZSetCommands.Tuple> zUnionWithScores(List<ByteBuffer> sets, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zUnionWithScores((Publisher<? extends ZAggregateCommand>)Mono.just((Object)ZAggregateCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights(weights))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<RedisZSetCommands.Tuple> zUnionWithScores(List<ByteBuffer> sets, RedisZSetCommands.Weights weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zUnionWithScores((Publisher<? extends ZAggregateCommand>)Mono.just((Object)ZAggregateCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights(weights))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZAggregateCommand, Flux<RedisZSetCommands.Tuple>>> zUnionWithScores(Publisher<? extends ZAggregateCommand> var1);

    public Flux<ReactiveRedisConnection.CommandResponse<ZAggregateCommand, Flux<ByteBuffer>>> zUnion(Publisher<? extends ZAggregateCommand> var1);

    default public Mono<Long> zUnionStore(ByteBuffer destinationKey, List<ByteBuffer> sets) {
        return this.zUnionStore(destinationKey, sets, Collections.emptyList());
    }

    default public Mono<Long> zUnionStore(ByteBuffer destinationKey, List<ByteBuffer> sets, List<Double> weights) {
        return this.zUnionStore(destinationKey, sets, weights, null);
    }

    default public Mono<Long> zUnionStore(ByteBuffer destinationKey, List<ByteBuffer> sets, RedisZSetCommands.Weights weights) {
        return this.zUnionStore(destinationKey, sets, weights, null);
    }

    default public Mono<Long> zUnionStore(ByteBuffer destinationKey, List<ByteBuffer> sets, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zUnionStore((Publisher<? extends ZAggregateStoreCommand>)Mono.just((Object)ZAggregateStoreCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights(weights).storeAs(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Mono<Long> zUnionStore(ByteBuffer destinationKey, List<ByteBuffer> sets, RedisZSetCommands.Weights weights, @Nullable RedisZSetCommands.Aggregate aggregateFunction) {
        Assert.notNull((Object)destinationKey, (String)"DestinationKey must not be null!");
        Assert.notNull(sets, (String)"Sets must not be null!");
        return this.zUnionStore((Publisher<? extends ZAggregateStoreCommand>)Mono.just((Object)ZUnionStoreCommand.sets(sets).aggregateUsing(aggregateFunction).applyWeights(weights).storeAs(destinationKey))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ZAggregateStoreCommand, Long>> zUnionStore(Publisher<? extends ZAggregateStoreCommand> var1);

    default public Flux<ByteBuffer> zRangeByLex(ByteBuffer key, Range<String> range) {
        return this.zRangeByLex(key, range, RedisZSetCommands.Limit.unlimited());
    }

    default public Flux<ByteBuffer> zRangeByLex(ByteBuffer key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.zRangeByLex((Publisher<ZRangeByLexCommand>)Mono.just((Object)ZRangeByLexCommand.stringsWithin(range).from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    default public Flux<ByteBuffer> zRevRangeByLex(ByteBuffer key, Range<String> range) {
        return this.zRevRangeByLex(key, range, RedisZSetCommands.Limit.unlimited());
    }

    default public Flux<ByteBuffer> zRevRangeByLex(ByteBuffer key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.zRangeByLex((Publisher<ZRangeByLexCommand>)Mono.just((Object)ZRangeByLexCommand.reverseStringsWithin(range).from(key).limitTo(limit))).flatMap(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ZRangeByLexCommand, Flux<ByteBuffer>>> zRangeByLex(Publisher<ZRangeByLexCommand> var1);

    public static class ZAddCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<RedisZSetCommands.Tuple> tuples;
        private final boolean upsert;
        private final boolean returnTotalChanged;
        private final boolean incr;
        private final boolean gt;
        private final boolean lt;

        private ZAddCommand(@Nullable ByteBuffer key, List<RedisZSetCommands.Tuple> tuples, boolean upsert, boolean returnTotalChanged, boolean incr, boolean gt, boolean lt) {
            super(key);
            this.tuples = tuples;
            this.upsert = upsert;
            this.returnTotalChanged = returnTotalChanged;
            this.incr = incr;
            this.gt = gt;
            this.lt = lt;
        }

        public static ZAddCommand tuple(RedisZSetCommands.Tuple tuple) {
            Assert.notNull((Object)tuple, (String)"Tuple must not be null!");
            return ZAddCommand.tuples(Collections.singletonList(tuple));
        }

        public static ZAddCommand tuples(Collection<? extends RedisZSetCommands.Tuple> tuples) {
            Assert.notNull(tuples, (String)"Tuples must not be null!");
            return new ZAddCommand(null, new ArrayList<RedisZSetCommands.Tuple>(tuples), false, false, false, false, false);
        }

        public ZAddCommand to(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZAddCommand(key, this.tuples, this.upsert, this.returnTotalChanged, this.incr, this.gt, this.lt);
        }

        public ZAddCommand xx() {
            return new ZAddCommand(this.getKey(), this.tuples, false, this.returnTotalChanged, this.incr, this.gt, this.lt);
        }

        public ZAddCommand nx() {
            return new ZAddCommand(this.getKey(), this.tuples, true, this.returnTotalChanged, this.incr, this.gt, this.lt);
        }

        public ZAddCommand ch() {
            return new ZAddCommand(this.getKey(), this.tuples, this.upsert, true, this.incr, this.gt, this.lt);
        }

        public ZAddCommand incr() {
            return new ZAddCommand(this.getKey(), this.tuples, this.upsert, this.upsert, true, this.gt, this.lt);
        }

        public ZAddCommand gt() {
            return new ZAddCommand(this.getKey(), this.tuples, this.upsert, this.upsert, this.incr, true, this.lt);
        }

        public ZAddCommand lt() {
            return new ZAddCommand(this.getKey(), this.tuples, this.upsert, this.upsert, this.incr, this.gt, true);
        }

        public List<RedisZSetCommands.Tuple> getTuples() {
            return this.tuples;
        }

        public boolean isUpsert() {
            return this.upsert;
        }

        public boolean isIncr() {
            return this.incr;
        }

        public boolean isGt() {
            return this.gt;
        }

        public boolean isLt() {
            return this.lt;
        }

        public boolean isReturnTotalChanged() {
            return this.returnTotalChanged;
        }
    }

    public static class ZRemCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> values;

        private ZRemCommand(@Nullable ByteBuffer key, List<ByteBuffer> values) {
            super(key);
            this.values = values;
        }

        public static ZRemCommand values(ByteBuffer value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return new ZRemCommand(null, Collections.singletonList(value));
        }

        public static ZRemCommand values(Collection<ByteBuffer> values) {
            Assert.notNull(values, (String)"Values must not be null!");
            return new ZRemCommand(null, new ArrayList<ByteBuffer>(values));
        }

        public ZRemCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRemCommand(key, this.values);
        }

        public List<ByteBuffer> getValues() {
            return this.values;
        }
    }

    public static class ZIncrByCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer value;
        @Nullable
        private final Number increment;

        private ZIncrByCommand(@Nullable ByteBuffer key, ByteBuffer value, @Nullable Number increment) {
            super(key);
            this.value = value;
            this.increment = increment;
        }

        public static ZIncrByCommand scoreOf(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new ZIncrByCommand(null, member, null);
        }

        public ZIncrByCommand by(Number increment) {
            Assert.notNull((Object)increment, (String)"Increment must not be null!");
            return new ZIncrByCommand(this.getKey(), this.value, increment);
        }

        public ZIncrByCommand storedWithin(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZIncrByCommand(key, this.value, this.increment);
        }

        public ByteBuffer getValue() {
            return this.value;
        }

        @Nullable
        public Number getIncrement() {
            return this.increment;
        }
    }

    public static class ZRandMemberCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final long count;

        private ZRandMemberCommand(@Nullable ByteBuffer key, long count) {
            super(key);
            this.count = count;
        }

        public static ZRandMemberCommand valueCount(long nrValuesToRetrieve) {
            return new ZRandMemberCommand(null, nrValuesToRetrieve);
        }

        public static ZRandMemberCommand singleValue() {
            return new ZRandMemberCommand(null, 1L);
        }

        public ZRandMemberCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRandMemberCommand(key, this.count);
        }

        public long getCount() {
            return this.count;
        }
    }

    public static class ZRankCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer value;
        private final Sort.Direction direction;

        private ZRankCommand(@Nullable ByteBuffer key, ByteBuffer value, Sort.Direction direction) {
            super(key);
            this.value = value;
            this.direction = direction;
        }

        public static ZRankCommand indexOf(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new ZRankCommand(null, member, Sort.Direction.ASC);
        }

        public static ZRankCommand reverseIndexOf(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new ZRankCommand(null, member, Sort.Direction.DESC);
        }

        public ZRankCommand storedWithin(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRankCommand(key, this.value, this.direction);
        }

        public ByteBuffer getValue() {
            return this.value;
        }

        public Sort.Direction getDirection() {
            return this.direction;
        }
    }

    public static class ZRangeCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<Long> range;
        private final boolean withScores;
        private final Sort.Direction direction;

        private ZRangeCommand(@Nullable ByteBuffer key, Range<Long> range, Sort.Direction direction, boolean withScores) {
            super(key);
            this.range = range;
            this.withScores = withScores;
            this.direction = direction;
        }

        public static ZRangeCommand valuesWithin(Range<Long> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeCommand(null, range, Sort.Direction.ASC, false);
        }

        public static ZRangeCommand reverseValuesWithin(Range<Long> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeCommand(null, range, Sort.Direction.DESC, false);
        }

        public ZRangeCommand withScores() {
            return new ZRangeCommand(this.getKey(), this.range, this.direction, true);
        }

        public ZRangeCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRangeCommand(key, this.range, this.direction, this.withScores);
        }

        public Range<Long> getRange() {
            return this.range;
        }

        public boolean isWithScores() {
            return this.withScores;
        }

        public Sort.Direction getDirection() {
            return this.direction;
        }
    }

    public static class ZRangeByScoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<Double> range;
        private final boolean withScores;
        private final Sort.Direction direction;
        @Nullable
        private final RedisZSetCommands.Limit limit;

        private ZRangeByScoreCommand(@Nullable ByteBuffer key, Range<Double> range, Sort.Direction direction, boolean withScores, @Nullable RedisZSetCommands.Limit limit) {
            super(key);
            this.range = range;
            this.withScores = withScores;
            this.direction = direction;
            this.limit = limit;
        }

        public static ZRangeByScoreCommand scoresWithin(Range<Double> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeByScoreCommand(null, range, Sort.Direction.ASC, false, null);
        }

        public static ZRangeByScoreCommand reverseScoresWithin(Range<Double> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeByScoreCommand(null, range, Sort.Direction.DESC, false, null);
        }

        public ZRangeByScoreCommand withScores() {
            return new ZRangeByScoreCommand(this.getKey(), this.range, this.direction, true, this.limit);
        }

        public ZRangeByScoreCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRangeByScoreCommand(key, this.range, this.direction, this.withScores, this.limit);
        }

        public ZRangeByScoreCommand limitTo(RedisZSetCommands.Limit limit) {
            Assert.notNull((Object)limit, (String)"Limit must not be null!");
            return new ZRangeByScoreCommand(this.getKey(), this.range, this.direction, this.withScores, limit);
        }

        public Range<Double> getRange() {
            return this.range;
        }

        public boolean isWithScores() {
            return this.withScores;
        }

        public Sort.Direction getDirection() {
            return this.direction;
        }

        public Optional<RedisZSetCommands.Limit> getLimit() {
            return Optional.ofNullable(this.limit);
        }
    }

    public static class ZCountCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<Double> range;

        private ZCountCommand(@Nullable ByteBuffer key, Range<Double> range) {
            super(key);
            this.range = range;
        }

        public static ZCountCommand scoresWithin(Range<Double> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZCountCommand(null, range);
        }

        public ZCountCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZCountCommand(key, this.range);
        }

        public Range<Double> getRange() {
            return this.range;
        }
    }

    public static class ZLexCountCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<String> range;

        private ZLexCountCommand(@Nullable ByteBuffer key, Range<String> range) {
            super(key);
            this.range = range;
        }

        public static ZLexCountCommand stringsWithin(Range<String> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZLexCountCommand(null, range);
        }

        public ZLexCountCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZLexCountCommand(key, this.range);
        }

        public Range<String> getRange() {
            return this.range;
        }
    }

    public static class ZPopCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final PopDirection direction;
        private final long count;

        private ZPopCommand(PopDirection direction, @Nullable ByteBuffer key, long count) {
            super(key);
            this.count = count;
            this.direction = direction;
        }

        public static ZPopCommand min() {
            return new ZPopCommand(PopDirection.MIN, null, 1L);
        }

        public static ZPopCommand max() {
            return new ZPopCommand(PopDirection.MAX, null, 1L);
        }

        public ZPopCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZPopCommand(this.direction, key, this.count);
        }

        public ZPopCommand count(long count) {
            return new ZPopCommand(this.direction, this.getKey(), count);
        }

        public PopDirection getDirection() {
            return this.direction;
        }

        public long getCount() {
            return this.count;
        }
    }

    public static class BZPopCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final PopDirection direction;
        @Nullable
        private final TimeUnit timeUnit;
        @Nullable
        private final Long timeout;
        private final long count;

        private BZPopCommand(@Nullable ByteBuffer key, @Nullable Long timeout, @Nullable TimeUnit timeUnit, long count, PopDirection direction) {
            super(key);
            this.count = count;
            this.timeout = timeout;
            this.timeUnit = timeUnit;
            this.direction = direction;
        }

        public static BZPopCommand min() {
            return new BZPopCommand(null, null, null, 0L, PopDirection.MIN);
        }

        public static BZPopCommand max() {
            return new BZPopCommand(null, null, null, 0L, PopDirection.MAX);
        }

        public BZPopCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new BZPopCommand(key, this.timeout, this.timeUnit, this.count, this.direction);
        }

        public BZPopCommand count(long count) {
            return new BZPopCommand(this.getKey(), this.timeout, this.timeUnit, count, this.direction);
        }

        public BZPopCommand blockingFor(Duration timeout) {
            Assert.notNull((Object)timeout, (String)"Timeout must not be null!");
            return this.blockingFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }

        public BZPopCommand blockingFor(long timeout, TimeUnit timeUnit) {
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null!");
            return new BZPopCommand(this.getKey(), timeout, timeUnit, this.count, this.direction);
        }

        public PopDirection getDirection() {
            return this.direction;
        }

        @Nullable
        public Long getTimeout() {
            return this.timeout;
        }

        @Nullable
        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public long getCount() {
            return this.count;
        }
    }

    public static class ZScoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer value;

        private ZScoreCommand(@Nullable ByteBuffer key, ByteBuffer value) {
            super(key);
            this.value = value;
        }

        public static ZScoreCommand scoreOf(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new ZScoreCommand(null, member);
        }

        public ZScoreCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZScoreCommand(key, this.value);
        }

        public ByteBuffer getValue() {
            return this.value;
        }
    }

    public static class ZMScoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Collection<ByteBuffer> values;

        private ZMScoreCommand(@Nullable ByteBuffer key, Collection<ByteBuffer> values) {
            super(key);
            this.values = values;
        }

        public static ZMScoreCommand scoreOf(ByteBuffer member) {
            Assert.notNull((Object)member, (String)"Member must not be null!");
            return new ZMScoreCommand(null, Collections.singletonList(member));
        }

        public static ZMScoreCommand scoreOf(Collection<ByteBuffer> members) {
            Assert.notNull(members, (String)"Members must not be null!");
            return new ZMScoreCommand(null, members);
        }

        public ZMScoreCommand forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZMScoreCommand(key, this.values);
        }

        public Collection<ByteBuffer> getValues() {
            return this.values;
        }
    }

    public static class ZRemRangeByRankCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<Long> range;

        private ZRemRangeByRankCommand(ByteBuffer key, Range<Long> range) {
            super(key);
            this.range = range;
        }

        public static ZRemRangeByRankCommand valuesWithin(Range<Long> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRemRangeByRankCommand(null, range);
        }

        public ZRemRangeByRankCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRemRangeByRankCommand(key, this.range);
        }

        public Range<Long> getRange() {
            return this.range;
        }
    }

    public static class ZRemRangeByScoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<Double> range;

        private ZRemRangeByScoreCommand(@Nullable ByteBuffer key, Range<Double> range) {
            super(key);
            this.range = range;
        }

        public static ZRemRangeByScoreCommand scoresWithin(Range<Double> range) {
            return new ZRemRangeByScoreCommand(null, range);
        }

        public ZRemRangeByScoreCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRemRangeByScoreCommand(key, this.range);
        }

        public Range<Double> getRange() {
            return this.range;
        }
    }

    public static class ZRemRangeByLexCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<String> range;

        private ZRemRangeByLexCommand(@Nullable ByteBuffer key, Range<String> range) {
            super(key);
            this.range = range;
        }

        public static ZRemRangeByLexCommand lexWithin(Range<String> range) {
            return new ZRemRangeByLexCommand(null, range);
        }

        public ZRemRangeByLexCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRemRangeByLexCommand(key, this.range);
        }

        public Range<String> getRange() {
            return this.range;
        }
    }

    public static class ZDiffCommand
    implements ReactiveRedisConnection.Command {
        private final List<ByteBuffer> keys;

        private ZDiffCommand(List<ByteBuffer> keys) {
            this.keys = keys;
        }

        public static ZDiffCommand sets(Collection<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new ZDiffCommand(new ArrayList<ByteBuffer>(keys));
        }

        @Override
        @Nullable
        public ByteBuffer getKey() {
            return null;
        }

        public List<ByteBuffer> getKeys() {
            return this.keys;
        }
    }

    public static class ZDiffStoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> sourceKeys;

        private ZDiffStoreCommand(@Nullable ByteBuffer key, List<ByteBuffer> sourceKeys) {
            super(key);
            this.sourceKeys = sourceKeys;
        }

        public static ZDiffStoreCommand sourceKeys(Collection<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new ZDiffStoreCommand(null, new ArrayList<ByteBuffer>(keys));
        }

        public ZDiffStoreCommand storeAs(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZDiffStoreCommand(key, this.sourceKeys);
        }

        public List<ByteBuffer> getSourceKeys() {
            return this.sourceKeys;
        }
    }

    public static class ZAggregateCommand
    implements ReactiveRedisConnection.Command {
        private final List<ByteBuffer> sourceKeys;
        private final List<Double> weights;
        @Nullable
        private final RedisZSetCommands.Aggregate aggregateFunction;

        private ZAggregateCommand(List<ByteBuffer> sourceKeys, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregate) {
            this.sourceKeys = sourceKeys;
            this.weights = weights;
            this.aggregateFunction = aggregate;
        }

        public static ZAggregateCommand sets(List<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new ZAggregateCommand(new ArrayList<ByteBuffer>(keys), Collections.emptyList(), null);
        }

        public ZAggregateCommand applyWeights(List<Double> weights) {
            return new ZAggregateCommand(this.sourceKeys, weights, this.aggregateFunction);
        }

        public ZAggregateCommand applyWeights(RedisZSetCommands.Weights weights) {
            return this.applyWeights(weights.toList());
        }

        public ZAggregateCommand aggregateUsing(@Nullable RedisZSetCommands.Aggregate aggregateFunction) {
            return new ZAggregateCommand(this.sourceKeys, this.weights, aggregateFunction);
        }

        @Override
        @Nullable
        public ByteBuffer getKey() {
            return null;
        }

        public List<ByteBuffer> getSourceKeys() {
            return this.sourceKeys;
        }

        public List<Double> getWeights() {
            return this.weights;
        }

        public Optional<RedisZSetCommands.Aggregate> getAggregateFunction() {
            return Optional.ofNullable(this.aggregateFunction);
        }
    }

    public static class ZInterStoreCommand
    extends ZAggregateStoreCommand {
        private ZInterStoreCommand(ByteBuffer key, List<ByteBuffer> sourceKeys, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregate) {
            super(key, sourceKeys, weights, aggregate);
        }

        public static ZInterStoreCommand sets(List<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new ZInterStoreCommand(null, new ArrayList<ByteBuffer>(keys), Collections.emptyList(), null);
        }

        @Override
        public ZInterStoreCommand applyWeights(List<Double> weights) {
            return new ZInterStoreCommand(this.getKey(), this.getSourceKeys(), weights, this.getAggregateFunction().orElse(null));
        }

        @Override
        public ZInterStoreCommand applyWeights(RedisZSetCommands.Weights weights) {
            return this.applyWeights((List)weights.toList());
        }

        @Override
        public ZInterStoreCommand aggregateUsing(@Nullable RedisZSetCommands.Aggregate aggregateFunction) {
            return new ZInterStoreCommand(this.getKey(), this.getSourceKeys(), this.getWeights(), aggregateFunction);
        }

        @Override
        public ZInterStoreCommand storeAs(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZInterStoreCommand(key, this.getSourceKeys(), this.getWeights(), this.getAggregateFunction().orElse(null));
        }
    }

    public static class ZAggregateStoreCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final List<ByteBuffer> sourceKeys;
        private final List<Double> weights;
        @Nullable
        private final RedisZSetCommands.Aggregate aggregateFunction;

        private ZAggregateStoreCommand(@Nullable ByteBuffer key, List<ByteBuffer> sourceKeys, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregate) {
            super(key);
            this.sourceKeys = sourceKeys;
            this.weights = weights;
            this.aggregateFunction = aggregate;
        }

        public static ZAggregateStoreCommand sets(List<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new ZAggregateStoreCommand(null, new ArrayList<ByteBuffer>(keys), Collections.emptyList(), null);
        }

        public ZAggregateStoreCommand applyWeights(List<Double> weights) {
            return new ZAggregateStoreCommand(this.getKey(), this.sourceKeys, weights, this.aggregateFunction);
        }

        public ZAggregateStoreCommand applyWeights(RedisZSetCommands.Weights weights) {
            return this.applyWeights(weights.toList());
        }

        public ZAggregateStoreCommand aggregateUsing(@Nullable RedisZSetCommands.Aggregate aggregateFunction) {
            return new ZAggregateStoreCommand(this.getKey(), this.sourceKeys, this.weights, aggregateFunction);
        }

        public ZAggregateStoreCommand storeAs(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZAggregateStoreCommand(key, this.sourceKeys, this.weights, this.aggregateFunction);
        }

        public List<ByteBuffer> getSourceKeys() {
            return this.sourceKeys;
        }

        public List<Double> getWeights() {
            return this.weights;
        }

        public Optional<RedisZSetCommands.Aggregate> getAggregateFunction() {
            return Optional.ofNullable(this.aggregateFunction);
        }
    }

    public static class ZUnionStoreCommand
    extends ZAggregateStoreCommand {
        private ZUnionStoreCommand(@Nullable ByteBuffer key, List<ByteBuffer> sourceKeys, List<Double> weights, @Nullable RedisZSetCommands.Aggregate aggregate) {
            super(key, sourceKeys, weights, aggregate);
        }

        public static ZUnionStoreCommand sets(List<ByteBuffer> keys) {
            Assert.notNull(keys, (String)"Keys must not be null!");
            return new ZUnionStoreCommand(null, new ArrayList<ByteBuffer>(keys), Collections.emptyList(), null);
        }

        @Override
        public ZUnionStoreCommand applyWeights(List<Double> weights) {
            return new ZUnionStoreCommand(this.getKey(), this.getSourceKeys(), weights, this.getAggregateFunction().orElse(null));
        }

        @Override
        public ZUnionStoreCommand applyWeights(RedisZSetCommands.Weights weights) {
            return this.applyWeights((List)weights.toList());
        }

        @Override
        public ZUnionStoreCommand aggregateUsing(@Nullable RedisZSetCommands.Aggregate aggregateFunction) {
            return new ZUnionStoreCommand(this.getKey(), this.getSourceKeys(), this.getWeights(), aggregateFunction);
        }

        @Override
        public ZUnionStoreCommand storeAs(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZUnionStoreCommand(key, this.getSourceKeys(), this.getWeights(), this.getAggregateFunction().orElse(null));
        }
    }

    public static class ZRangeByLexCommand
    extends ReactiveRedisConnection.KeyCommand {
        private final Range<String> range;
        private final Sort.Direction direction;
        private final RedisZSetCommands.Limit limit;

        private ZRangeByLexCommand(@Nullable ByteBuffer key, Range<String> range, Sort.Direction direction, RedisZSetCommands.Limit limit) {
            super(key);
            this.range = range;
            this.direction = direction;
            this.limit = limit;
        }

        public static ZRangeByLexCommand stringsWithin(Range<String> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeByLexCommand(null, range, Sort.Direction.ASC, RedisZSetCommands.Limit.unlimited());
        }

        public static ZRangeByLexCommand reverseStringsWithin(Range<String> range) {
            Assert.notNull(range, (String)"Range must not be null!");
            return new ZRangeByLexCommand(null, range, Sort.Direction.DESC, RedisZSetCommands.Limit.unlimited());
        }

        public ZRangeByLexCommand from(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new ZRangeByLexCommand(key, this.range, this.direction, this.limit);
        }

        public ZRangeByLexCommand limitTo(RedisZSetCommands.Limit limit) {
            Assert.notNull((Object)limit, (String)"Limit must not be null!");
            return new ZRangeByLexCommand(this.getKey(), this.range, this.direction, limit);
        }

        public Range<String> getRange() {
            return this.range;
        }

        public RedisZSetCommands.Limit getLimit() {
            return this.limit;
        }

        public Sort.Direction getDirection() {
            return this.direction;
        }
    }

    public static enum PopDirection {
        MIN,
        MAX;

    }
}

