/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.convert;

import java.io.StringReader;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.convert.MapToPropertiesConverter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class Converters {
    private static final Log LOGGER = LogFactory.getLog(Converters.class);
    private static final byte[] ONE = new byte[]{49};
    private static final byte[] ZERO = new byte[]{48};
    private static final String CLUSTER_NODES_LINE_SEPARATOR = "\n";

    public static <T> Converter<T, T> identityConverter() {
        return t -> t;
    }

    public static Boolean stringToBoolean(String source) {
        return ObjectUtils.nullSafeEquals((Object)"OK", (Object)source);
    }

    public static Converter<String, Boolean> stringToBooleanConverter() {
        return Converters::stringToBoolean;
    }

    public static Converter<String, Properties> stringToProps() {
        return Converters::toProperties;
    }

    public static Converter<Long, Boolean> longToBoolean() {
        return Converters::toBoolean;
    }

    public static Converter<String, DataType> stringToDataType() {
        return Converters::toDataType;
    }

    public static Properties toProperties(String source) {
        Properties info = new Properties();
        try (StringReader stringReader = new StringReader(source);){
            info.load(stringReader);
        }
        catch (Exception ex) {
            throw new RedisSystemException("Cannot read Redis info", ex);
        }
        return info;
    }

    public static Properties toProperties(Map<?, ?> source) {
        Properties target = new Properties();
        target.putAll(source);
        return target;
    }

    public static Boolean toBoolean(@Nullable Long source) {
        return source != null && source == 1L;
    }

    public static DataType toDataType(String source) {
        return DataType.fromCode(source);
    }

    public static byte[] toBit(Boolean source) {
        return source != false ? ONE : ZERO;
    }

    protected static RedisClusterNode toClusterNode(String clusterNodesLine) {
        return ClusterNodesConverter.INSTANCE.convert(clusterNodesLine);
    }

    public static Set<RedisClusterNode> toSetOfRedisClusterNodes(Collection<String> lines) {
        if (CollectionUtils.isEmpty(lines)) {
            return Collections.emptySet();
        }
        LinkedHashSet<RedisClusterNode> nodes = new LinkedHashSet<RedisClusterNode>(lines.size());
        for (String line : lines) {
            nodes.add(Converters.toClusterNode(line));
        }
        return nodes;
    }

    public static Set<RedisClusterNode> toSetOfRedisClusterNodes(String clusterNodes) {
        if (!StringUtils.hasText((String)clusterNodes)) {
            return Collections.emptySet();
        }
        String[] lines = clusterNodes.split(CLUSTER_NODES_LINE_SEPARATOR);
        return Converters.toSetOfRedisClusterNodes(Arrays.asList(lines));
    }

    public static List<Object> toObjects(Set<RedisZSetCommands.Tuple> tuples) {
        ArrayList<Object> tupleArgs = new ArrayList<Object>(tuples.size() * 2);
        for (RedisZSetCommands.Tuple tuple : tuples) {
            tupleArgs.add(tuple.getScore());
            tupleArgs.add(tuple.getValue());
        }
        return tupleArgs;
    }

    public static Long toTimeMillis(String seconds, String microseconds) {
        return (Long)NumberUtils.parseNumber((String)seconds, Long.class) * 1000L + (Long)NumberUtils.parseNumber((String)microseconds, Long.class) / 1000L;
    }

    public static Long toTimeMillis(String seconds, String microseconds, TimeUnit unit) {
        long secondValue = TimeUnit.SECONDS.toMicros((Long)NumberUtils.parseNumber((String)seconds, Long.class));
        long microValue = (Long)NumberUtils.parseNumber((String)microseconds, Long.class);
        return unit.convert(secondValue + microValue, TimeUnit.MICROSECONDS);
    }

    public static long secondsToTimeUnit(long seconds, TimeUnit targetUnit) {
        Assert.notNull((Object)((Object)targetUnit), (String)"TimeUnit must not be null!");
        if (seconds > 0L) {
            return targetUnit.convert(seconds, TimeUnit.SECONDS);
        }
        return seconds;
    }

    public static Converter<Long, Long> secondsToTimeUnit(TimeUnit timeUnit) {
        return seconds -> Converters.secondsToTimeUnit(seconds, timeUnit);
    }

    public static long millisecondsToTimeUnit(long milliseconds, TimeUnit targetUnit) {
        Assert.notNull((Object)((Object)targetUnit), (String)"TimeUnit must not be null!");
        if (milliseconds > 0L) {
            return targetUnit.convert(milliseconds, TimeUnit.MILLISECONDS);
        }
        return milliseconds;
    }

    public static Converter<Long, Long> millisecondsToTimeUnit(TimeUnit timeUnit) {
        return seconds -> Converters.millisecondsToTimeUnit(seconds, timeUnit);
    }

    public static <V> Converter<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<V>>> deserializingGeoResultsConverter(RedisSerializer<V> serializer) {
        return new DeserializingGeoResultsConverter<V>(serializer);
    }

    public static Converter<Double, Distance> distanceConverterForMetric(Metric metric) {
        return DistanceConverterFactory.INSTANCE.forMetric(metric);
    }

    public static Properties toProperties(List<String> input) {
        Assert.notNull(input, (String)"Input list must not be null!");
        Assert.isTrue((input.size() % 2 == 0 ? 1 : 0) != 0, (String)"Input list must contain an even number of entries!");
        Properties properties = new Properties();
        for (int i = 0; i < input.size(); i += 2) {
            properties.setProperty(input.get(i), input.get(i + 1));
        }
        return properties;
    }

    public static Converter<List<String>, Properties> listToPropertiesConverter() {
        return Converters::toProperties;
    }

    public static <K, V> Converter<Map<K, V>, Properties> mapToPropertiesConverter() {
        return MapToPropertiesConverter.INSTANCE;
    }

    @Nullable
    public static Duration secondsToDuration(@Nullable Long seconds) {
        return seconds != null ? Duration.ofSeconds(seconds) : null;
    }

    public static <T> T parse(Object source, Class<T> targetType) {
        return targetType.cast(Converters.parse(source, "root", Collections.singletonMap("root", targetType)));
    }

    public static Object parse(Object source, String sourcePath, Map<String, Class<?>> typeHintMap) {
        List sourceCollection;
        String path = sourcePath;
        Class<Object> targetType = typeHintMap.get(path);
        if (targetType == null) {
            Object alternatePath = sourcePath.contains(".") ? sourcePath.substring(0, sourcePath.lastIndexOf(".")) + ".*" : sourcePath;
            targetType = typeHintMap.get(alternatePath);
            if (targetType == null) {
                targetType = sourcePath.endsWith("[]") ? String.class : source.getClass();
            } else if (targetType == Map.class && sourcePath.endsWith("[]")) {
                targetType = String.class;
            } else {
                path = alternatePath;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("parsing %s (%s) as %s.", sourcePath, path, targetType));
        }
        if (targetType == Object.class) {
            return source;
        }
        if (ClassUtils.isAssignable(String.class, targetType)) {
            if (source instanceof String) {
                return source.toString();
            }
            if (source instanceof byte[]) {
                return new String((byte[])source);
            }
            if (source instanceof ByteBuffer) {
                return new String(ByteUtils.getBytes((ByteBuffer)source));
            }
        }
        if (ClassUtils.isAssignable(List.class, targetType) && source instanceof List) {
            sourceCollection = (List)source;
            ArrayList<Object> targetList = new ArrayList<Object>();
            for (int i = 0; i < sourceCollection.size(); ++i) {
                targetList.add(Converters.parse(sourceCollection.get(i), sourcePath + ".[" + i + "]", typeHintMap));
            }
            return targetList;
        }
        if (ClassUtils.isAssignable(Map.class, targetType) && source instanceof List) {
            sourceCollection = (List)source;
            LinkedHashMap<String, Object> targetMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < sourceCollection.size(); i += 2) {
                String key = Converters.parse(sourceCollection.get(i), path + ".[]", typeHintMap).toString();
                targetMap.put(key, Converters.parse(sourceCollection.get(i + 1), path + "." + key, typeHintMap));
            }
            return targetMap;
        }
        return source;
    }

    public static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    static enum ClusterNodesConverter implements Converter<String, RedisClusterNode>
    {
        INSTANCE;

        private static final Map<String, RedisClusterNode.Flag> flagLookupMap;
        static final int ID_INDEX = 0;
        static final int HOST_PORT_INDEX = 1;
        static final int FLAGS_INDEX = 2;
        static final int MASTER_ID_INDEX = 3;
        static final int LINK_STATE_INDEX = 7;
        static final int SLOTS_INDEX = 8;

        public RedisClusterNode convert(String source) {
            String[] args = source.split(" ");
            String[] hostAndPort = StringUtils.split((String)args[1], (String)":");
            Assert.notNull((Object)hostAndPort, (String)"ClusterNode information does not define host and port!");
            RedisClusterNode.SlotRange range = this.parseSlotRange(args);
            Set<RedisClusterNode.Flag> flags = this.parseFlags(args);
            String portPart = hostAndPort[1];
            if (portPart.contains("@")) {
                portPart = portPart.substring(0, portPart.indexOf(64));
            }
            RedisClusterNode.RedisClusterNodeBuilder nodeBuilder = RedisClusterNode.newRedisClusterNode().listeningAt(hostAndPort[0], Integer.valueOf(portPart)).withId(args[0]).promotedAs(flags.contains((Object)RedisClusterNode.Flag.MASTER) ? RedisNode.NodeType.MASTER : RedisNode.NodeType.SLAVE).serving(range).withFlags(flags).linkState(this.parseLinkState(args));
            if (!args[3].isEmpty() && !args[3].startsWith("-")) {
                nodeBuilder.slaveOf(args[3]);
            }
            return nodeBuilder.build();
        }

        private Set<RedisClusterNode.Flag> parseFlags(String[] args) {
            String raw = args[2];
            LinkedHashSet<RedisClusterNode.Flag> flags = new LinkedHashSet<RedisClusterNode.Flag>(8, 1.0f);
            if (StringUtils.hasText((String)raw)) {
                for (String flag : raw.split(",")) {
                    flags.add(flagLookupMap.get(flag));
                }
            }
            return flags;
        }

        private RedisClusterNode.LinkState parseLinkState(String[] args) {
            String raw = args[7];
            if (StringUtils.hasText((String)raw)) {
                return RedisClusterNode.LinkState.valueOf(raw.toUpperCase());
            }
            return RedisClusterNode.LinkState.DISCONNECTED;
        }

        private RedisClusterNode.SlotRange parseSlotRange(String[] args) {
            LinkedHashSet<Integer> slots = new LinkedHashSet<Integer>();
            for (int i = 8; i < args.length; ++i) {
                String raw = args[i];
                if (raw.startsWith("[")) continue;
                if (raw.contains("-")) {
                    String[] slotRange = StringUtils.split((String)raw, (String)"-");
                    if (slotRange == null) continue;
                    int from = Integer.valueOf(slotRange[0]);
                    int to = Integer.valueOf(slotRange[1]);
                    for (int slot = from; slot <= to; ++slot) {
                        slots.add(slot);
                    }
                    continue;
                }
                slots.add(Integer.valueOf(raw));
            }
            return new RedisClusterNode.SlotRange(slots);
        }

        static {
            flagLookupMap = new LinkedHashMap<String, RedisClusterNode.Flag>(RedisClusterNode.Flag.values().length, 1.0f);
            for (RedisClusterNode.Flag flag : RedisClusterNode.Flag.values()) {
                flagLookupMap.put(flag.getRaw(), flag);
            }
        }
    }

    static class DeserializingGeoResultsConverter<V>
    implements Converter<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<V>>> {
        final RedisSerializer<V> serializer;

        public DeserializingGeoResultsConverter(RedisSerializer<V> serializer) {
            this.serializer = serializer;
        }

        public GeoResults<RedisGeoCommands.GeoLocation<V>> convert(GeoResults<RedisGeoCommands.GeoLocation<byte[]>> source) {
            ArrayList<GeoResult> values = new ArrayList<GeoResult>(source.getContent().size());
            for (GeoResult value : source.getContent()) {
                values.add(new GeoResult(new RedisGeoCommands.GeoLocation<V>(this.serializer.deserialize((byte[])((RedisGeoCommands.GeoLocation)value.getContent()).getName()), ((RedisGeoCommands.GeoLocation)value.getContent()).getPoint()), value.getDistance()));
            }
            return new GeoResults(values, source.getAverageDistance().getMetric());
        }
    }

    static enum DistanceConverterFactory {
        INSTANCE;


        DistanceConverter forMetric(@Nullable Metric metric) {
            return new DistanceConverter(ObjectUtils.nullSafeEquals((Object)Metrics.NEUTRAL, (Object)metric) ? RedisGeoCommands.DistanceUnit.METERS : metric);
        }

        static class DistanceConverter
        implements Converter<Double, Distance> {
            private final Metric metric;

            DistanceConverter(Metric metric) {
                this.metric = ObjectUtils.nullSafeEquals((Object)Metrics.NEUTRAL, (Object)metric) ? RedisGeoCommands.DistanceUnit.METERS : metric;
            }

            public Distance convert(Double source) {
                return new Distance(source.doubleValue(), this.metric);
            }
        }
    }
}

